/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.lcdui.LCDUIUtils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Row;

public class Gauge
extends Item {
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private int max;
    private int value;
    private boolean interactive;
    private long lastIncrementTime;
    private boolean continuosDir;
    private int continuosValue;
    private static long continousIncTime = 1L;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        super(label);
        this.interactive = interactive;
        this.setMaxValue(maxValue);
        this.setValue(initialValue);
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    @Override
    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    @Override
    public void addCommand(Command cmd) {
        super.addCommand(cmd);
    }

    @Override
    public void setItemCommandListener(ItemCommandListener l) {
        super.setItemCommandListener(l);
    }

    @Override
    public void setPreferredSize(int w, int h2) {
        super.setPreferredSize(w, h2);
    }

    @Override
    public void setDefaultCommand(Command cmd) {
        super.setDefaultCommand(cmd);
    }

    public void setValue(int value) {
        if (this.max == -1) {
            if (value < 0) {
                value = 0;
            } else if (value > 3) {
                value = 3;
            }
        } else if (value < 0) {
            value = 0;
        } else if (value > this.max) {
            value = this.max;
        }
        this.value = value;
        this.repaintForm();
    }

    public int getValue() {
        return this.value;
    }

    public void setMaxValue(int maxValue) {
        if (this.interactive && maxValue == -1 || maxValue != -1 && maxValue <= 0) {
            throw new IllegalArgumentException();
        }
        if (maxValue != this.max) {
            this.value = 0;
        }
        if (maxValue != -1 && this.value > maxValue) {
            this.value = maxValue;
        }
        this.max = maxValue;
        this.repaintForm();
    }

    public int getMaxValue() {
        return this.max;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    void paint(Graphics g, int x, int y, int w, int h2) {
        super.paint(g, x, y, w, h2);
        Font font = Item.font;
        g.setFont(font);
        h2 = font.getHeight();
        int yoff = 0;
        if (this.label != null) {
            g.drawString(this.label, x, y, 0);
            yoff += h2 + 4;
        }
        if (!this.interactive) {
            int max = this.max;
            int val = this.value;
            if (max == -1) {
                switch (this.value) {
                    case -1: {
                        break;
                    }
                    default: {
                        max = 50;
                        this.continuosValue = !this.continuosDir ? ++this.continuosValue : --this.continuosValue;
                        if (this.continuosValue >= max || this.continuosValue < 0) {
                            this.continuosDir = !this.continuosDir;
                        }
                        val = this.continuosValue;
                    }
                }
            }
            g.setColor(LCDUIUtils.borderColor);
            g.drawRect(x + 2, y + yoff, w -= 4, h2);
            if (max <= 0 || val < 0) {
                return;
            }
            g.setColor(LCDUIUtils.gaugeColor);
            g.fillRect(x + 4, y + yoff + 2, (int)((double)w * ((double)val / (double)max)) - 3, h2 - 3);
        } else {
            int xoff1 = Item.font.stringWidth("0") + 2;
            int xoff2 = Item.font.stringWidth(Integer.toString(this.max)) + 2;
            g.drawString("0", x + 2, y + yoff, 0);
            g.drawString(Integer.toString(this.max), x + w - xoff2 + 2, y + yoff, 0);
            g.setColor(LCDUIUtils.borderColor);
            g.drawRect(x + xoff1, y + yoff, w -= xoff1 + xoff2, h2);
            int val = this.value;
            if (this.max <= 0 || val < 0) {
                return;
            }
            g.setColor(LCDUIUtils.gaugeColor);
            g.fillRect(x + 2 + xoff1, y + yoff + 2, (int)((double)w * ((double)val / (double)this.max)) - 3, h2 - 3);
        }
    }

    @Override
    void layout(Row row) {
        super.layout(row);
        Font font = Item.font;
        if (!this.interactive) {
            int n2 = font.getHeight() + 4;
            if (this.label != null) {
                n2 += font.getHeight() + 4;
            }
            this.bounds[3] = n2;
        } else {
            int n2 = font.getHeight() + 4;
            if (this.label != null) {
                n2 += font.getHeight() + 4;
            }
            this.bounds[3] = n2;
        }
    }

    @Override
    public int getMinimumWidth() {
        return Item.font.stringWidth("Some example text") + 6;
    }

    @Override
    public int getMinimumHeight() {
        return (Item.font.getHeight() + 4) * (this.hasLabel() ? 2 : 1);
    }

    @Override
    boolean isFocusable() {
        return true;
    }

    @Override
    boolean keyScroll(int key, boolean repeat) {
        if (this.interactive) {
            if (key == 2) {
                if (--this.value < 0) {
                    this.value = 0;
                    return false;
                }
                this.notifyStateChanged();
                return true;
            }
            if (key == 5) {
                if (++this.value > this.max) {
                    this.value = this.max;
                    return false;
                }
                this.notifyStateChanged();
                return true;
            }
        }
        return false;
    }
}

