/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.jblend.graphics.j3d.Effect3D;
import com.jblend.graphics.j3d.Texture;
import com.motorola.graphics.j3d.FigureLayout;
import com.motorola.graphics.j3d.RenderProxy;
import com.vodafone.v10.graphics.j3d.Figure;
import com.vodafone.v10.graphics.j3d.Graphics3D;
import emulator.Emulator;
import emulator.Settings;
import emulator.debug.Profiler;
import emulator.graphics2D.GraphicsUtils;
import emulator.graphics2D.IGraphics2D;
import emulator.graphics2D.IImage;
import emulator.graphics2D.ITransform;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class Graphics
implements Graphics3D,
com.motorola.graphics.j3d.Graphics3D,
com.jblend.graphics.j3d.Graphics3D {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    IGraphics2D impl;
    IImage image;
    IImage copyimage;
    IGraphics2D xrayGraphics;
    IImage xrayImage;
    static Vector xrayCache = new Vector();
    int tx = 0;
    int ty = 0;
    Font font;
    int[] anIntArray521 = new int[6];
    private int alpha;
    private boolean alphaSet;

    public Graphics(IImage i1, IImage i2) {
        this.image = i1;
        this.impl = i1.createGraphics();
        if (i2 != null) {
            this.xrayImage = i2;
            this.xrayGraphics = i2.createGraphics();
            this.xrayGraphics.setAlpha(60);
        }
        this.alpha = 255;
        this.setFont(Font.getDefaultFont());
    }

    public Graphics(IImage anIImage517) {
        this.image = anIImage517;
        this.impl = anIImage517.createGraphics();
        this.setFont(Font.getDefaultFont());
    }

    void dispose() {
        this.xrayImage = null;
        this.xrayGraphics = null;
        this.image = null;
        this.impl = null;
    }

    public IGraphics2D getImpl() {
        if (Settings.xrayView && this.xrayGraphics != null) {
            return this.xrayGraphics;
        }
        return this.impl;
    }

    public IImage getImage() {
        return this.image;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ++Profiler.drawCallCount;
        ITransform transform = this.impl.getTransform().newTransform(n3, n4, 0, n5, n6, n7);
        if (this.copyimage == null) {
            this.copyimage = Emulator.getEmulator().newImage(this.image.getWidth(), this.image.getHeight(), false);
        }
        this.image.cloneImage(this.copyimage);
        this._drawRegion(this.copyimage, n, n2, n3, n4, transform, 0xFFFFFF);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.impl.clipRect(n, n2, n3, n4);
        if (this.xrayGraphics != null) {
            this.xrayGraphics.clipRect(n, n2, n3, n4);
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        ++Profiler.drawCallCount;
        this.impl.drawArc(n, n2, n3 + 1, n4 + 1, n5, n6);
        this.xrayDrawArc(n, n2, n3 + 1, n4 + 1, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        ++Profiler.drawCallCount;
        this.impl.drawLine(n, n2, n3, n4);
        this.xrayDrawLine(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        ++Profiler.drawCallCount;
        this.impl.drawRect(n, n2, n3, n4);
        this.xrayDrawRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ++Profiler.drawCallCount;
        this.impl.drawRoundRect(n, n2, n3, n4, n5, n6);
        this.xrayDrawRect(n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2, int n3) {
        block13: {
            int height;
            int n5;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                ++Profiler.drawCallCount;
                                if (image == null) {
                                    throw new NullPointerException();
                                }
                                if (!Graphics.method294(n3, 64)) {
                                    throw new IllegalArgumentException();
                                }
                                if ((n3 & 8) == 0) break block8;
                                n5 = n;
                                height = image.getWidth();
                                break block9;
                            }
                            if ((n3 & 1) == 0) break block10;
                            n5 = n;
                            height = image.getWidth() / 2;
                        }
                        n = n5 - height;
                    }
                    if ((n3 & 0x20) == 0) break block11;
                    n5 = n2;
                    height = image.getHeight();
                    break block12;
                }
                if ((n3 & 2) == 0) break block13;
                n5 = n2;
                height = image.getHeight() / 2;
            }
            n2 = n5 - height;
        }
        this.impl.drawImage(image.getImpl(), n, n2);
        this.updateDebugData(image, 0, 0, n, n2, image.getWidth(), image.getHeight());
        ++image.usedCount;
        ++Profiler.drawImageCallCount;
        Profiler.drawImagePixelCount += image.getWidth() * image.getHeight();
    }

    public void drawRegion(IImage image, int n, int n2, int n3, int n4, ITransform transform, int n5) {
        ++Profiler.drawCallCount;
        this._drawRegion(image, n, n2, n3, n4, transform, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _drawRegion(IImage image, int n, int n2, int n3, int n4, ITransform transform, int n5) {
        Graphics graphics = this;
        synchronized (graphics) {
            ITransform transform2 = this.impl.getTransform();
            this.impl.transform(transform);
            this.impl.drawImage(image, n, n2, n3, n4, 0, 0, n3, n4);
            this.impl.setTransform(transform2);
            if (n5 >= 0 && Settings.xrayView && this.xrayGraphics != null) {
                this.xrayGraphics.transform(transform);
                if (Settings.xrayOverlapScreen) {
                    this.xrayGraphics.drawImage(image, n, n2, n3, n4, 0, 0, n3, n4);
                }
                this.xrayFillRect(0, 0, n3, n4, n5);
                this.xrayGraphics.setTransform(transform2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _drawRegion(IImage image, int n, int n2, int n3, int n4, int n5, int n6, ITransform transform) {
        Graphics graphics = this;
        synchronized (graphics) {
            ITransform transform2 = this.impl.getTransform();
            this.impl.transform(transform);
            this.impl.drawImage(image, 0, 0, n5, n6, n, n2, n + n3, n2 + n4);
            this.impl.setTransform(transform2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRegion(Image image, int sx, int sy, int w, int h2, int t, int dx, int dy, int a2) {
        ++Profiler.drawCallCount;
        if (image == null) {
            throw new NullPointerException();
        }
        if (sx < 0 || sx + w > image.getWidth() || sy < 0 || sy + h2 > image.getHeight()) {
            throw new IllegalArgumentException("region exceeds the bounds of the source image");
        }
        if (image.getImpl() == this.image) {
            throw new IllegalArgumentException("src is the same image as the destination of this Graphics object");
        }
        if (!Graphics.method294(a2, 64)) {
            throw new IllegalArgumentException();
        }
        Graphics graphics = this;
        synchronized (graphics) {
            ITransform transform2 = this.impl.getTransform();
            ITransform transform = transform2.newTransform(w, h2, t, dx, dy, a2);
            this.impl.transform(transform);
            this.impl.drawImage(image.getImpl(), sx, sy, w, h2, 0, 0, w, h2);
            this.impl.setTransform(transform2);
            if (this.xrayGraphics != null) {
                this.xrayGraphics.transform(transform);
                this.updateDebugData(image, sx, sy, 0, 0, w, h2);
                this.xrayGraphics.setTransform(transform2);
            } else {
                this.updateDebugData(image, sx, sy, 0, 0, w, h2);
            }
        }
        ++image.usedCount;
        ++Profiler.drawRegionCallCount;
        Profiler.drawRegionPixelCount += Math.abs(w * h2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _drawRegion(Image image, int sx, int sy, int w, int h2, int t, int dx, int dy, int dw, int dh, int a2) {
        ++Profiler.drawCallCount;
        if (image == null) {
            throw new NullPointerException();
        }
        if (sx < 0 || sx + w > image.getWidth() || sy < 0 || sy + h2 > image.getHeight()) {
            throw new IllegalArgumentException("region exceeds the bounds of the source image");
        }
        if (image.getImpl() == this.image) {
            throw new IllegalArgumentException("src is the same image as the destination of this Graphics object");
        }
        if (!Graphics.method294(a2, 64)) {
            throw new IllegalArgumentException();
        }
        Graphics graphics = this;
        synchronized (graphics) {
            ITransform transform2 = this.impl.getTransform();
            ITransform transform = transform2.newTransform(w, h2, t, dx, dy, a2);
            this.impl.transform(transform);
            this.impl.drawImage(image.getImpl(), sx, sy, w, h2, 0, 0, dw, dh);
            this.impl.setTransform(transform2);
            if (this.xrayGraphics != null) {
                this.xrayGraphics.transform(transform);
                this.updateDebugData(image, sx, sy, 0, 0, dw, dh);
                this.xrayGraphics.setTransform(transform2);
            } else {
                this.updateDebugData(image, sx, sy, 0, 0, dw, dh);
            }
        }
        ++image.usedCount;
        ++Profiler.drawRegionCallCount;
        Profiler.drawRegionPixelCount += Math.abs(w * h2);
    }

    public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        ++Profiler.drawCallCount;
        if (rgbData == null) {
            throw new NullPointerException();
        }
        this._drawRegion(GraphicsUtils.setImageData(rgbData, processAlpha, offset, scanlength, width, height), 0, 0, width, height, this.impl.getTransform().newTransform(width, height, 0, x, y, 0), 0xFF0000);
        ++Profiler.drawRGBCallCount;
        Profiler.drawRGBPixelCount += Math.abs(width * height);
    }

    public void drawChar(char c2, int n, int n2, int n3) {
        this.drawString(new String(new char[]{c2}), n, n2, n3);
    }

    public void drawChars(char[] array, int n, int n2, int n3, int n4, int n5) {
        this.drawString(new String(array, n, n2), n3, n4, n5);
    }

    public void drawSubstring(String s, int n, int n2, int n3, int n4, int n5) {
        this.drawString(s.substring(n, n + n2), n3, n4, n5);
    }

    public void drawString(String s, int x, int y, int a2) {
        ++Profiler.drawCallCount;
        if (s == null) {
            throw new NullPointerException();
        }
        if (!Graphics.method294(a2, 2)) {
            throw new IllegalArgumentException();
        }
        Font font = this.font;
        int stringWidth = font.stringWidth(s);
        int height = font.getHeight();
        this.impl.setFont(font.getImpl());
        if ((a2 & 8) != 0) {
            x -= stringWidth;
        } else if ((a2 & 1) != 0) {
            x -= stringWidth / 2;
        }
        if ((a2 & 0x20) != 0) {
            y -= height;
        } else if ((a2 & 2) != 0) {
            y -= height / 2;
        } else if ((a2 & 0x40) != 0) {
            y -= font.getBaselinePosition();
        }
        this.impl.drawString(s, x, y + font.getBaselinePosition());
        if (font.isUnderlined()) {
            this.impl.drawLine(x, y + height, x + stringWidth, y + height);
        }
        if (this.xrayGraphics != null) {
            this.xrayFillRect(x, y, stringWidth, height, 255);
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        ++Profiler.drawCallCount;
        this.impl.fillArc(n, n2, n3, n4, n5, n6);
        if (this.xrayGraphics != null) {
            this.xrayFillArc(n, n2, n3, n4, n5, n6);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        ++Profiler.drawCallCount;
        this.impl.fillRect(n, n2, n3, n4);
        if (this.xrayGraphics != null) {
            this.xrayFillRect(n, n2, n3, n4, 0xFFFFFF);
        }
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        ++Profiler.drawCallCount;
        this.impl.fillRoundRect(n, n2, n3, n4, n5, n6);
        if (this.xrayGraphics != null) {
            this.xrayFillRect(n, n2, n3, n4, 0xFFFFFF);
        }
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        ++Profiler.drawCallCount;
        this.anIntArray521[0] = n;
        this.anIntArray521[1] = n2;
        this.anIntArray521[2] = n3;
        this.anIntArray521[3] = n4;
        this.anIntArray521[4] = n5;
        this.anIntArray521[5] = n6;
        this.impl.fillPolygon(this.anIntArray521);
    }

    private void updateDebugData(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int clipX = n3;
        int clipY = n4;
        int clipX2 = n3 + n5;
        int clipY2 = n4 + n6;
        int curClipX = this.getClipX();
        int curClipY = this.getClipY();
        int curClipW = this.getClipWidth();
        int curClipH = this.getClipHeight();
        if (clipX < curClipX) {
            clipX = curClipX;
        }
        if (clipX2 < curClipX) {
            clipX2 = curClipX;
        }
        if (clipY < curClipY) {
            clipY = curClipY;
        }
        if (clipY2 < curClipY) {
            clipY2 = curClipY;
        }
        if (clipX > curClipX + curClipW) {
            clipX = curClipX + curClipW;
        }
        if (clipX2 > curClipX + curClipW) {
            clipX2 = curClipX + curClipW;
        }
        if (clipY > curClipY + curClipH) {
            clipY = curClipY + curClipH;
        }
        if (clipY2 > curClipY + curClipH) {
            clipY2 = curClipY + curClipH;
        }
        int n7 = clipX2 - clipX;
        int n8 = clipY2 - clipY;
        int n9 = clipX - (n3 - n);
        int n10 = clipY - (n4 - n2);
        image.getUsedRegion().setAlpha(n9, n10, n7, n8, 0);
        if (!Settings.xrayView || this.xrayGraphics == null) {
            return;
        }
        if (Settings.xrayOverlapScreen) {
            this.xrayGraphics.drawImage(image.getImpl(), n, n2, n5, n6, n3, n4, n5, n6);
        }
        if (image.isMutable() && image.getXRayBuffer() != null) {
            this.xrayGraphics.drawImage(image.getXRayBuffer(), n3, n4);
        }
        this.xrayFillRect(n3, n4, n5, n6, 0xFFFFFF);
        if (Settings.xrayShowClipBorder) {
            this.xrayGraphics.setColor(255, false);
            this.xrayGraphics.drawRect(n9 + n3 - n, n10 + n4 - n2, n7 - 1, n8 - 1);
            this.xrayGraphics.setColor(0, false);
            this.xrayGraphics.fillRect(n9 - 1 + n3 - n, n10 - 1 + n4 - n2, 3, 3);
        }
    }

    private void xrayFillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (Settings.xrayView && this.xrayGraphics != null) {
            this.xrayGraphics.setColor(0xFFFFFF, false);
            this.xrayGraphics.fillArc(n, n2, n3, n4, n5, n6);
            this.xrayUpdate();
        }
    }

    private void xrayDrawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (Settings.xrayView && this.xrayGraphics != null) {
            this.xrayGraphics.setColor(0xFFFFFF, false);
            this.xrayGraphics.drawArc(n, n2, n3, n4, n5, n6);
            this.xrayUpdate();
        }
    }

    private void xrayFillRect(int n, int n2, int n3, int n4, int n5) {
        if (Settings.xrayView && this.xrayGraphics != null) {
            this.xrayGraphics.setColor(n5, false);
            this.xrayGraphics.fillRect(n, n2, n3, n4);
            this.xrayUpdate();
        }
    }

    private void xrayDrawRect(int n, int n2, int n3, int n4) {
        if (Settings.xrayView && this.xrayGraphics != null) {
            this.xrayGraphics.setColor(0xFFFFFF, false);
            this.xrayGraphics.drawRect(n, n2, n3, n4);
            this.xrayUpdate();
        }
    }

    private void xrayDrawLine(int n, int n2, int n3, int n4) {
        if (Settings.xrayView && this.xrayGraphics != null) {
            this.xrayGraphics.setColor(0xFFFFFF, false);
            this.xrayGraphics.drawLine(n, n2, n3, n4);
            this.xrayUpdate();
        }
    }

    private void xrayUpdate() {
        if (!xrayCache.contains(this.xrayImage)) {
            xrayCache.add(this.xrayImage);
        }
    }

    protected static void resetXRayCache() {
        for (int i2 = xrayCache.size() - 1; i2 >= 0; --i2) {
            IImage image = (IImage)xrayCache.get(i2);
            IGraphics2D graphics = image.getGraphics();
            graphics.setColor(0, false);
            graphics.setAlpha(255);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            graphics.setAlpha(60);
        }
        xrayCache.clear();
    }

    public int getClipHeight() {
        return this.impl.getClipHeight();
    }

    public int getClipWidth() {
        return this.impl.getClipWidth();
    }

    public int getClipX() {
        return this.impl.getClipX();
    }

    public int getClipY() {
        return this.impl.getClipY();
    }

    public int getColor() {
        return this.impl.getColor();
    }

    public Font getFont() {
        return this.font;
    }

    public int getGreenComponent() {
        return this.impl.getColorGreen();
    }

    public int getRedComponent() {
        return this.impl.getColorRed();
    }

    public int getBlueComponent() {
        return this.impl.getColorBlue();
    }

    public int getTranslateX() {
        return this.tx;
    }

    public int getTranslateY() {
        return this.ty;
    }

    public void setClip(int n, int n2, int n3, int n4) {
        ++Profiler.drawCallCount;
        this.impl.setClip(n, n2, n3, n4);
        if (this.xrayGraphics != null) {
            this.xrayGraphics.setClip(n, n2, n3, n4);
        }
    }

    public void setColor(int n) {
        ++Profiler.drawCallCount;
        this.alpha = 255;
        if (this.alphaSet) {
            this.impl.setAlpha(255);
            this.alphaSet = false;
        }
        this.impl.setColor(n, false);
    }

    public void _setColor(int n) {
        ++Profiler.drawCallCount;
        this.alpha = n >> 24;
        if (this.alphaSet) {
            this.impl.setAlpha(255);
            this.alphaSet = false;
        }
        this.impl.setColor(n, true);
    }

    public void setColor(int n, int n2, int n3) {
        ++Profiler.drawCallCount;
        this.alpha = 255;
        if (this.alphaSet) {
            this.impl.setAlpha(255);
            this.alphaSet = false;
        }
        this.impl.setColor(n, n2, n3);
    }

    public void setFont(Font font) {
        ++Profiler.drawCallCount;
        this.font = font == null ? Font.getDefaultFont() : font;
        this.impl.setFont(this.font.getImpl());
    }

    public int getGrayScale() {
        return (int)(255.0f * this.impl.RGBtoHSB(this.getRedComponent(), this.getGreenComponent(), this.getBlueComponent())[2]);
    }

    public void setGrayScale(int n) {
        if ((n & 0xFFFFFF00) > 0) {
            throw new IllegalArgumentException();
        }
        this.setColor(n, n, n);
    }

    public void translate(int x, int y) {
        ++Profiler.drawCallCount;
        this.tx += x;
        this.ty += y;
        this.impl.translate(x, y);
        if (this.xrayGraphics != null) {
            this.xrayGraphics.translate(x, y);
        }
    }

    public int getDisplayColor(int n) {
        return n;
    }

    public void setStrokeStyle(int strokeStyle) {
        ++Profiler.drawCallCount;
        this.impl.setStrokeStyle(strokeStyle);
    }

    public int getStrokeStyle() {
        return this.impl.getStrokeStyle();
    }

    private static boolean method294(int n, int n2) {
        if (n == 0) {
            return true;
        }
        boolean b2 = n > 0 && n < 128 && (n & n2) == 0;
        if (b2) {
            int n3 = n & 0x72;
            boolean bl = b2 = n3 != 0 && (n3 & n3 - 1) == 0;
        }
        if (b2) {
            int n4 = n & 0xD;
            b2 = n4 != 0 && (n4 & n4 - 1) == 0;
        }
        return b2;
    }

    public void _reset(IImage i1, IImage i2) {
        if (i1 != this.image) {
            this.image = i1;
            this.impl = i1.createGraphics();
        }
        if (i2 != this.xrayImage) {
            this.xrayImage = i2;
            if (i2 != null) {
                this.xrayGraphics = i2.createGraphics();
                this.xrayGraphics.setAlpha(60);
            } else {
                this.xrayGraphics = null;
            }
        }
        this._reset();
    }

    void _reset() {
        this.setColor(0);
        this.setFont(Font.getDefaultFont());
        this.setStrokeStyle(0);
        this.translate(-this.tx, -this.ty);
        this.tx = 0;
        this.ty = 0;
        this.impl.reset();
        if (this.xrayGraphics != null) {
            this.xrayGraphics.reset();
        }
    }

    @Override
    public synchronized void drawFigure(Figure figure, int x, int y, com.vodafone.v10.graphics.j3d.FigureLayout layout, com.vodafone.v10.graphics.j3d.Effect3D effect) {
        com.vodafone.v10.graphics.j3d.RenderProxy.drawFigure(this, figure, x, y, layout, effect);
    }

    @Override
    public synchronized void drawFigure(com.motorola.graphics.j3d.Figure figure, int x, int y, FigureLayout layout, com.motorola.graphics.j3d.Effect3D effect) {
        RenderProxy.drawFigure(this, figure, x, y, layout, effect);
    }

    @Override
    public void drawCommandList(Texture[] textures, int x, int y, com.jblend.graphics.j3d.FigureLayout layout, Effect3D effect, int[] commandlist) {
        com.jblend.graphics.j3d.RenderProxy.drawCommandList(this, textures, x, y, layout, effect, commandlist);
    }

    @Override
    public void drawCommandList(Texture texture, int x, int y, com.jblend.graphics.j3d.FigureLayout layout, Effect3D effect, int[] commandlist) {
        com.jblend.graphics.j3d.RenderProxy.drawCommandList(this, texture, x, y, layout, effect, commandlist);
    }

    @Override
    public void drawFigure(com.jblend.graphics.j3d.Figure figure, int x, int y, com.jblend.graphics.j3d.FigureLayout layout, Effect3D effect) {
        com.jblend.graphics.j3d.RenderProxy.drawFigure(this, figure, x, y, layout, effect);
    }

    @Override
    public void flush() {
        com.jblend.graphics.j3d.RenderProxy.flush(this);
    }

    @Override
    public void renderFigure(com.jblend.graphics.j3d.Figure figure, int x, int y, com.jblend.graphics.j3d.FigureLayout layout, Effect3D effect) {
        com.jblend.graphics.j3d.RenderProxy.renderFigure(this, figure, x, y, layout, effect);
    }

    @Override
    public void renderPrimitives(Texture texture, int x, int y, com.jblend.graphics.j3d.FigureLayout layout, Effect3D effect, int command, int numPrimitives, int[] vertexCoords, int[] normals, int[] textureCoords, int[] colors) {
        com.jblend.graphics.j3d.RenderProxy.renderPrimitives(this, texture, x, y, layout, effect, command, numPrimitives, vertexCoords, normals, textureCoords, colors);
    }

    public Graphics _copy() {
        Graphics g = new Graphics(this.image, this.xrayImage);
        g.translate(this.tx, this.ty);
        g.setColor(this.getColor());
        g.setClip(this.getClipX(), this.getClipY(), this.getClipWidth(), this.getClipHeight());
        g.setStrokeStyle(this.getStrokeStyle());
        return g;
    }

    public int _getWidth() {
        return this.image.getWidth();
    }

    public int _getHeight() {
        return this.image.getHeight();
    }

    public void setAlpha(int a2) {
        this.alphaSet = true;
        this.alpha = a2;
        this.impl.setAlpha(this.alpha);
    }

    public void setAlphaColor(int ARGB) {
        this._setColor(ARGB);
    }

    public void setAlphaColor(int a2, int r, int g, int b2) {
        this._setColor(a2 << 24 | r << 16 | g << 8 | b2);
    }

    public int getAlpha() {
        return this.alpha;
    }
}

