/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.Settings;
import emulator.custom.ResourceManager;
import emulator.debug.Profiler;
import emulator.graphics2D.GraphicsUtils;
import emulator.graphics2D.IImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Image {
    private boolean mutable;
    private IImage imageImpl;
    private IImage xrayBuffer;
    private IImage usedRegion;
    int usedCount;
    private boolean disposed;

    public Image(IImage img) {
        this.imageImpl = img;
        this.usedRegion = Emulator.getEmulator().newImage(this.imageImpl.getWidth(), this.imageImpl.getHeight(), true);
        this.resetUsedRegion();
        Profiler.totalImagePixelCount += this.getWidth() * this.getHeight();
        ++Profiler.totalImageInstances;
    }

    public void finalize() {
        Profiler.totalImagePixelCount -= this.getWidth() * this.getHeight();
        --Profiler.totalImageInstances;
    }

    public IImage getImpl() {
        return this.imageImpl;
    }

    protected IImage getXRayBuffer() {
        if (this.xrayBuffer == null && Settings.xrayView) {
            this.xrayBuffer = Emulator.getEmulator().newImage(this.getWidth(), this.getHeight(), true);
        }
        return this.xrayBuffer;
    }

    public IImage getUsedRegion() {
        return this.usedRegion;
    }

    public void resetUsedRegion() {
        this.usedRegion.setAlpha(0, 0, this.getWidth(), this.getHeight(), 128);
        this.usedCount = 0;
    }

    public int getUsedCount() {
        return this.usedCount;
    }

    public Graphics getGraphics() {
        if (this.xrayBuffer == null && Settings.xrayView) {
            this.xrayBuffer = Emulator.getEmulator().newImage(this.getWidth(), this.getHeight(), true);
        }
        return new Graphics(this.imageImpl, this.xrayBuffer);
    }

    public int getWidth() {
        return this.imageImpl.getWidth();
    }

    public int getHeight() {
        return this.imageImpl.getHeight();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private static Image decode(byte[] array) throws IllegalArgumentException {
        try {
            return new Image(Emulator.getEmulator().newImage(array));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Emulator.getEmulator().getLogStream().println("*** createImage error!! check it ***");
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static Image createImage(byte[] array, int n, int n2) {
        byte[] array2 = new byte[n2];
        System.arraycopy(array, n, array2, 0, n2);
        return Image.decode(array2);
    }

    public static Image createImage(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            return Image.decode(ResourceManager.getBytes(inputStream));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
    }

    public static Image createImage(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        Image image = new Image(Emulator.getEmulator().newImage(n, n2, false));
        new Image(Emulator.getEmulator().newImage(n, n2, false)).mutable = true;
        if (Settings.xrayView) {
            image.xrayBuffer = Emulator.getEmulator().newImage(n, n2, true);
        }
        return image;
    }

    public static Image createImage(int n, int n2, int color) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        Image image = new Image(Emulator.getEmulator().newImage(n, n2, true, color));
        new Image(Emulator.getEmulator().newImage(n, n2, true, color)).mutable = true;
        if (Settings.xrayView) {
            image.xrayBuffer = Emulator.getEmulator().newImage(n, n2, true, color);
        }
        return image;
    }

    public static Image createImage(Image image) {
        return Image.createImage(image, 0, 0, image.getWidth(), image.getHeight(), 0);
    }

    public static Image createImage(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean b2 = n5 != 4 && n5 != 5 && n5 != 6 && n5 != 7;
        int n6 = b2 ? n3 : n4;
        int n7 = b2 ? n4 : n3;
        Image image2 = new Image(Emulator.getEmulator().newImage(n6, n7, true, 0));
        new Image(Emulator.getEmulator().newImage(n6, n7, true, 0)).mutable = true;
        if (Settings.xrayView) {
            image2.xrayBuffer = Emulator.getEmulator().newImage(n6, n7, true, 0);
        }
        image2.getGraphics().drawRegion(image, n, n2, n3, n4, n5, 0, 0, 20);
        image2.mutable = false;
        return image2;
    }

    public static Image createImage(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            return Image.createImage(ResourceManager.getResourceAsStream(string));
        }
        catch (Exception ex) {
            throw new IOException(string, ex);
        }
    }

    public static Image createRGBImage(int[] array, int n, int n2, boolean b2) {
        Image image = new Image(Emulator.getEmulator().newImage(n, n2, b2));
        GraphicsUtils.setImageData(image.imageImpl, array, b2, 0, n, n, n2);
        return image;
    }

    public void getRGB(int[] array, int n, int n2, int n3, int n4, int n5, int n6) {
        GraphicsUtils.getImageData(this.imageImpl, array, n, n2, n3, n4, n5, n6);
    }

    public static Image createImage(InputStream var0, int var1) throws IOException {
        ByteArrayOutputStream var2 = new ByteArrayOutputStream();
        byte[] var3 = new byte[512];
        if (var1 == 8) {
            var2.write(137);
            var2.write(80);
            var2.write(78);
            var2.write(71);
            var2.write(13);
            var2.write(10);
            var2.write(26);
            var2.write(10);
        }
        while (var0.available() > 0) {
            int var4 = var0.read(var3);
            var2.write(var3, 0, var4);
        }
        byte[] b2 = var2.toByteArray();
        return Image.createImage(b2, 0, b2.length);
    }

    void dispose() {
        this.imageImpl = null;
        this.usedRegion = null;
        this.disposed = true;
    }

    public int size() {
        if (this.disposed) {
            return 5;
        }
        int i2 = 5 + this.imageImpl.size();
        if (this.xrayBuffer != null) {
            i2 += this.xrayBuffer.size();
        }
        if (this.usedRegion != null) {
            i2 += this.usedRegion.size();
        }
        return i2;
    }
}

