/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Row;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private Image image;
    private String altText;
    private int appearanceMode;
    private int width;

    public ImageItem(String s, Image image, int n, String s2) {
        this(s, image, n, s2, 0);
    }

    public ImageItem(String s, Image anImage427, int anInt178, String aString25, int anInt179) {
        super(s);
        if (anInt179 < 0 || anInt179 > 2) {
            throw new IllegalArgumentException();
        }
        this.image = anImage427;
        this.layout = anInt178;
        this.altText = aString25;
        this.appearanceMode = anInt179;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image anImage427) {
        this.image = anImage427;
        this.layoutForm();
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String aString25) {
        this.altText = aString25;
    }

    @Override
    public int getLayout() {
        return super.getLayout();
    }

    @Override
    public void setLayout(int layout) {
        super.setLayout(layout);
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    @Override
    void paint(Graphics g, int x, int y, int w, int h2) {
        super.paint(g, x, y, w, h2);
        int yo = y;
        if (this.labelArr != null && this.labelArr.length > 0) {
            g.setFont(this.labelFont);
            g.setColor(this.focused ? LCDUIUtils.highlightedForegroundColor : this.labelColor);
            for (String s : this.labelArr) {
                g.drawString(s, x + (w - this.labelFont.stringWidth(s)) / 2, yo + 2, 0);
                yo += this.labelFont.getHeight() + 4;
            }
        }
        if (this.appearanceMode == 2) {
            g.setColor(LCDUIUtils.borderColor);
            int lx = x + w - 1;
            int ly = y + h2 - 3;
            g.drawLine(x + 1, ly, lx, ly);
            g.drawLine(lx, ly, lx, y + 1);
            g.setColor(this.focused ? LCDUIUtils.highlightedForegroundColor : LCDUIUtils.foregroundColor);
            g.drawRect(x, y, w, h2 - 2);
        }
        if (this.image != null) {
            int iw = Math.min(w, this.image.getWidth());
            g.drawRegion(this.image, 0, 0, iw, Math.min(h2 - yo + y, this.image.getHeight()), 0, x + (w - iw) / 2, yo, 0);
        }
    }

    @Override
    void layout(Row row) {
        super.layout(row);
        int n = 0;
        int w = row.getAvailableWidth(this.screen.bounds[2]);
        int[] tw = new int[1];
        if (this.hasLabel()) {
            int min = this.labelFont.stringWidth("...") + 2;
            if (w < min) {
                w = min;
            }
            this.labelArr = TextUtils.textArr(this.label, this.labelFont, w, w, tw);
            n = (this.labelFont.getHeight() + 4) * this.labelArr.length;
        } else {
            this.labelArr = null;
        }
        int iw = 0;
        if (this.image != null) {
            iw = this.image.getWidth();
            n += this.image.getHeight() + 4;
        }
        this.width = Math.max(iw + 2, tw[0] + 5);
        this.bounds[3] = n;
    }

    @Override
    public int getPreferredWidth() {
        if (super.isSizeLocked() && this.preferredWidth != -1) {
            return this.preferredWidth;
        }
        return this.width + 2;
    }

    @Override
    public int getMinimumWidth() {
        int w = this.getPreferredWidth();
        if (w < 4) {
            int m2;
            int n = w = this.image != null ? this.image.getWidth() + 4 : 4;
            if (this.hasLabel() && w < (m2 = this.labelFont.stringWidth("...") + 2)) {
                w = m2;
            }
        }
        return w;
    }

    @Override
    public int getMinimumHeight() {
        return this.bounds[3];
    }

    @Override
    boolean isFocusable() {
        return !(this.commands.size() <= 0 && this.appearanceMode != 2 || this.image == null && !this.hasLabel());
    }
}

