/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.lcdui.LCDUIUtils;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Row;
import javax.microedition.lcdui.Screen;

public abstract class Item {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int W = 2;
    public static final int H = 3;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    static final int anInt24 = 32563;
    static final Font font = Font.getFont(0, 1, 8);
    int[] bounds;
    boolean focused;
    Command defaultCommand;
    public ItemCommandListener itemCommandListener;
    public Vector<Command> commands;
    String label;
    String[] labelArr;
    Screen screen;
    int layout;
    int preferredWidth = -1;
    int preferredHeight = -1;
    int[] anIntArray179;
    private boolean sizeLocked;
    boolean hidden;
    Font labelFont = font;
    int labelColor = LCDUIUtils.foregroundColor;

    Item(String label) {
        this.label = label;
        this.screen = null;
        this.commands = new Vector();
        this.bounds = new int[4];
    }

    public void setLabel(String label) {
        this.label = label;
        this.layoutForm();
    }

    public String getLabel() {
        return this.label;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        if ((layout & 0xFFFF80CC) != 0) {
            throw new IllegalArgumentException();
        }
        this.layout = layout;
        this.layoutForm();
    }

    public void addCommand(Command command) {
        if (this.screen instanceof Alert) {
            throw new IllegalStateException();
        }
        if (command == null) {
            throw new NullPointerException();
        }
        if (!this.commands.contains(command)) {
            int i2;
            for (i2 = 0; i2 < this.commands.size(); ++i2) {
                Command command2 = this.commands.get(i2);
                if (command.getCommandType() > command2.getCommandType() || command.getCommandType() == command2.getCommandType() && command.getPriority() <= command2.getPriority()) break;
            }
            this.commands.add(i2, command);
            if (this.screen != null && Emulator.getCurrentDisplay().getCurrent() == this.screen) {
                this.screen.updateCommands();
            }
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.contains(command)) {
            if (command == this.defaultCommand) {
                this.defaultCommand = null;
            }
            this.commands.remove(command);
            if (this.screen != null && Emulator.getCurrentDisplay().getCurrent() == this.screen) {
                this.screen.updateCommands();
            }
        }
    }

    public void setItemCommandListener(ItemCommandListener itemCommandListener) {
        if (this.screen instanceof Alert) {
            throw new IllegalStateException();
        }
        this.itemCommandListener = itemCommandListener;
    }

    protected void _itemApplyCommand() {
        if (this.itemCommandListener != null && this.defaultCommand != null) {
            Emulator.getEventQueue().commandAction(this.defaultCommand, this);
        }
    }

    public int getPreferredWidth() {
        int w;
        if (this.preferredWidth != -1) {
            return this.preferredWidth;
        }
        if (this._hasLayout(1024) && (w = this.getMinimumWidth()) > 0) {
            return w;
        }
        return this.bounds[2];
    }

    public int getPreferredHeight() {
        return this.preferredHeight != -1 ? this.preferredHeight : this.bounds[3];
    }

    public void setPreferredSize(int w, int h2) {
        if (this.screen instanceof Alert) {
            throw new IllegalStateException();
        }
        this.preferredWidth = w;
        this.preferredHeight = h2;
        this.sizeLocked = w != -1 || h2 != -1;
        this.layoutForm();
    }

    public int getMinimumWidth() {
        return 0;
    }

    public int getMinimumHeight() {
        return 0;
    }

    public void setDefaultCommand(Command aCommand174) {
        if (this.screen instanceof Alert) {
            throw new IllegalStateException();
        }
        this.defaultCommand = aCommand174;
        if (this.defaultCommand != null) {
            this.addCommand(aCommand174);
        }
    }

    public void notifyStateChanged() {
        if (this.screen == null || !(this.screen instanceof Form)) {
            return;
        }
        Emulator.getEventQueue().itemStateChanged(this);
    }

    void focus() {
        this.focused = true;
        if (this.screen != null) {
            this.screen.setItemCommands(this);
        }
    }

    void defocus() {
        this.focused = false;
        if (this.screen != null) {
            this.screen.removeItemCommands(this);
        }
    }

    void paint(Graphics g, int x, int y, int w, int h2, int line) {
        this.paint(g, x, y, w, h2);
    }

    void paint(Graphics g, int x, int y, int w, int h2) {
        g.setColor(LCDUIUtils.foregroundColor);
        if (this.focused) {
            LCDUIUtils.drawSelectedItemBackground(g, x, y, w, h2);
        }
    }

    void layout(Row row) {
        this.bounds[0] = 0;
        this.bounds[1] = 0;
        this.bounds[2] = this.screen.bounds[2];
        this.bounds[3] = Screen.fontHeight4;
    }

    protected void pointerPressed(int n, int n2) {
    }

    public boolean _hasLayout(int l) {
        return (this.layout & l) == l;
    }

    boolean isFocusable() {
        return false;
    }

    boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    void layoutForm() {
        if (this.screen != null && this.screen instanceof Form) {
            ((Form)this.screen).queueLayout(this);
        }
    }

    void repaintForm() {
        if (this.screen != null) {
            this.screen.repaintScreen(this);
        }
    }

    boolean isSizeLocked() {
        return this.sizeLocked;
    }

    void hidden() {
        this.hidden = true;
    }

    boolean keyScroll(int key, boolean repeat) {
        return false;
    }

    public Screen _getParent() {
        return this.screen;
    }

    public void _callCommandAction(Command cmd) {
        if (this.itemCommandListener != null && cmd != null) {
            this.itemCommandListener.commandAction(cmd, this);
        }
    }

    public void _setLabelFont(Font font) {
        this.labelFont = font == null ? Screen.font : font;
    }

    public void _setLabelColor(int color) {
        this.labelColor = color;
    }
}

