/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

class Row {
    ArrayList<RowItem> items = new ArrayList();
    int width;
    int height;
    int y;
    int dir;

    Row(int y, int dir) {
        this.y = y;
        this.dir = dir;
    }

    void paint(Graphics g, int y, int w) {
        int x = this.dir == 2 ? w - this.width : (this.dir == 3 ? (w - this.width) / 2 : 0);
        int rowHeight = this.height;
        int l = this.items.size();
        for (int i2 = 0; i2 < l; ++i2) {
            RowItem o = this.items.get(i2);
            Item item = o.item;
            int availableWidth = w - x;
            int itemWidth = o.getWidth(availableWidth);
            int itemHeight = rowHeight;
            int itemy = y;
            if (!item._hasLayout(8192) && (itemHeight = o.getHeight()) != rowHeight) {
                if (item._hasLayout(48)) {
                    itemy += (rowHeight - itemHeight) / 2;
                } else if (!item._hasLayout(16)) {
                    itemy += rowHeight - itemHeight;
                }
            }
            o.x = x;
            o.y = itemy - y;
            o.width = itemWidth;
            o.height = itemHeight;
            item.hidden = false;
            item.paint(g, x, itemy, itemWidth, itemHeight, o.row);
            x += itemWidth;
        }
    }

    int getHeight() {
        return this.height;
    }

    int getWidth(int available) {
        int x = 0;
        for (RowItem o : this.items) {
            x += o.getWidth(available - x);
        }
        return x;
    }

    int getAvailableWidth(int max) {
        return max - this.getWidth(max);
    }

    void add(Item item, int maxWidth) {
        RowItem o = new RowItem(item, 0, this.width);
        this.items.add(o);
        this.width += o.getWidth(maxWidth - this.width);
        int h2 = o.getHeight();
        if (h2 > this.height) {
            this.height = h2;
        }
    }

    void add(Item item, int itemRow, int maxWidth) {
        RowItem o = new RowItem(item, itemRow, this.width);
        this.items.add(o);
        this.width += o.getWidth(maxWidth - this.width);
        int h2 = o.getHeight();
        if (h2 > this.height) {
            this.height = h2;
        }
    }

    boolean canAdd(Item item, int maxWidth) {
        if (this.items.isEmpty()) {
            return true;
        }
        Item lastItem = this.items.get((int)(this.items.size() - 1)).item;
        return !item._hasLayout(256) && !lastItem._hasLayout(512) && this.width != maxWidth && this.width + (item._hasLayout(1024) ? item.getMinimumWidth() : item.getPreferredWidth()) < maxWidth;
    }

    boolean contains(Item item) {
        for (RowItem o : this.items) {
            if (o.item != item) continue;
            return true;
        }
        return false;
    }

    Item getFirstItem() {
        try {
            return this.items.get((int)0).item;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public void hidden() {
        for (RowItem o : this.items) {
            Item item = o.item;
            if (item.hidden) continue;
            item.hidden();
        }
    }

    public Item getFirstFocusableItem() {
        for (RowItem o : this.items) {
            Item item = o.item;
            if (!item.isFocusable()) continue;
            return item;
        }
        return null;
    }

    public int indexOf(Item item) {
        int l = this.items.size();
        for (int i2 = 0; i2 < l; ++i2) {
            if (this.items.get((int)i2).item != item) continue;
            return i2;
        }
        return -1;
    }

    static class RowItem {
        Item item;
        int row;
        int x;
        int y;
        int width;
        int height;

        RowItem(Item item, int i2, int x) {
            this.item = item;
            this.row = i2;
            this.x = x;
        }

        int getWidth(int available) {
            int w = this.item instanceof StringItem && ((StringItem)this.item).getAppearanceMode() != 2 && !this.item.isSizeLocked() && !this.item.hasLabel() ? ((StringItem)this.item).getRowWidth(this.row) : this.item.getPreferredWidth();
            if (w > available) {
                return available;
            }
            if (w == -1 || this.item._hasLayout(2048)) {
                return available;
            }
            return w;
        }

        int getHeight() {
            if (this.item instanceof StringItem && ((StringItem)this.item).getAppearanceMode() != 2 && !this.item.isSizeLocked() && !this.item.hasLabel()) {
                return ((StringItem)this.item).getRowHeight(this.row);
            }
            return this.item.getPreferredHeight();
        }

        public String toString() {
            return "{RowItem:" + this.item + "}";
        }
    }
}

