/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.KeyMapping;
import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.TextUtils;
import java.util.Vector;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class Screen
extends Displayable {
    static final Font font = Font.getDefaultFont();
    static final int fontHeight = font.getHeight();
    static final int fontHeight4 = fontHeight + 4;
    final Vector items;
    int scroll;

    Screen() {
        this("");
    }

    Screen(String s) {
        this.title = s == null ? "" : s;
        this.items = new Vector();
    }

    public void _invokeKeyPressed(int n) {
        if (this._isSWT()) {
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(1)) {
            this._keyScroll(1, false);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(6)) {
            this._keyScroll(6, false);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(2)) {
            this._keyScroll(2, false);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(5)) {
            this._keyScroll(5, false);
            return;
        }
        if (this.focusedItem != null && this.focusedItem instanceof CustomItem) {
            ((CustomItem)this.focusedItem).keyPressed(n);
            return;
        }
        if (this.focusedItem != null && n == KeyMapping.getArrowKeyFromDevice(8)) {
            this.focusedItem._itemApplyCommand();
            return;
        }
    }

    public void _invokeKeyRepeated(int n) {
        if (this._isSWT()) {
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(1)) {
            this._keyScroll(1, true);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(6)) {
            this._keyScroll(6, true);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(2)) {
            this._keyScroll(2, true);
            return;
        }
        if (n == KeyMapping.getArrowKeyFromDevice(5)) {
            this._keyScroll(5, true);
            return;
        }
        if (this.focusedItem != null && this.focusedItem instanceof CustomItem) {
            ((CustomItem)this.focusedItem).keyRepeated(n);
            return;
        }
    }

    protected void _keyScroll(int key, boolean repeat) {
    }

    public void _invokeKeyReleased(int n) {
        if (n == KeyMapping.getArrowKeyFromDevice(1) || n == KeyMapping.getArrowKeyFromDevice(6) || n == KeyMapping.getArrowKeyFromDevice(2) || n == KeyMapping.getArrowKeyFromDevice(5)) {
            return;
        }
        if (this.focusedItem != null && this.focusedItem instanceof CustomItem) {
            ((CustomItem)this.focusedItem).keyReleased(n);
            return;
        }
    }

    public boolean _invokePointerPressed(int x, int y) {
        return false;
    }

    public void _invokePointerReleased(int n, int n2) {
    }

    public void _invokePointerDragged(int n, int n2) {
    }

    protected abstract void _paint(Graphics var1);

    public void _invokePaint(Graphics graphics) {
        if (this._isSWT()) {
            return;
        }
        Displayable._resetXRayGraphics();
        int color = graphics.getColor();
        int strokeStyle = graphics.getStrokeStyle();
        Font font = graphics.getFont();
        graphics.setFont(Screen.font);
        graphics.setStrokeStyle(0);
        LCDUIUtils.drawDisplayableBackground(graphics, 0, 0, this.w, this.h, false);
        this._drawTitleBar(graphics);
        this._paint(graphics);
        this._drawScrollBar(graphics);
        this._paintTicker(graphics);
        this._paintSoftMenu(graphics);
        graphics.setColor(color);
        graphics.setFont(font);
        graphics.setStrokeStyle(strokeStyle);
    }

    protected void _drawTitleBar(Graphics graphics) {
        if (this._isSWT()) {
            return;
        }
        String title = this.title == null ? "" : this.title.trim();
        int n = this.focusedItem != null ? this.items.indexOf(this.focusedItem) + 1 : this.items.size();
        String value = String.valueOf(n);
        int n2 = (fontHeight4 >> 1) - 1;
        int stringWidth2 = font.stringWidth(value);
        int w = this.w - stringWidth2 - 16 - font.stringWidth("...");
        if (w > 16) {
            String[] s = TextUtils.textArr(title, font, w, w);
            title = s.length == 0 ? "" : (s.length != 1 ? s[0] + "..." : s[0]);
        }
        int stringWidth = font.stringWidth(title);
        int n3 = (this.w - stringWidth >> 1) + 2;
        int n4 = this.w - stringWidth2 - 2;
        graphics.setColor(8617456);
        graphics.fillRect(2, n2, (this.w - stringWidth >> 1) - 2, 2);
        graphics.fillRect(n3 + stringWidth + 2, n2, n4 - n3 - stringWidth - 4, 2);
        graphics.setColor(LCDUIUtils.foregroundColor);
        graphics.setFont(font);
        graphics.drawString(title, n3, 1, 0);
        graphics.drawString(value, n4, 1, 0);
    }

    @Override
    protected void sizeChanged(int w, int h2) {
    }

    @Override
    void _invokeSizeChanged(int w, int h2, boolean b2) {
        super._invokeSizeChanged(w, h2, b2);
    }

    protected void _drawScrollBar(Graphics graphics) {
        LCDUIUtils.drawScrollbar(graphics, this.bounds[2] + 1, fontHeight4 - 1, 2, this.bounds[3] - 2, this.items.size(), this.focusedItem != null ? this.items.indexOf(this.focusedItem) : -1);
    }

    public int _repaintInterval() {
        return -1;
    }

    public boolean _isSWT() {
        return false;
    }

    public void _swtShown() {
    }

    public void _swtHidden() {
    }

    public void _swtUpdateSizes() {
    }

    public Object _getSwtContent() {
        return null;
    }
}

