/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Row;
import javax.microedition.lcdui.Screen;

public class StringItem
extends Item {
    private String text;
    private int mode;
    Font font;
    String[] textArr;
    private int width;
    private int textColor = LCDUIUtils.foregroundColor;
    private int focusableTextColor = LCDUIUtils.highlightedForegroundColor;
    private int focusedColor = LCDUIUtils.highlightedForegroundColor;
    private int focusedBackgroundColor = LCDUIUtils.highlightedBackgroundColor;

    public StringItem(String label, String text) {
        this(label, text, 0);
    }

    public StringItem(String s, String text, int mode) {
        super(s);
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException();
        }
        this.setText(text);
        this.mode = mode;
        this.font = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String aString25) {
        this.text = aString25 == null ? "" : aString25;
        this.layoutForm();
    }

    public int getAppearanceMode() {
        return this.mode;
    }

    public void setFont(Font aFont358) {
        this.font = aFont358;
        this.layoutForm();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void setPreferredSize(int w, int h2) {
        super.setPreferredSize(w, h2);
    }

    @Override
    void paint(Graphics g, int x, int y, int w, int h2, int row) {
        Font font;
        Font font2 = font = this.font != null ? this.font : Screen.font;
        if (this.mode == 2) {
            if (this.focused) {
                g.setColor(this.focusedBackgroundColor);
                g.fillRect(x + 2, y + 2, w - 4, h2 - 4);
            }
            String str = null;
            if (this.textArr != null && this.textArr.length != 0) {
                str = this.textArr[0];
            }
            if (str == null) {
                str = this.text;
            }
            if (str == null) {
                str = "...";
            }
            int yo = y;
            if (this.hasLabel()) {
                g.setFont(this.labelFont);
                g.setColor(this.focused ? this.focusedColor : this.labelColor);
                String label = this.label.trim();
                String[] tmp = TextUtils.textArr(label, this.labelFont, w, w);
                g.drawString(tmp[0], x + 2, yo, 0);
                yo += this.labelFont.getHeight() + 4;
            }
            g.setFont(font);
            g.setColor(this.focused ? this.focusedColor : this.textColor);
            int textWidth = font.stringWidth(str);
            g.drawString(str, x + (w - textWidth) / 2, yo, 0);
            g.setColor(LCDUIUtils.borderColor);
            int lx = x + w - 3;
            int ly = yo + h2 - yo + y - 3;
            g.drawLine(x + 2, ly, lx, ly);
            g.drawLine(lx, ly, lx, yo + 1);
            g.setColor(this.focused ? this.focusedColor : LCDUIUtils.foregroundColor);
            g.drawRect(x + 2, yo, w - 4, h2 - yo + y - 2);
        } else {
            if (this.focused) {
                g.setColor(this.focusedBackgroundColor);
                g.fillRect(x + 1, y + 1, w - 2, h2 - 2);
                g.setColor(this.focusedColor);
                g.drawRect(x, y + 1, w, h2 - 2);
            }
            if (this.isSizeLocked() || this.hasLabel()) {
                if (row != 0) {
                    return;
                }
                g.setFont(this.labelFont);
                g.setColor(this.focused ? this.focusedColor : this.labelColor);
                if (this.labelArr != null) {
                    for (String s : this.labelArr) {
                        g.drawString(s, x, y, 0);
                        y += this.labelFont.getHeight() + 4;
                    }
                }
                g.setFont(font);
                for (String s : this.textArr) {
                    g.drawString(s, x, y, 0);
                    y += font.getHeight() + 2;
                }
                return;
            }
            if (this.labelArr != null) {
                g.setFont(this.labelFont);
                g.setColor(this.focused ? this.focusedColor : this.labelColor);
                if (row < this.labelArr.length) {
                    g.drawString(this.labelArr[row], x + 1, y, 0);
                    return;
                }
                row -= this.labelArr.length;
            }
            g.setFont(font);
            g.setColor(this.focused ? this.focusedColor : (this.isFocusable() ? this.focusableTextColor : this.textColor));
            if (this.textArr == null || row >= this.textArr.length) {
                return;
            }
            g.drawString(this.textArr[row], x + 1, y, 0);
        }
    }

    @Override
    void layout(Row row) {
        int min;
        super.layout(row);
        Font font = this.font != null ? this.font : Screen.font;
        int maxWidth = this.screen.bounds[2] - 8;
        int preferredWidth = this.preferredWidth != -1 ? super.getPreferredWidth() : maxWidth;
        int availableWidth = Math.min(preferredWidth, row.getAvailableWidth(maxWidth));
        if (this.isSizeLocked() || this.hasLabel()) {
            maxWidth = availableWidth;
        }
        if (availableWidth < (min = this.getMinimumWidth())) {
            availableWidth = min;
        }
        if (maxWidth < min) {
            maxWidth = min;
        }
        int[] maxw = new int[1];
        int w = 0;
        if (this.hasLabel()) {
            if (this.mode == 2) {
                String[] a2 = TextUtils.textArr(this.label.trim(), this.labelFont, maxWidth, maxWidth, maxw);
                if (a2.length != 0) {
                    w = this.labelFont.stringWidth(a2[0].trim());
                }
            } else {
                this.labelArr = TextUtils.textArr(this.label, this.labelFont, maxWidth, maxWidth, maxw);
                if (this.labelArr.length != 0) {
                    w = maxw[0] + 4;
                }
            }
        } else {
            this.labelArr = null;
        }
        String s = this.text;
        if (s == null) {
            s = "";
        }
        if (s.startsWith("\n")) {
            s = s.substring(1);
        }
        if (s.endsWith("\n") && !this._hasLayout(512)) {
            s = s.substring(0, s.length() - 1);
        }
        this.textArr = TextUtils.textArr(s, font, availableWidth, maxWidth, maxw);
        int fh = font.getHeight() + 2;
        if (this.mode == 2) {
            String[] stringArray;
            this.width = Math.max(w, Math.min(maxWidth, this.textArr.length != 0 ? font.stringWidth(this.textArr[0]) + 10 : 4));
            if (this.textArr.length != 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.textArr[0];
            } else {
                stringArray = this.textArr;
            }
            this.textArr = stringArray;
            this.bounds[3] = fh + 2 + (this.hasLabel() ? this.labelFont.getHeight() + 4 : 0);
        } else {
            this.width = Math.max(w, this.textArr.length != 0 ? maxw[0] : 4);
            this.bounds[3] = fh * this.textArr.length + (this.labelArr != null ? (this.labelFont.getHeight() + 4) * this.labelArr.length : 0);
        }
    }

    @Override
    public int getMinimumWidth() {
        Font font = this.font != null ? this.font : Screen.font;
        return font.stringWidth("...") + 2;
    }

    @Override
    public int getMinimumHeight() {
        Font font = this.font != null ? this.font : Screen.font;
        return font.getHeight() + 2 + (this.hasLabel() ? this.labelFont.getHeight() + 4 : 0);
    }

    @Override
    public int getPreferredWidth() {
        return super.isSizeLocked() && this.preferredWidth != -1 ? super.getPreferredWidth() : this.width;
    }

    @Override
    boolean isFocusable() {
        return this.commands.size() > 0;
    }

    int getRowWidth(int row) {
        if (this.labelArr != null) {
            if (row < this.labelArr.length) {
                return this.labelFont.stringWidth(this.labelArr[row]) + 2;
            }
            row -= this.labelArr.length;
        }
        if (this.textArr == null) {
            return 0;
        }
        return (this.font != null ? this.font : Screen.font).stringWidth(this.textArr[row]);
    }

    int getRowHeight(int row) {
        if (this.labelArr != null && row < this.labelArr.length) {
            return this.labelFont.getHeight() + 4;
        }
        return (this.font != null ? this.font : Screen.font).getHeight() + 2;
    }

    int getRowsCount() {
        return (this.textArr == null ? 0 : this.textArr.length) + (this.labelArr == null ? 0 : this.labelArr.length);
    }

    public void _setColor(int type, int color) {
        switch (type) {
            case 0: {
                this.textColor = this.focusableTextColor = color;
                break;
            }
            case 1: {
                this.focusedColor = color;
                break;
            }
            case 2: {
                this.focusedBackgroundColor = color;
            }
        }
    }
}

