/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import emulator.Emulator;
import emulator.lcdui.LCDUIUtils;
import emulator.lcdui.TextUtils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Row;
import javax.microedition.lcdui.Screen;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int PASSWORD = 65536;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    public static final int CONSTRAINT_MASK = 65535;
    private String string;
    private int maxSize;
    private int constraints;
    private String[] textArr;
    private int caretX;
    private int caretY;
    protected boolean isTextBox;
    private boolean updateFocus;
    private boolean swtFocused;

    public TextField(String label, String text, int maxSize, int constraints) {
        super(label);
        this.string = text;
        this.maxSize = maxSize;
        this.constraints = constraints;
    }

    public String getString() {
        if (this.string == null) {
            return "";
        }
        return this.string;
    }

    public void setString(String s) {
        String string = this.string = s == null ? "" : s;
        if (this.swtFocused) {
            Emulator.getEmulator().getScreen().getCaret().updateText(this, this.string);
        }
        this.layoutForm();
    }

    public int getChars(char[] array) {
        if (this.string == null) {
            return 0;
        }
        char[] charArray = this.string.toCharArray();
        System.arraycopy(charArray, 0, array, 0, charArray.length);
        return charArray.length;
    }

    public void setChars(char[] array, int n, int n2) {
        char[] array2 = new char[n2];
        System.arraycopy(array, n, array2, 0, n2);
        this.setString(new String(array2));
    }

    public void insert(String s, int n) {
        String aString25 = this.string;
        this.setString(aString25.substring(0, n) + s + aString25.substring(n));
    }

    public void insert(char[] array, int n, int n2, int n3) {
        char[] array2 = new char[n2];
        System.arraycopy(array, n, array2, 0, n2);
        this.insert(new String(array2), n3);
    }

    public void delete(int n, int n2) {
        String aString25 = this.string;
        this.setString(aString25.substring(0, n) + aString25.substring(n + n2));
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int setMaxSize(int size) {
        this.maxSize = size;
        if (this.string != null && this.string.length() > size) {
            this.setString(this.string.substring(0, size - 1));
        }
        return this.maxSize;
    }

    public int size() {
        if (this.string == null) {
            return 0;
        }
        return this.string.length();
    }

    public int getCaretPosition() {
        if (!this.swtFocused) {
            return 0;
        }
        return Emulator.getEmulator().getScreen().getCaret().getCaretPosition();
    }

    public void setConstraints(int anInt28) {
        this.constraints = anInt28;
    }

    public int getConstraints() {
        return this.constraints;
    }

    public void setInitialInputMode(String s) {
    }

    @Override
    void focus() {
        super.focus();
        Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        this.swtFocused = true;
        this.updateFocus = true;
    }

    @Override
    void defocus() {
        if (this.focused || !this.updateFocus) {
            Emulator.getEmulator().getScreen().getCaret().defocusItem(this);
            this.swtFocused = false;
        }
        super.defocus();
        this.updateFocus = true;
    }

    @Override
    void hidden() {
        if (this.focused || !this.updateFocus) {
            Emulator.getEmulator().getScreen().getCaret().defocusItem(this);
            this.swtFocused = false;
        }
        this.updateFocus = true;
    }

    @Override
    void paint(Graphics g, int x, int y, int w, int h2) {
        if (!this.isTextBox) {
            super.paint(g, x, y, w, h2);
        } else {
            g.setColor(LCDUIUtils.foregroundColor);
        }
        int yo = y;
        if (this.labelArr != null && this.labelArr.length > 0) {
            g.setFont(this.labelFont);
            for (int i2 = 0; i2 < this.labelArr.length; ++i2) {
                g.drawString(this.labelArr[i2], x + 4, yo + 2, 0);
                yo += this.labelFont.getHeight() + 4;
            }
        }
        if (this.focused) {
            g.setColor(-8355712);
        }
        g.drawRect(x + 2, yo, w - 4, this.bounds[3] - yo + y - 2);
        g.setFont(Screen.font);
        if (this.focused) {
            g.setColor(-8159760);
        }
        if ((this.caretX != x + 3 || this.caretY != yo + 1 || this.updateFocus) && this.focused && this.swtFocused) {
            this.updateFocus = false;
            this.caretX = x + 3;
            this.caretY = yo + 1;
            Emulator.getEmulator().getScreen().getCaret().focusItem(this, this.caretX, this.caretY);
        }
        if (this.textArr.length == 0) {
            return;
        }
        g.drawString(this.textArr[0], x + 4, yo + 2, 0);
    }

    @Override
    void layout(Row row) {
        super.layout(row);
        int n = 4;
        int availableWidth = row.getAvailableWidth(this.screen.bounds[2]) - 8;
        if (this.hasLabel()) {
            this.labelArr = TextUtils.textArr(this.label, this.labelFont, availableWidth, availableWidth);
            n = 4 + (this.labelFont.getHeight() + 4) * this.labelArr.length;
        } else {
            this.labelArr = null;
        }
        Font aFont173 = Screen.font;
        this.textArr = TextUtils.textArr(this.string == null ? "" : this.string, aFont173, availableWidth, availableWidth);
        this.bounds[3] = Math.max(this.getMinimumHeight(), Math.min(n + (aFont173.getHeight() + 4), this.screen.bounds[3]));
    }

    @Override
    public int getMinimumWidth() {
        return Item.font.stringWidth("Something") + 6;
    }

    @Override
    public int getMinimumHeight() {
        return (Item.font.getHeight() + 4) * (this.hasLabel() ? 2 : 1);
    }

    @Override
    boolean isFocusable() {
        return true;
    }

    @Override
    boolean keyScroll(int key, boolean repeat) {
        return key == 2 || key == 5;
    }

    public int _getTextAreaWidth() {
        return this.screen.bounds[2] - 5;
    }

    public int _getTextAreaHeight() {
        return Screen.font.getHeight() + 5;
    }

    public boolean _isUneditable() {
        return (this.constraints & 0x20000) == 131072;
    }

    public void _setString(String text) {
        this.string = text;
        this.layoutForm();
        this.notifyStateChanged();
    }

    public void _swtFocusLost() {
        this.swtFocused = false;
    }

    @Override
    protected void _itemApplyCommand() {
        this.focus();
    }

    @Override
    public void setPreferredSize(int width, int height) {
    }
}

