/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import emulator.Emulator;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public abstract class GameCanvas
extends Canvas {
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    private Graphics graphics;

    protected GameCanvas(boolean b2) {
    }

    protected Graphics getGraphics() {
        this.graphics = new Graphics(Emulator.getEmulator().getScreen().getBackBufferImage(), Emulator.getEmulator().getScreen().getXRayScreenImage());
        return this.graphics;
    }

    public int getKeyStates() {
        return this.m_keyStates;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.getImpl().drawImage(Emulator.getEmulator().getScreen().getBackBufferImage(), 0, 0);
    }

    public void flushGraphics(int x, int y, int w, int h2) {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Displayable._checkForSteps(null);
        Displayable._fpsLimiter(true);
        this._paintOverlay(this.graphics == null ? this.getGraphics() : this.graphics);
        Emulator.getEventQueue().gameGraphicsFlush(x, y, w, h2);
        Displayable._resetXRayGraphics();
    }

    public void flushGraphics() {
        if (this != Emulator.getCurrentDisplay().getCurrent()) {
            return;
        }
        Displayable._checkForSteps(null);
        Displayable._fpsLimiter(true);
        this._paintOverlay(this.graphics == null ? this.getGraphics() : this.graphics);
        Emulator.getEventQueue().gameGraphicsFlush();
        Displayable._resetXRayGraphics();
    }

    @Override
    public void _invokeSizeChanged(int w, int h2) {
        if (this.graphics != null) {
            this.graphics._reset(Emulator.getEmulator().getScreen().getBackBufferImage(), Emulator.getEmulator().getScreen().getXRayScreenImage());
        }
        super._invokeSizeChanged(w, h2);
    }
}

