/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;

public class LayerManager {
    private int size;
    private Layer[] layers = new Layer[4];
    private int x;
    private int y;
    private int width;
    private int height;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void append(Layer layer) {
        this.insert(layer, this.size);
    }

    public void insert(Layer layer, int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.remove(layer);
        if (this.size == this.layers.length) {
            Layer[] aLayerArray431 = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, aLayerArray431, 0, this.size);
            System.arraycopy(this.layers, n, aLayerArray431, n + 1, this.size - n);
            this.layers = aLayerArray431;
        } else {
            System.arraycopy(this.layers, n, this.layers, n + 1, this.size - n);
        }
        this.layers[n] = layer;
        ++this.size;
    }

    public Layer getLayerAt(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.layers[n];
    }

    public int getSize() {
        return this.size;
    }

    public void remove(Layer layer) {
        if (layer == null) {
            throw new NullPointerException();
        }
        int anInt430 = this.size;
        while (--anInt430 >= 0) {
            if (this.layers[anInt430] != layer) continue;
            System.arraycopy(this.layers, anInt430 + 1, this.layers, anInt430, this.size - anInt430 - 1);
            this.layers[--this.size] = null;
            break;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int clipX = graphics.getClipX();
        int clipY = graphics.getClipY();
        int clipWidth = graphics.getClipWidth();
        int clipHeight = graphics.getClipHeight();
        graphics.translate(n - this.x, n2 - this.y);
        graphics.clipRect(this.x, this.y, this.width, this.height);
        int anInt430 = this.size;
        while (--anInt430 >= 0) {
            Layer layer = this.layers[anInt430];
            if (!layer.visible) continue;
            layer.paint(graphics);
        }
        graphics.translate(-n + this.x, -n2 + this.y);
        graphics.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void setViewWindow(int anInt432, int anInt433, int anInt434, int anInt435) {
        if (anInt434 < 0 || anInt435 < 0) {
            throw new IllegalArgumentException();
        }
        this.x = anInt432;
        this.y = anInt433;
        this.width = anInt434;
        this.height = anInt435;
    }

    private void method213(Layer layer, int n) {
        if (this.size == this.layers.length) {
            Layer[] aLayerArray431 = new Layer[this.size + 4];
            System.arraycopy(this.layers, 0, aLayerArray431, 0, this.size);
            System.arraycopy(this.layers, n, aLayerArray431, n + 1, this.size - n);
            this.layers = aLayerArray431;
        } else {
            System.arraycopy(this.layers, n, this.layers, n + 1, this.size - n);
        }
        this.layers[n] = layer;
        ++this.size;
    }
}

