/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

public class Coordinates {
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    double latitude = Double.NaN;
    double longitude = Double.NaN;
    float altitude = Float.NaN;

    public Coordinates(double latitude, double longitude, float altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public void setLatitude(double latitude) {
        if (Double.isNaN(latitude)) {
            throw new IllegalArgumentException();
        }
        if (!(latitude >= -90.0) || !(latitude <= 90.0)) {
            throw new IllegalArgumentException();
        }
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        if (Double.isNaN(longitude)) {
            throw new IllegalArgumentException();
        }
        if (!(longitude >= -180.0) || !(longitude < 180.0)) {
            throw new IllegalArgumentException();
        }
        this.longitude = longitude;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double ConvertCoordinate(String coordinate) {
        int sign;
        char firstChar = coordinate.charAt(0);
        int ddix = coordinate.indexOf(58);
        int dd = Coordinates.parseDegrees(coordinate, ddix, firstChar);
        if (firstChar == '-') {
            dd = -dd;
            sign = -1;
        } else {
            sign = 1;
        }
        if (coordinate.length() < ddix + 2) {
            throw new IllegalArgumentException();
        }
        String mmstr = coordinate.substring(ddix + 1);
        int mm = Coordinates.parseMinutes(mmstr);
        int mmlen = mmstr.length();
        if (mmlen <= 2) return Coordinates.getValueMM(sign, dd, mm, 0.0);
        if (mmlen < 4) {
            throw new IllegalArgumentException();
        }
        char delimeterChar = mmstr.charAt(2);
        if (delimeterChar == ':') {
            if (mmlen < 5) {
                throw new IllegalArgumentException();
            }
            double ss = Coordinates.parseSeconds(mmstr.substring(3));
            return Coordinates.getValueSS(sign, dd, mm, ss);
        }
        if (delimeterChar != '.') throw new IllegalArgumentException();
        double ff = Coordinates.parseFraction(mmstr.substring(3), 5);
        return Coordinates.getValueMM(sign, dd, mm, ff);
    }

    private static double getValueMM(int sign, int dd, int mm, double ff) {
        return (double)sign * ((double)dd + ((double)mm + ff) / 60.0);
    }

    private static double getValueSS(int sign, int dd, int mm, double ss) {
        return (double)sign * ((double)dd + (double)mm / 60.0 + ss);
    }

    private static int parseDegrees(String coordinate, int ddix, char firstChar) {
        if (ddix < 1) {
            throw new IllegalArgumentException();
        }
        if (ddix > 1 && firstChar == '0' || ddix > 2 && firstChar == '-' && coordinate.charAt(1) == '0') {
            throw new IllegalArgumentException();
        }
        int dd = Integer.parseInt(coordinate.substring(0, ddix));
        if (dd >= 180 || dd < 65356) {
            throw new IllegalArgumentException();
        }
        return dd;
    }

    private static int parse2Digits(String digits) {
        char dChar1 = digits.charAt(0);
        if (dChar1 < '0' || dChar1 > '5') {
            throw new IllegalArgumentException();
        }
        char dChar2 = digits.charAt(1);
        if (dChar2 < '0' || dChar2 > '9') {
            throw new IllegalArgumentException();
        }
        return Character.digit(dChar1, 10) * 10 + Character.digit(dChar2, 10);
    }

    private static int parseMinutes(String mmstr) {
        int mm;
        try {
            mm = Coordinates.parse2Digits(mmstr);
        }
        catch (IllegalArgumentException ie) {
            throw new IllegalArgumentException();
        }
        return mm;
    }

    private static double parseSeconds(String ssstr) {
        int ss;
        double ff = 0.0;
        try {
            ss = Coordinates.parse2Digits(ssstr);
        }
        catch (IllegalArgumentException ie) {
            throw new IllegalArgumentException();
        }
        if (ssstr.length() > 2) {
            if (ssstr.charAt(2) == '.') {
                ff = Coordinates.parseFraction(ssstr.substring(3), 3);
            } else {
                throw new IllegalArgumentException();
            }
        }
        return ((double)ss + ff) / 3600.0;
    }

    private static double parseFraction(String ffstr, int maxlen) {
        if (ffstr.length() > maxlen || ffstr.length() < 1) {
            throw new IllegalArgumentException();
        }
        String s = "0." + ffstr;
        return Double.parseDouble(s);
    }

    public static double convert(String coordinate) {
        try {
            if (coordinate == null) {
                throw new NullPointerException();
            }
            if ((coordinate = coordinate.trim()).length() < 4) {
                throw new IllegalArgumentException();
            }
            double res = Coordinates.ConvertCoordinate(coordinate);
            if (res >= 180.0 || res < -180.0) {
                throw new IllegalArgumentException();
            }
            return res;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof Coordinates)) {
            return false;
        }
        Coordinates o = (Coordinates)other;
        if (Double.doubleToLongBits(this.getLatitude()) != Double.doubleToLongBits(o.getLatitude())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getLongitude()) != Double.doubleToLongBits(o.getLongitude())) {
            return false;
        }
        return Float.floatToIntBits(this.getAltitude()) == Float.floatToIntBits(o.getAltitude());
    }

    public int hashCode() {
        int result = 17;
        long tmp = Double.doubleToLongBits(this.getLatitude());
        result = 37 * result + (int)(tmp ^ tmp >> 32);
        tmp = Double.doubleToLongBits(this.getLongitude());
        result = 37 * result + (int)(tmp ^ tmp >> 32);
        result = 37 * result + Float.floatToIntBits(this.getAltitude());
        return result;
    }

    private static int decimalToValue(int noOfDecimals) {
        switch (noOfDecimals) {
            case 3: {
                return 1000;
            }
            case 5: {
                return 100000;
            }
        }
        return 1000;
    }

    private static String double2IntDotIntString(double number, int noOfDecimals) {
        StringBuffer res = new StringBuffer(noOfDecimals + 4);
        int scale = Coordinates.decimalToValue(noOfDecimals);
        int intscale = (int)Math.floor((double)scale * number + 0.5);
        int integerNumber = intscale / scale;
        int decimalNumber = intscale % scale;
        if (integerNumber < 10) {
            res.append('0');
        }
        res.append(integerNumber);
        if (decimalNumber > 0) {
            char[] zeroes = new char[]{'0', '0', '0', '0', '0', '0'};
            String frac = Integer.toString(decimalNumber);
            res.append('.');
            res.append(zeroes, 0, noOfDecimals - frac.length());
            res.append(frac);
        }
        return res.toString();
    }

    public static String convert(double coordinate, int outputType) {
        if (coordinate >= 180.0 || coordinate < -180.0) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(coordinate)) {
            throw new IllegalArgumentException();
        }
        if (outputType == 2) {
            int sign = coordinate < 0.0 ? -1 : 1;
            coordinate = Math.abs(coordinate);
            int dd = (int)coordinate;
            double mm = (coordinate - (double)dd) * 60.0;
            return (sign < 0 ? "-" : "") + dd + ":" + Coordinates.double2IntDotIntString(mm, 5);
        }
        if (outputType == 1) {
            int mm;
            int dd;
            int sign = coordinate < 0.0 ? -1 : 1;
            double ss = (((coordinate = Math.abs(coordinate)) - (double)(dd = (int)coordinate)) * 60.0 - (double)(mm = (int)((coordinate - (double)dd) * 60.0))) * 60.0;
            double rss = (double)((int)Math.floor(100.0 * ss + 0.5)) / 100.0;
            if (rss >= 60.0) {
                ++mm;
                rss -= 60.0;
            }
            if (mm >= 60) {
                ++dd;
                mm -= 60;
            }
            return (sign < 0 ? "-" : "") + dd + ":" + (mm < 10 ? "0" : "") + mm + ":" + Coordinates.double2IntDotIntString(rss, 3);
        }
        throw new IllegalArgumentException();
    }

    public float azimuthTo(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        double otherLatitude = to.getLatitude();
        double otherLongitude = to.getLongitude();
        if (Double.isNaN(this.latitude) || Double.isNaN(this.longitude) || Double.isNaN(otherLatitude) || Double.isNaN(otherLongitude)) {
            return Float.NaN;
        }
        float azimuth = otherLatitude == this.latitude && otherLongitude == this.longitude ? 0.0f : this.nativeBearing(this.latitude, this.longitude, otherLatitude, otherLongitude);
        return azimuth;
    }

    public float distance(Coordinates to) {
        if (to == null) {
            throw new NullPointerException();
        }
        double otherLatitude = to.getLatitude();
        double otherLongitude = to.getLongitude();
        if (Double.isNaN(this.latitude) || Double.isNaN(this.longitude) || Double.isNaN(otherLatitude) || Double.isNaN(otherLongitude)) {
            return Float.NaN;
        }
        float distance = otherLatitude == this.latitude && otherLongitude == this.longitude ? 0.0f : this.nativeDistance(this.latitude, this.longitude, otherLatitude, otherLongitude);
        return distance;
    }

    private float nativeDistance(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        return 0.0f;
    }

    private float nativeBearing(double paramDouble1, double paramDouble2, double paramDouble3, double paramDouble4) {
        return 0.0f;
    }
}

