/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import javax.microedition.location.Coordinates;

public class QualifiedCoordinates
extends Coordinates {
    float horizontalAccuracy = Float.NaN;
    float verticalAccuracy = Float.NaN;

    public QualifiedCoordinates(double latitude, double longitude, float altitude, float horizontalAccuracy, float verticalAccuracy) {
        super(latitude, longitude, altitude);
        this.setHorizontalAccuracy(horizontalAccuracy);
        this.setVerticalAccuracy(verticalAccuracy);
    }

    QualifiedCoordinates() {
        this(0.0, 0.0, Float.NaN, Float.NaN, Float.NaN);
    }

    QualifiedCoordinates(QualifiedCoordinates other) {
        this(other.latitude, other.longitude, other.altitude, other.horizontalAccuracy, other.verticalAccuracy);
    }

    public float getHorizontalAccuracy() {
        return this.horizontalAccuracy;
    }

    public float getVerticalAccuracy() {
        return this.verticalAccuracy;
    }

    public void setHorizontalAccuracy(float horizontalAccuracy) {
        if (!Float.isNaN(horizontalAccuracy) && !(horizontalAccuracy >= 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.horizontalAccuracy = horizontalAccuracy;
    }

    public void setVerticalAccuracy(float verticalAccuracy) {
        if (!Float.isNaN(verticalAccuracy) && !(verticalAccuracy >= 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.verticalAccuracy = verticalAccuracy;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof QualifiedCoordinates)) {
            return false;
        }
        QualifiedCoordinates o = (QualifiedCoordinates)other;
        if (Float.floatToIntBits(this.getHorizontalAccuracy()) != Float.floatToIntBits(o.getHorizontalAccuracy())) {
            return false;
        }
        return Float.floatToIntBits(this.getVerticalAccuracy()) == Float.floatToIntBits(o.getVerticalAccuracy());
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + Float.floatToIntBits(this.getHorizontalAccuracy());
        result = 37 * result + Float.floatToIntBits(this.getVerticalAccuracy());
        result = 37 * result + super.hashCode();
        return result;
    }

    protected QualifiedCoordinates clone() {
        QualifiedCoordinates clone = new QualifiedCoordinates(this);
        return clone;
    }
}

