/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.MorphingMesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transformable;
import javax.microedition.m3g.VertexBuffer;

public class AnimationTrack
extends Object3D {
    public static final int ALPHA = 256;
    public static final int AMBIENT_COLOR = 257;
    public static final int COLOR = 258;
    public static final int CROP = 259;
    public static final int DENSITY = 260;
    public static final int DIFFUSE_COLOR = 261;
    public static final int EMISSIVE_COLOR = 262;
    public static final int FAR_DISTANCE = 263;
    public static final int FIELD_OF_VIEW = 264;
    public static final int INTENSITY = 265;
    public static final int MORPH_WEIGHTS = 266;
    public static final int NEAR_DISTANCE = 267;
    public static final int ORIENTATION = 268;
    public static final int PICKABILITY = 269;
    public static final int SCALE = 270;
    public static final int SHININESS = 271;
    public static final int SPECULAR_COLOR = 272;
    public static final int SPOT_ANGLE = 273;
    public static final int SPOT_EXPONENT = 274;
    public static final int TRANSLATION = 275;
    public static final int VISIBILITY = 276;
    private KeyframeSequence keyframeSequence;
    private AnimationController controller;
    private int targetProperty;

    public AnimationTrack(KeyframeSequence sequence, int property) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (!AnimationTrack.isValidPropertyId(property)) {
            throw new IllegalArgumentException();
        }
        if (!AnimationTrack.isValidComponentCount(property, sequence.getComponentCount())) {
            throw new IllegalArgumentException();
        }
        this.keyframeSequence = sequence;
        this.targetProperty = property;
        this.controller = null;
        this.addReference(this.keyframeSequence);
    }

    protected boolean checkCompatible(Object3D o) {
        switch (this.targetProperty) {
            case 256: {
                return o instanceof Node || o instanceof Background || o instanceof Material || o instanceof VertexBuffer;
            }
            case 257: {
                return o instanceof Material;
            }
            case 258: {
                return o instanceof Light || o instanceof Background || o instanceof Fog || o instanceof Texture2D || o instanceof VertexBuffer;
            }
            case 259: {
                return o instanceof Sprite3D || o instanceof Background;
            }
            case 260: {
                return o instanceof Fog;
            }
            case 261: {
                return o instanceof Material;
            }
            case 262: {
                return o instanceof Material;
            }
            case 263: {
                return o instanceof Camera || o instanceof Fog;
            }
            case 264: {
                return o instanceof Camera;
            }
            case 265: {
                return o instanceof Light;
            }
            case 266: {
                return o instanceof MorphingMesh;
            }
            case 267: {
                return o instanceof Camera || o instanceof Fog;
            }
            case 268: {
                return o instanceof Transformable;
            }
            case 269: {
                return o instanceof Node;
            }
            case 270: {
                return o instanceof Transformable;
            }
            case 271: {
                return o instanceof Material;
            }
            case 272: {
                return o instanceof Material;
            }
            case 273: {
                return o instanceof Light;
            }
            case 274: {
                return o instanceof Light;
            }
            case 275: {
                return o instanceof Transformable;
            }
            case 276: {
                return o instanceof Node;
            }
        }
        return false;
    }

    private static boolean isValidPropertyId(int property) {
        return property >= 256 && property <= 276;
    }

    private static boolean isValidComponentCount(int property, int componentCount) {
        switch (property) {
            case 256: {
                return componentCount == 1;
            }
            case 257: {
                return componentCount == 3;
            }
            case 258: {
                return componentCount == 3;
            }
            case 259: {
                return componentCount == 2 || componentCount == 4;
            }
            case 260: {
                return componentCount == 1;
            }
            case 261: {
                return componentCount == 3;
            }
            case 262: {
                return componentCount == 3;
            }
            case 263: {
                return componentCount == 1;
            }
            case 264: {
                return componentCount == 1;
            }
            case 265: {
                return componentCount == 1;
            }
            case 266: {
                return true;
            }
            case 267: {
                return componentCount == 1;
            }
            case 268: {
                return componentCount == 4;
            }
            case 269: {
                return componentCount == 1;
            }
            case 270: {
                return componentCount == 1 || componentCount == 3;
            }
            case 271: {
                return componentCount == 1;
            }
            case 272: {
                return componentCount == 3;
            }
            case 273: {
                return componentCount == 1;
            }
            case 274: {
                return componentCount == 1;
            }
            case 275: {
                return componentCount == 3;
            }
            case 276: {
                return componentCount == 1;
            }
        }
        return false;
    }

    public void setController(AnimationController controller) {
        this.removeReference(this.controller);
        this.controller = controller;
        this.addReference(controller);
    }

    public AnimationController getController() {
        return this.controller;
    }

    public KeyframeSequence getKeyframeSequence() {
        return this.keyframeSequence;
    }

    public int getTargetProperty() {
        return this.targetProperty;
    }

    protected void getContribution(int worldTime, float[] contribution, float[] weightTime) {
        if (this.controller != null && this.controller.isActive(worldTime)) {
            float[] components = new float[this.keyframeSequence.getComponentCount()];
            float keyframePos = this.controller.getPosition(worldTime);
            int timeToKeyframeEnd = this.keyframeSequence.getSampleFrame(keyframePos, components);
            float weight = this.controller.getWeight();
            for (int i2 = 0; i2 < components.length; ++i2) {
                int n = i2;
                contribution[n] = contribution[n] + components[i2] * weight;
            }
            weightTime[0] = weight;
            weightTime[1] = Math.min(timeToKeyframeEnd, this.controller.timeToDeactivation(worldTime));
        } else {
            weightTime[0] = 0.0f;
            weightTime[1] = Math.max(1, this.controller == null ? Integer.MAX_VALUE : this.controller.timeToActivation(worldTime));
        }
    }
}

