/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Camera
extends Node {
    public static final int GENERIC = 48;
    public static final int PARALLEL = 49;
    public static final int PERSPECTIVE = 50;
    private int projectionType = 48;
    private Transform generic = new Transform();
    private float[] projection = new float[4];

    @Override
    protected Object3D duplicateObject() {
        Camera var1 = (Camera)super.duplicateObject();
        ((Camera)super.duplicateObject()).generic = new Transform(this.generic);
        var1.projection = (float[])this.projection.clone();
        return var1;
    }

    public Camera() {
        this.projection[0] = 2.0f;
        this.projection[1] = 1.0f;
        this.projection[2] = -1.0f;
        this.projection[3] = 1.0f;
    }

    public void setParallel(float var1, float var2, float var3, float var4) {
        if (!(var1 > 0.0f) || !(var2 > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.projection[0] = var1;
        this.projection[1] = var2;
        this.projection[2] = var3;
        this.projection[3] = var4;
        this.projectionType = 49;
    }

    public void setPerspective(float var1, float var2, float var3, float var4) {
        if (!(var1 > 0.0f && var1 < 180.0f && var2 > 0.0f && var3 > 0.0f && var4 > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.projection[0] = var1;
        this.projection[1] = var2;
        this.projection[2] = var3;
        this.projection[3] = var4;
        this.projectionType = 50;
    }

    public void setGeneric(Transform var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        this.generic.set(var1);
        this.projectionType = 48;
    }

    public int getProjection(Transform var1) {
        if (var1 != null) {
            if (this.projectionType == 49) {
                float var2 = this.projection[0];
                float var3 = this.projection[1] * var2;
                float var4 = this.projection[3] - this.projection[2];
                if (var4 == 0.0f) {
                    throw new ArithmeticException("near == far");
                }
                float[] fArray = new float[16];
                float[] var5 = fArray;
                fArray[0] = 2.0f / var3;
                var5[5] = 2.0f / var2;
                var5[10] = -2.0f / var4;
                var5[11] = -(this.projection[2] + this.projection[3]) / var4;
                var5[15] = 1.0f;
                var1.set(var5);
            } else if (this.projectionType == 50) {
                float var2 = (float)Math.tan(Math.toRadians(this.projection[0] / 2.0f));
                float var3 = this.projection[1] * var2;
                float var4 = this.projection[3] - this.projection[2];
                if (var4 == 0.0f) {
                    throw new ArithmeticException("near == far");
                }
                float[] fArray = new float[16];
                float[] var5 = fArray;
                fArray[0] = 1.0f / var3;
                var5[5] = 1.0f / var2;
                var5[10] = -(this.projection[2] + this.projection[3]) / var4;
                var5[11] = -2.0f * this.projection[2] * this.projection[3] / var4;
                var5[14] = -1.0f;
                var1.set(var5);
            } else {
                var1.set(this.generic);
            }
        }
        return this.projectionType;
    }

    public int getProjection(float[] var1) {
        if (var1 != null && var1.length < 4) {
            throw new IllegalArgumentException();
        }
        if (var1 != null && this.projectionType != 48) {
            System.arraycopy(this.projection, 0, var1, 0, 4);
        }
        return this.projectionType;
    }

    @Override
    protected void updateProperty(int property, float[] values) {
        if (this.projectionType != 48) {
            switch (property) {
                case 263: {
                    this.projection[3] = this.projectionType != 50 ? values[0] : G3DUtils.limitPositive(values[0]);
                    return;
                }
                case 264: {
                    this.projection[0] = this.projectionType != 50 ? G3DUtils.limitPositive(values[0]) : G3DUtils.limit(values[0], 0.0f, 180.0f);
                    return;
                }
                default: {
                    break;
                }
                case 267: {
                    this.projection[2] = this.projectionType != 50 ? values[0] : G3DUtils.limitPositive(values[0]);
                    return;
                }
            }
        }
        super.updateProperty(property, values);
    }

    @Override
    protected boolean rayIntersect(int var1, float[] var2, RayIntersection var3, Transform var4) {
        return false;
    }
}

