/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Light
extends Node {
    public static final int AMBIENT = 128;
    public static final int DIRECTIONAL = 129;
    public static final int OMNI = 130;
    public static final int SPOT = 131;
    private int mode = 129;
    private int color = 0xFFFFFF;
    private float intensity = 1.0f;
    private float constantAttenuation = 1.0f;
    private float linearAttenuation = 0.0f;
    private float quadraticAttenuation = 0.0f;
    private float spotAngle = 45.0f;
    private float spotExponent = 0.0f;

    public void setMode(int var1) {
        if (var1 < 128 || var1 > 131) {
            throw new IllegalArgumentException();
        }
        this.mode = var1;
    }

    public int getMode() {
        return this.mode;
    }

    public void setIntensity(float var1) {
        this.intensity = var1;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setColor(int var1) {
        this.color = var1;
    }

    public int getColor() {
        return this.color;
    }

    public void setSpotAngle(float var1) {
        if (!(var1 >= 0.0f) || !(var1 <= 90.0f)) {
            throw new IllegalArgumentException("angle is not in [0, 90]");
        }
        this.spotAngle = var1;
    }

    public float getSpotAngle() {
        return this.spotAngle;
    }

    public void setSpotExponent(float var1) {
        if (!(var1 >= 0.0f) || !(var1 <= 128.0f)) {
            throw new IllegalArgumentException("exponent is not in [0, 128]");
        }
        this.spotExponent = var1;
    }

    public float getSpotExponent() {
        return this.spotExponent;
    }

    public void setAttenuation(float var1, float var2, float var3) {
        if (var1 >= 0.0f && var2 >= 0.0f && var3 >= 0.0f) {
            if (var1 == 0.0f && var2 == 0.0f && var3 == 0.0f) {
                throw new IllegalArgumentException("all of the parameter values are zero");
            }
        } else {
            throw new IllegalArgumentException("any of the parameter values are negative");
        }
        this.constantAttenuation = var1;
        this.linearAttenuation = var2;
        this.quadraticAttenuation = var3;
    }

    public float getConstantAttenuation() {
        return this.constantAttenuation;
    }

    public float getLinearAttenuation() {
        return this.linearAttenuation;
    }

    public float getQuadraticAttenuation() {
        return this.quadraticAttenuation;
    }

    @Override
    protected void updateProperty(int property, float[] values) {
        switch (property) {
            case 258: {
                this.color = G3DUtils.getIntColor(values);
                return;
            }
            case 265: {
                this.intensity = values[0];
                return;
            }
            case 273: {
                this.spotAngle = G3DUtils.limit(values[0], 0.0f, 90.0f);
                return;
            }
            case 274: {
                this.spotExponent = G3DUtils.limit(values[0], 0.0f, 128.0f);
                return;
            }
        }
        super.updateProperty(property, values);
    }

    @Override
    protected boolean rayIntersect(int var1, float[] var2, RayIntersection var3, Transform var4) {
        return false;
    }
}

