/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexBuffer;

public class Mesh
extends Node {
    protected VertexBuffer vertices;
    private IndexBuffer[] submeshes;
    private Appearance[] appearances;

    public Mesh(VertexBuffer vertices, IndexBuffer submesh, Appearance appearance) {
        if (vertices == null || submesh == null) {
            throw new NullPointerException();
        }
        this.vertices = vertices;
        this.submeshes = new IndexBuffer[1];
        this.submeshes[0] = submesh;
        this.appearances = new Appearance[1];
        if (appearance != null) {
            this.appearances[0] = appearance;
            this.addReference(this.appearances[0]);
        }
        this.addReference(this.vertices);
        this.addReference(this.submeshes[0]);
    }

    public Mesh(VertexBuffer vertices, IndexBuffer[] submeshes, Appearance[] appearances) {
        if (vertices == null || submeshes == null) {
            throw new NullPointerException();
        }
        if (submeshes.length == 0 || appearances != null && appearances.length < submeshes.length) {
            throw new IllegalArgumentException();
        }
        this.vertices = vertices;
        this.submeshes = new IndexBuffer[submeshes.length];
        this.appearances = new Appearance[submeshes.length];
        for (int i2 = 0; i2 < submeshes.length; ++i2) {
            if (submeshes[i2] == null) {
                throw new NullPointerException();
            }
            this.submeshes[i2] = submeshes[i2];
            this.addReference(this.submeshes[i2]);
            if (appearances == null) continue;
            this.appearances[i2] = appearances[i2];
            this.addReference(this.appearances[i2]);
        }
        this.addReference(this.vertices);
    }

    @Override
    protected Object3D duplicateObject() {
        Mesh clone = (Mesh)super.duplicateObject();
        clone.submeshes = (IndexBuffer[])this.submeshes.clone();
        clone.appearances = (Appearance[])this.appearances.clone();
        return clone;
    }

    public void setAppearance(int index, Appearance ap) {
        if (index < 0 || index >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        this.removeReference(this.appearances[index]);
        this.appearances[index] = ap;
        this.addReference(this.appearances[index]);
    }

    public Appearance getAppearance(int index) {
        if (index < 0 || index >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.appearances[index];
    }

    public IndexBuffer getIndexBuffer(int index) {
        if (index < 0 || index >= this.submeshes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.submeshes[index];
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertices;
    }

    public int getSubmeshCount() {
        return this.submeshes.length;
    }

    @Override
    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform) {
        return this.rayIntersect(scope, ray, ri, transform, this.vertices);
    }

    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform, VertexBuffer vb) {
        block17: {
            if ((scope & this.getScope()) == 0) {
                return false;
            }
            if (vb == null || this.appearances == null || this.submeshes == null) break block17;
            if (vb.getPositions(null) == null) {
                throw new IllegalStateException("No vertex positions");
            }
            boolean var6 = false;
            Vector4f var7 = new Vector4f(ray[0], ray[1], ray[2], 1.0f);
            Vector4f var8 = new Vector4f(ray[3], ray[4], ray[5], 1.0f);
            Transform var9 = new Transform();
            var9.set(transform);
            var9.getImpl_().invert();
            var9.getImpl_().transform(var7);
            var9.getImpl_().transform(var8);
            var7.mul(1.0f / var7.w);
            var8.mul(1.0f / var8.w);
            var8.sub(var7);
            Vector4f vtxA = new Vector4f();
            Vector4f vtxB = new Vector4f();
            Vector4f vtxC = new Vector4f();
            Vector4f var13 = new Vector4f();
            Vector4f var14 = new Vector4f();
            Transform var15 = new Transform();
            int[] triIndices = new int[4];
            float[] texS = new float[10];
            float[] texT = new float[10];
            float[] normal = null;
            for (int submesh = 0; submesh < this.submeshes.length; ++submesh) {
                int var21;
                block19: {
                    block18: {
                        int var10000;
                        if (this.appearances[submesh] == null || this.submeshes[submesh] == null) continue;
                        if (this.appearances[submesh].getPolygonMode() == null) break block18;
                        var21 = this.appearances[submesh].getPolygonMode().getWinding() != 168 ? 1 : 0;
                        switch (this.appearances[submesh].getPolygonMode().getCulling()) {
                            case 161: {
                                var10000 = var21 ^ 1;
                                break;
                            }
                            case 162: {
                                var10000 = 2;
                                break;
                            }
                            default: {
                                break block19;
                            }
                        }
                        var21 = var10000;
                        break block19;
                    }
                    var21 = 0;
                }
                TriangleStripArray tsa = (TriangleStripArray)this.submeshes[submesh];
                int i2 = 0;
                while (tsa.getIndices(i2, triIndices)) {
                    int vtxCount = vb.getVertexCount();
                    if (triIndices[0] >= vtxCount || triIndices[1] >= vtxCount || triIndices[2] >= vtxCount) {
                        throw new IllegalStateException("Index overflow: (" + triIndices[0] + ", " + triIndices[1] + ", " + triIndices[2] + ") >=" + vtxCount);
                    }
                    if (triIndices[0] < 0 || triIndices[1] < 0 || triIndices[2] < 0) {
                        throw new IllegalStateException("Index underflow");
                    }
                    vb.getVertex(triIndices[0], vtxA);
                    vb.getVertex(triIndices[1], vtxB);
                    vb.getVertex(triIndices[2], vtxC);
                    if (G3DUtils.intersectTriangle(var7, var8, vtxA, vtxB, vtxC, var14, triIndices[3] ^ var21) && ri.testDistance(var14.x)) {
                        if (vb.getNormalVertex(triIndices[0], vtxA)) {
                            vb.getNormalVertex(triIndices[1], vtxB);
                            vb.getNormalVertex(triIndices[2], vtxC);
                            normal = new float[]{vtxA.x * (1.0f - (var14.y + var14.z)) + vtxB.x * var14.y + vtxC.x * var14.z, vtxA.y * (1.0f - (var14.y + var14.z)) + vtxB.y * var14.y + vtxC.y * var14.z, vtxA.z * (1.0f - (var14.y + var14.z)) + vtxB.z * var14.y + vtxC.z * var14.z};
                        }
                        for (int var25 = 0; var25 < texS.length; ++var25) {
                            float var10002;
                            int var10001;
                            float[] var26;
                            if (vb.getTexVertex(triIndices[0], var25, vtxA)) {
                                vb.getTexVertex(triIndices[1], var25, vtxB);
                                vb.getTexVertex(triIndices[2], var25, vtxC);
                                var13.x = vtxA.x * (1.0f - (var14.y + var14.z)) + vtxB.x * var14.y + vtxC.x * var14.z;
                                var13.y = vtxA.y * (1.0f - (var14.y + var14.z)) + vtxB.y * var14.y + vtxC.y * var14.z;
                                var13.z = 0.0f;
                                var13.w = 1.0f;
                                if (this.appearances[submesh] != null && this.appearances[submesh].getTexture(var25) != null) {
                                    this.appearances[submesh].getTexture(var25).getCompositeTransform(var15);
                                    var15.getImpl_().transform(var13);
                                    var13.mul(1.0f / var13.w);
                                }
                                texT[var25] = var13.x;
                                var26 = texS;
                                var10001 = var25;
                                var10002 = var13.y;
                            } else {
                                texT[var25] = 0.0f;
                                var26 = texS;
                                var10001 = var25;
                                var10002 = 0.0f;
                            }
                            var26[var10001] = var10002;
                        }
                        if (ri.endPick(var14.x, texT, texS, submesh, this, normal)) {
                            var6 = true;
                        }
                    }
                    ++i2;
                }
            }
            return var6;
        }
        return false;
    }
}

