/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.m3g.BoneTransform;
import emulator.graphics3D.m3g.MeshMorph;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class SkinnedMesh
extends Mesh {
    Group skeleton;
    public Vector<BoneTransform> boneTransList;
    public int[] vtxBones;
    public int[] vtxWeights;

    public SkinnedMesh(VertexBuffer vertices, IndexBuffer submesh, Appearance appearance, Group skeleton) {
        super(vertices, submesh, appearance);
        if (skeleton == null) {
            throw new NullPointerException();
        }
        if (skeleton instanceof World || skeleton.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = skeleton;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertices.getVertexCount() * 4];
        this.vtxWeights = new int[vertices.getVertexCount() * 4];
    }

    public SkinnedMesh(VertexBuffer vertices, IndexBuffer[] submeshes, Appearance[] appearances, Group skeleton) {
        super(vertices, submeshes, appearances);
        if (skeleton == null) {
            throw new NullPointerException();
        }
        if (skeleton instanceof World || skeleton.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = skeleton;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertices.getVertexCount() * 4];
        this.vtxWeights = new int[vertices.getVertexCount() * 4];
    }

    public Group getSkeleton() {
        return this.skeleton;
    }

    @Override
    protected Object3D duplicateObject() {
        SkinnedMesh clone = (SkinnedMesh)super.duplicateObject();
        Group newSkeleton = (Group)clone.getSkeleton().duplicateObject();
        clone.removeReference(clone.skeleton);
        clone.addReference(newSkeleton);
        clone.skeleton = newSkeleton;
        newSkeleton.parent = clone;
        Hashtable oldToNewBone = new Hashtable();
        this.getOldToNewBonesMapping(oldToNewBone, this.skeleton, newSkeleton);
        clone.boneTransList = new Vector();
        for (int i2 = 0; i2 < this.boneTransList.size(); ++i2) {
            BoneTransform oldBoneTrans = this.boneTransList.elementAt(i2);
            BoneTransform newBoneTrans = new BoneTransform((Node)oldToNewBone.get(oldBoneTrans.bone), oldBoneTrans.toBoneTrans);
            clone.boneTransList.add(newBoneTrans);
        }
        clone.vtxBones = (int[])this.vtxBones.clone();
        clone.vtxWeights = (int[])this.vtxWeights.clone();
        return clone;
    }

    private void getOldToNewBonesMapping(Hashtable map, Node oldNode, Node newNode) {
        map.put(oldNode, newNode);
        if (oldNode instanceof Group) {
            Group oldGroup = (Group)oldNode;
            Group newGroup = (Group)newNode;
            for (int i2 = 0; i2 < oldGroup.getChildCount(); ++i2) {
                Node oldChild = oldGroup.getChild(i2);
                Node newChild = newGroup.getChild(i2);
                this.getOldToNewBonesMapping(map, oldChild, newChild);
            }
        } else if (oldNode instanceof SkinnedMesh) {
            Group oldSkeleton = ((SkinnedMesh)oldNode).getSkeleton();
            Group newSkeleton = ((SkinnedMesh)newNode).getSkeleton();
            this.getOldToNewBonesMapping(map, oldSkeleton, newSkeleton);
        }
    }

    public void addTransform(Node bone, int weight, int firstVertex, int numVertices) {
        if (bone == null) {
            throw new NullPointerException();
        }
        if (bone != this.skeleton && !bone.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        if (weight > 0 && numVertices > 0) {
            int i2;
            if (firstVertex < 0 && firstVertex + numVertices > 65535) {
                throw new IndexOutOfBoundsException();
            }
            BoneTransform boneTrans = null;
            int boneTransId = -1;
            for (i2 = 0; i2 < this.boneTransList.size(); ++i2) {
                BoneTransform tmpBoneTrans = this.boneTransList.elementAt(i2);
                if (tmpBoneTrans.bone != bone) continue;
                boneTrans = tmpBoneTrans;
                boneTransId = i2;
                break;
            }
            if (boneTrans == null) {
                Transform toBoneTrans = new Transform();
                if (!this.getTransformTo(bone, toBoneTrans)) {
                    throw new ArithmeticException();
                }
                boneTrans = new BoneTransform(bone, toBoneTrans);
                this.boneTransList.add(boneTrans);
                boneTransId = this.boneTransList.size() - 1;
            }
            for (i2 = firstVertex; i2 < firstVertex + numVertices; ++i2) {
                int minWeight = Integer.MAX_VALUE;
                int selSlot = -1;
                for (int slot = 0; slot < 4; ++slot) {
                    int slotWeight = this.vtxWeights[i2 * 4 + slot];
                    if (slotWeight >= minWeight) continue;
                    minWeight = slotWeight;
                    selSlot = slot;
                    if (slotWeight == 0) break;
                }
                if (minWeight > weight) {
                    selSlot = -1;
                }
                if (selSlot == -1) continue;
                this.vtxBones[i2 * 4 + selSlot] = boneTransId + 1;
                this.vtxWeights[i2 * 4 + selSlot] = weight;
            }
        } else {
            throw new IllegalArgumentException();
        }
        bone.setSkinnedMeshBone();
    }

    @Override
    protected void alignment(Node reference) {
        super.alignment(reference);
        this.skeleton.alignment(reference);
    }

    @Override
    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform) {
        MeshMorph.getInstance().getMorphedVertexBuffer(this);
        MeshMorph.getInstance().clearCache();
        return super.rayIntersect(scope, ray, ri, transform, MeshMorph.getInstance().morphed) || this.skeleton.rayIntersect(scope, ray, ri, transform);
    }

    public Vector getTransforms() {
        return this.boneTransList;
    }

    public int[] getVerticesBones() {
        return this.vtxBones;
    }

    public int[] getVerticesWeights() {
        return this.vtxWeights;
    }
}

