/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Sprite3D
extends Node {
    private boolean scaled;
    private Image2D image;
    private Appearance appearance;
    private int cropX;
    private int cropY;
    private int cropWidth;
    private int cropHeight;

    public Sprite3D(boolean var1, Image2D var2, Appearance var3) {
        this.scaled = var1;
        this.setImage(var2);
        this.setAppearance(var3);
    }

    public void setImage(Image2D var1) {
        if (var1 == null) {
            throw new NullPointerException();
        }
        this.removeReference(this.image);
        this.image = var1;
        this.addReference(this.image);
        this.cropY = 0;
        this.cropX = 0;
        this.cropWidth = Math.min(var1.getWidth(), 1024);
        this.cropHeight = Math.min(var1.getHeight(), 1024);
    }

    public Image2D getImage() {
        return this.image;
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public void setAppearance(Appearance var1) {
        this.removeReference(this.appearance);
        this.appearance = var1;
        this.addReference(this.appearance);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setCrop(int var1, int var2, int var3, int var4) {
        if (Math.abs(var3) > 1024 || Math.abs(var4) > 1024) {
            throw new IllegalArgumentException("width or height exceeds the MaxSpriteCropDimension:1024");
        }
        this.cropX = var1;
        this.cropY = var2;
        this.cropWidth = var3;
        this.cropHeight = var4;
    }

    public int getCropX() {
        return this.cropX;
    }

    public int getCropY() {
        return this.cropY;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    @Override
    protected void updateProperty(int property, float[] values) {
        switch (property) {
            case 259: {
                this.cropX = G3DUtils.round(values[0]);
                this.cropY = G3DUtils.round(values[1]);
                if (values.length <= 2) break;
                this.cropWidth = G3DUtils.limit(G3DUtils.round(values[2]), -1024, 1024);
                this.cropHeight = G3DUtils.limit(G3DUtils.round(values[3]), -1024, 1024);
                return;
            }
            default: {
                super.updateProperty(property, values);
            }
        }
    }

    @Override
    protected boolean rayIntersect(int scope, float[] ray, RayIntersection ri, Transform transform) {
        block18: {
            block19: {
                block20: {
                    block21: {
                        int var27;
                        int var26;
                        float[] var23;
                        float[] var22;
                        float var15;
                        block22: {
                            int var33;
                            int var32;
                            float var30;
                            float[] var29;
                            int var10002;
                            int var10001;
                            int[] var10000;
                            if ((scope & this.getScope()) == 0) {
                                return false;
                            }
                            if (this.appearance == null || this.image == null || !this.scaled || this.cropWidth == 0 || this.cropHeight == 0) break block18;
                            Camera var5 = ri.getCamera();
                            if (var5 == null || this.image == null) break block19;
                            int[] var6 = new int[]{this.cropX, this.cropY, this.cropWidth, this.cropHeight};
                            boolean var7 = var6[2] < 0;
                            boolean var8 = var6[3] < 0;
                            var6[2] = Math.abs(var6[2]);
                            var6[3] = Math.abs(var6[3]);
                            int[] var9 = new int[4];
                            if (!G3DUtils.intersectRectangle(var6[0], var6[1], var6[2], var6[3], 0, 0, this.image.getWidth(), this.image.getHeight(), var9)) {
                                return false;
                            }
                            Vector4f var10 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                            Vector4f var11 = new Vector4f(0.5f, 0.0f, 0.0f, 1.0f);
                            Vector4f var12 = new Vector4f(0.0f, 0.5f, 0.0f, 1.0f);
                            Transform var13 = new Transform();
                            this.getTransformTo(var5, var13);
                            var13.getImpl_().transform(var10);
                            var13.getImpl_().transform(var11);
                            var13.getImpl_().transform(var12);
                            Vector4f var14 = new Vector4f(var10);
                            var10.mul(1.0f / var10.w);
                            var11.mul(1.0f / var11.w);
                            var12.mul(1.0f / var12.w);
                            var15 = (var10.z - ray[6]) / (ray[7] - ray[6]);
                            var11.sub(var10);
                            var12.sub(var10);
                            Vector4f var16 = new Vector4f(var11.length(), 0.0f, 0.0f, 0.0f);
                            Vector4f var17 = new Vector4f(0.0f, var12.length(), 0.0f, 0.0f);
                            var16.add(var14);
                            var17.add(var14);
                            var5.getProjection(var13);
                            var13.getImpl_().transform(var14);
                            var13.getImpl_().transform(var16);
                            var13.getImpl_().transform(var17);
                            if (!(var14.w > 0.0f) || !(-var14.w < var14.z) || !(var14.z <= var14.w)) break block20;
                            var14.mul(1.0f / var14.w);
                            var16.mul(1.0f / var16.w);
                            var17.mul(1.0f / var17.w);
                            var16.sub(var14);
                            var17.sub(var14);
                            var16.x = var16.length() / (float)var6[2];
                            var17.y = var17.length() / (float)var6[3];
                            var14.x -= (float)(2 * var6[0] + var6[2] - 2 * var9[0] - var9[2]) * var16.x;
                            var14.y += (float)(2 * var6[1] + var6[3] - 2 * var9[1] - var9[3]) * var17.y;
                            var16.x *= (float)var9[2];
                            var17.y *= (float)var9[3];
                            float[] var18 = new float[12];
                            int[] var19 = new int[8];
                            var18[0] = var14.x - var16.x;
                            var18[1] = var14.y + var17.y;
                            var18[2] = var14.z;
                            var18[3] = var18[0];
                            var18[4] = var14.y - var17.y;
                            var18[5] = var18[2];
                            var18[6] = var14.x + var16.x;
                            var18[7] = var18[1];
                            var18[8] = var18[2];
                            var18[9] = var18[6];
                            var18[10] = var18[4];
                            var18[11] = var18[2];
                            if (!var7) {
                                var19[0] = var9[0];
                                var19[2] = var9[0];
                                var19[4] = var9[0] + var9[2];
                                var10000 = var19;
                                var10001 = 6;
                                var10002 = var9[0] + var9[2];
                            } else {
                                var19[0] = var9[0] + var9[2];
                                var19[2] = var9[0] + var9[2];
                                var19[4] = var9[0];
                                var10000 = var19;
                                var10001 = 6;
                                var10002 = var9[0];
                            }
                            var10000[var10001] = var10002;
                            if (!var8) {
                                var19[1] = var9[1];
                                var19[3] = var9[1] + var9[3];
                                var19[5] = var9[1];
                                var10000 = var19;
                                var10001 = 7;
                                var10002 = var9[1] + var9[3];
                            } else {
                                var19[1] = var9[1] + var9[3];
                                var19[3] = var9[1];
                                var19[5] = var9[1] + var9[3];
                                var10000 = var19;
                                var10001 = 7;
                                var10002 = var9[1];
                            }
                            var10000[var10001] = var10002;
                            float var20 = 2.0f * ri.getPickX() - 1.0f;
                            float var21 = 1.0f - 2.0f * ri.getPickY();
                            if (!(var20 >= var18[0]) || !(var20 <= var18[6]) || !(var21 <= var18[1]) || !(var21 >= var18[4])) break block21;
                            if (!ri.testDistance(var15)) {
                                return false;
                            }
                            var20 -= var18[0];
                            var21 = var18[1] - var21;
                            var22 = new float[]{0.0f};
                            var23 = new float[]{0.0f};
                            if (!var7) {
                                var29 = var22;
                                var10001 = 0;
                                var30 = (float)var19[0] + (float)(var19[4] - var19[0]) * var20 / (var18[6] - var18[0]);
                            } else {
                                var29 = var22;
                                var10001 = 0;
                                var30 = (float)var19[0] - (float)(var19[0] - var19[4]) * var20 / (var18[6] - var18[0]);
                            }
                            var29[var10001] = var30;
                            if (!var8) {
                                var29 = var23;
                                var10001 = 0;
                                var30 = (float)var19[1] + (float)(var19[3] - var19[1]) * var21 / (var18[1] - var18[4]);
                            } else {
                                var29 = var23;
                                var10001 = 0;
                                var30 = (float)var19[1] - (float)(var19[1] - var19[3]) * var21 / (var18[1] - var18[4]);
                            }
                            var29[var10001] = var30;
                            int var24 = G3DUtils.limit(G3DUtils.round(var22[0]), 0, this.image.getWidth() - 1);
                            int var25 = G3DUtils.limit(G3DUtils.round(var23[0]), 0, this.image.getWidth() - 1);
                            var22[0] = G3DUtils.limit(var22[0], 0.0f, (float)this.image.getWidth());
                            var23[0] = G3DUtils.limit(var23[0], 0.0f, (float)this.image.getHeight());
                            var26 = 0;
                            var27 = -1;
                            if (this.appearance.getCompositingMode() != null) {
                                var26 = (int)(this.appearance.getCompositingMode().getAlphaThreshold() * 256.0f);
                            }
                            byte[] var31 = this.image.getImageData();
                            switch (this.image.getFormat()) {
                                case 96: {
                                    var32 = var25 * this.image.getWidth() * 1 + var24 * 1;
                                    var33 = 0;
                                    break;
                                }
                                default: {
                                    break block22;
                                }
                                case 98: {
                                    var32 = var25 * this.image.getWidth() * 2 + var24 * 2;
                                    var33 = 1;
                                    break;
                                }
                                case 100: {
                                    var32 = var25 * this.image.getWidth() * 4 + var24 * 4;
                                    var33 = 3;
                                }
                            }
                            var27 = var31[var32 + var33];
                        }
                        var22[0] = var22[0] / (float)this.image.getWidth();
                        var23[0] = var23[0] / (float)this.image.getHeight();
                        if ((var27 & 0xFF) >= var26) {
                            return ri.endPick(var15, var22, var23, 0, this, new float[]{0.0f, 0.0f, 1.0f});
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

