/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Object3D;

public class TriangleStripArray
extends IndexBuffer {
    private int[] stripLengths;
    private IntBuffer buffer;

    public TriangleStripArray(int firstIndex, int[] stripLengths) {
        int i2;
        if (stripLengths == null) {
            throw new NullPointerException();
        }
        if (stripLengths.length == 0) {
            throw new IllegalArgumentException();
        }
        int sumStripLengths = 0;
        for (i2 = stripLengths.length - 1; i2 >= 0; --i2) {
            if (stripLengths[i2] < 3) {
                throw new IllegalArgumentException();
            }
            sumStripLengths += stripLengths[i2];
        }
        if (firstIndex + sumStripLengths > 65535) {
            throw new IllegalArgumentException();
        }
        this.indices = new int[sumStripLengths];
        for (i2 = 0; i2 < sumStripLengths; ++i2) {
            this.indices[i2] = firstIndex + i2;
        }
        this.stripLengths = new int[stripLengths.length];
        System.arraycopy(stripLengths, 0, this.stripLengths, 0, stripLengths.length);
        this.copyToNative();
    }

    public TriangleStripArray(int[] indices, int[] stripLengths) {
        int i2;
        if (indices == null || stripLengths == null) {
            throw new NullPointerException();
        }
        if (stripLengths.length == 0) {
            throw new IllegalArgumentException();
        }
        int sumStripLengths = 0;
        for (i2 = stripLengths.length - 1; i2 >= 0; --i2) {
            if (stripLengths[i2] < 3) {
                throw new IllegalArgumentException();
            }
            sumStripLengths += stripLengths[i2];
        }
        if (indices.length < sumStripLengths) {
            throw new IllegalArgumentException();
        }
        for (i2 = sumStripLengths - 1; i2 >= 0; --i2) {
            if (indices[i2] >= 0 && indices[i2] <= 65535) continue;
            throw new IllegalArgumentException();
        }
        this.indices = new int[sumStripLengths];
        System.arraycopy(indices, 0, this.indices, 0, sumStripLengths);
        this.stripLengths = new int[stripLengths.length];
        System.arraycopy(stripLengths, 0, this.stripLengths, 0, stripLengths.length);
        this.copyToNative();
    }

    @Override
    protected Object3D duplicateObject() {
        TriangleStripArray clone = (TriangleStripArray)super.duplicateObject();
        clone.indices = (int[])this.indices.clone();
        clone.stripLengths = (int[])this.stripLengths.clone();
        return clone;
    }

    public int getStripCount() {
        return this.stripLengths.length;
    }

    public int[] getIndexStrip(int index) {
        if (index >= 0 && index < this.stripLengths.length) {
            int sumStripLengths = 0;
            for (int i2 = 0; i2 < index; ++i2) {
                sumStripLengths += this.stripLengths[i2];
            }
            int[] resIndexStrip = new int[this.stripLengths[index]];
            System.arraycopy(this.indices, sumStripLengths, resIndexStrip, 0, this.stripLengths[index]);
            return resIndexStrip;
        }
        return null;
    }

    public IntBuffer getBuffer() {
        this.buffer.position(0);
        return this.buffer;
    }

    protected boolean getIndices(int index, int[] indices) {
        int index2 = 0;
        for (int i2 = 0; i2 < this.stripLengths.length; ++i2) {
            if (index < this.stripLengths[i2] - 2) {
                indices[0] = this.indices[index2 + index + 0];
                indices[1] = this.indices[index2 + index + 1];
                indices[2] = this.indices[index2 + index + 2];
                indices[3] = index & 1;
                return true;
            }
            index -= this.stripLengths[i2] - 2;
            index2 += this.stripLengths[i2];
        }
        return false;
    }

    @Override
    public void getIndices(int[] indices) {
        int stripCount = this.stripLengths.length;
        int k2 = 0;
        int m2 = 0;
        for (int i2 = 0; i2 < stripCount; ++i2) {
            for (int j = 0; j < this.stripLengths[i2] - 2; ++j) {
                if ((j & 1) == 0) {
                    indices[k2++] = this.indices[m2 + 0];
                    indices[k2++] = this.indices[m2 + 1];
                } else {
                    indices[k2++] = this.indices[m2 + 1];
                    indices[k2++] = this.indices[m2 + 0];
                }
                indices[k2++] = this.indices[m2 + 2];
                ++m2;
            }
            m2 += 2;
        }
    }

    @Override
    public int getIndexCount() {
        int count = 0;
        int stripCount = this.stripLengths.length;
        for (int i2 = 0; i2 < stripCount; ++i2) {
            count += this.stripLengths[i2] - 2;
        }
        return count * 3;
    }

    private void copyToNative() {
        int strip;
        int joinedIndexCount = 0;
        int stripCount = this.stripLengths.length;
        for (strip = 0; strip < stripCount; ++strip) {
            if (strip != 0) {
                joinedIndexCount += (joinedIndexCount & 1) != 0 ? 3 : 2;
            }
            joinedIndexCount += this.stripLengths[strip];
        }
        this.allocateBuffer(joinedIndexCount);
        int src = 0;
        for (strip = 0; strip < stripCount; ++strip) {
            if (strip != 0) {
                this.buffer.put(this.indices[src - 1]);
                this.buffer.put(this.indices[src]);
                if ((this.stripLengths[strip - 1] & 1) != 0) {
                    this.buffer.put(this.indices[src]);
                }
            }
            for (int i2 = 0; i2 < this.stripLengths[strip]; ++i2) {
                this.buffer.put(this.indices[src++]);
            }
        }
    }

    private IntBuffer allocateBuffer(int size) {
        this.buffer = ByteBuffer.allocateDirect(size << 2).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.buffer.position(0);
        return this.buffer;
    }

    public int profilerCount() {
        return this.indices.length - this.stripLengths.length * 2;
    }
}

