/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import emulator.Emulator;
import emulator.Settings;
import emulator.custom.ResourceManager;
import emulator.media.capture.CapturePlayerImpl;
import emulator.media.tone.MIDITonePlayer;
import emulator.media.tone.ToneManager;
import emulator.media.vlc.VLCPlayerImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.file.FileConnectionImpl;
import javax.microedition.media.MIDIImpl;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerImpl;
import javax.microedition.media.SystemTimeBaseImpl;
import javax.microedition.media.TimeBase;
import javax.microedition.media.protocol.DataSource;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.BaseNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;

public class Manager {
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";
    public static final String CONTENT_TYPE_UNKNOWN = "unknown";
    public static final String CONTENT_TYPE_MIDI = "audio/midi";
    public static final String CONTENT_TYPE_XMIDI = "audio/x-midi";
    public static final String CONTENT_TYPE_XWAVE = "audio/x-wav";
    public static final String CONTENT_TYPE_WAVE = "audio/wav";
    public static final String CONTENT_TYPE_TONE = "audio/x-tone-seq";
    public static final String CONTENT_TYPE_AMR = "audio/amr";
    public static final String CONTENT_TYPE_MPEG = "audio/mpeg";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_HTTP = "http";
    private static final byte[] MP3_HEADER = new byte[]{73, 68, 51};
    private static final byte[] MPEG1_2_VIDEO_HEADER = new byte[]{0, 0, 1, -77};
    private static final byte[] WAV_HEADER = new byte[]{82, 73, 70, 0, 0, 0, 0, 87, 65, 86, 69};
    private static final byte[] AVI_HEADER = new byte[]{82, 73, 70, 0, 0, 0, 0, 65, 86, 73, 32};
    static TimeBase systemTimeBase;
    private static Vector<String> kemAudio;
    private static Vector<String> kemVideo;
    private static Vector<String> vlcAudio;
    private static Vector<String> vlcVideo;
    private static int libVlcState;

    public static Player createPlayer(InputStream inputStream, String s) throws IOException, MediaException {
        Manager.log("createPlayer " + inputStream + " " + s);
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        if (s != null && s.startsWith("video/")) {
            Manager.requireLibVlc();
            return new VLCPlayerImpl(inputStream, s);
        }
        boolean buf = Settings.playerBufferAll;
        if (buf && !(inputStream instanceof ByteArrayInputStream)) {
            return new PlayerImpl(new ByteArrayInputStream(ResourceManager.getBytes(inputStream)), s);
        }
        return new PlayerImpl(inputStream, s);
    }

    public static Player createPlayer(String s) throws IOException, MediaException {
        Manager.log("createPlayer " + s);
        if (s.startsWith(TONE_DEVICE_LOCATOR)) {
            return new MIDITonePlayer();
        }
        if (s.startsWith(MIDI_DEVICE_LOCATOR)) {
            return new MIDIImpl();
        }
        if (s.startsWith("capture://image") || s.startsWith("capture://video") || s.startsWith("capture://devcam0") || s.startsWith("capture://devcam1")) {
            return new CapturePlayerImpl();
        }
        String contentType = null;
        try {
            contentType = Manager.getContentTypeFromLocation(s);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (contentType != null && contentType.startsWith("video/")) {
            Manager.requireLibVlc();
            if (s.startsWith("rtsp://") || s.startsWith("http://") || s.startsWith("https://") || s.startsWith("rtp://")) {
                return new VLCPlayerImpl(s, contentType);
            }
            if (s.startsWith("file:///")) {
                String f2 = null;
                FileConnectionImpl fc = (FileConnectionImpl)Connector.open(s);
                f2 = fc.getRealPath();
                fc.close();
                return new VLCPlayerImpl(f2, contentType);
            }
            if (s.indexOf(58) != -1) {
                return new VLCPlayerImpl(s, contentType);
            }
            return new VLCPlayerImpl(ResourceManager.getResourceAsStream(s), contentType);
        }
        if (contentType != null && contentType.startsWith("audio/")) {
            if (s.startsWith("rtsp://") || s.startsWith("rtp://") || Manager.isAudioContentTypeRequiresLibVlc(contentType)) {
                Manager.requireLibVlc();
                return new VLCPlayerImpl(s, contentType);
            }
            if (s.startsWith("file:///")) {
                FileConnectionImpl fc = (FileConnectionImpl)Connector.open(s);
                String f3 = fc.getRealPath();
                fc.close();
                return new PlayerImpl(f3, contentType);
            }
            if (s.indexOf(58) != -1) {
                return Manager.createPlayer(((InputConnection)Connector.open(s)).openInputStream(), contentType);
            }
            return Manager.createPlayer(ResourceManager.getResourceAsStream(s), contentType);
        }
        throw new MediaException("Unknown content type");
    }

    public static Player createPlayer(DataSource src) throws IOException, MediaException {
        Manager.log("createPlayer DataSource(" + src + ")");
        String contentType = src.getContentType();
        String locator = src.getLocator();
        Manager.log("DataSource Content-Type: " + contentType);
        Manager.log("DataSource Locator: " + locator);
        Player player = null;
        if (contentType != null) {
            if (contentType.startsWith("audio/") && Manager.isAudioContentTypeSupportedForDataSource(contentType)) {
                if (locator != null) {
                    if (locator.startsWith("rtsp://") || locator.startsWith("rtp://")) {
                        Manager.requireLibVlc();
                        return new VLCPlayerImpl(locator, contentType);
                    }
                    if (locator.indexOf(58) != -1) {
                        return Manager.createPlayer(Connector.openInputStream(locator), contentType);
                    }
                    return Manager.createPlayer(ResourceManager.getResourceAsStream(locator), contentType);
                }
                player = new PlayerImpl(contentType, src);
            } else if (contentType.startsWith("video/") || Manager.isLibVlcSupported()) {
                Manager.requireLibVlc();
                if (locator != null) {
                    src.connect();
                    player = new VLCPlayerImpl(locator, contentType, src);
                } else {
                    player = new VLCPlayerImpl(contentType, src);
                }
            } else {
                throw new MediaException("Content type not supported: " + contentType);
            }
        }
        if (player == null && locator != null) {
            if (locator.startsWith("rtps://") || locator.startsWith("rtp://")) {
                Manager.requireLibVlc();
                return new VLCPlayerImpl(locator, contentType);
            }
            contentType = Manager.getContentTypeFromLocation(src.getLocator());
            Manager.log("getContentType(): " + contentType);
            if (contentType != null && contentType.startsWith("video/")) {
                Manager.requireLibVlc();
                player = new VLCPlayerImpl(locator, contentType, src);
            } else {
                player = new PlayerImpl(locator, contentType, src);
            }
        }
        if (player == null) {
            // empty if block
        }
        if (player == null) {
            throw new MediaException("Unsupported DataSource");
        }
        return player;
    }

    private static void requireLibVlc() throws MediaException {
        if (!Manager.isLibVlcSupported()) {
            throw new MediaException("LibVlc required!");
        }
    }

    private static boolean checkMp3Header(byte[] header) {
        return header[0] == MP3_HEADER[0] && header[1] == MP3_HEADER[1] && header[2] == MP3_HEADER[2];
    }

    private static boolean checkMpeg1_2video(byte[] header) {
        return header[0] == MPEG1_2_VIDEO_HEADER[0] && header[1] == MPEG1_2_VIDEO_HEADER[1] && header[2] == MPEG1_2_VIDEO_HEADER[2] && header[3] == MPEG1_2_VIDEO_HEADER[3];
    }

    private static boolean checkMpegTransportStream(byte[] header) {
        return header[0] == 71;
    }

    private static boolean isAudioContentTypeRequiresLibVlc(String c2) {
        for (String s : kemAudio) {
            if (!c2.equals(s)) continue;
            return false;
        }
        for (String s : vlcAudio) {
            if (!c2.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAudioContentTypeSupportedForDataSource(String c2) {
        return c2.equals(CONTENT_TYPE_MPEG) || c2.equals("audio/mp3") || c2.equals(CONTENT_TYPE_AMR) || c2.equals("audio/aac") || c2.equals(CONTENT_TYPE_WAVE);
    }

    public static String[] getSupportedContentTypes(String protocol) {
        Vector<String> fullList = new Vector<String>();
        fullList.addAll(kemAudio);
        fullList.addAll(kemVideo);
        boolean vlc = Manager.isLibVlcSupported();
        if (vlc) {
            fullList.addAll(vlcAudio);
            fullList.addAll(vlcVideo);
        }
        String[] arr = fullList.toArray(new String[0]);
        if (protocol == null || protocol.length() <= 1) {
            return arr;
        }
        if (protocol.startsWith(PROTOCOL_HTTP)) {
            return new String[]{CONTENT_TYPE_MPEG, "audio/mp3", CONTENT_TYPE_AMR};
        }
        if (protocol.startsWith("rtsp") || protocol.startsWith("rtp")) {
            if (vlc) {
                Vector rtsp = new Vector();
                return new String[]{CONTENT_TYPE_MPEG, "audio/mp3", CONTENT_TYPE_AMR};
            }
            return new String[0];
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (String t : arr) {
            if (!t.startsWith(protocol.toLowerCase())) continue;
            list2.add(t);
        }
        return list2.toArray(new String[0]);
    }

    private static String getContentTypeFromLocation(String locator) throws IOException {
        String c2 = null;
        if (locator.startsWith("http://") || locator.startsWith("https://")) {
            try {
                c2 = Manager.getContentTypeHttp(locator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (c2 == null || c2.equals("text/plain")) {
                c2 = Manager.getContentTypeFromURL(locator);
            }
        } else {
            c2 = Manager.getContentTypeFromURL(locator);
        }
        return c2;
    }

    private static String getContentTypeHttp(String locator) throws IOException {
        int rc;
        HttpConnection hc = (HttpConnection)Connector.open(locator);
        hc.setRequestMethod("HEAD");
        if (hc.getResponseCode() == 405) {
            hc.close();
            hc = null;
            hc = (HttpConnection)Connector.open(locator);
            hc.setRequestMethod("GET");
        }
        if ((rc = hc.getResponseCode()) != 200) {
            throw new IOException("HTTP response code: " + rc);
        }
        String cntype = hc.getHeaderField("Content-Type");
        hc.close();
        hc = null;
        return cntype;
    }

    public static String[] getSupportedProtocols(String type) {
        Vector<String> kem = new Vector<String>();
        kem.add(TONE_DEVICE_LOCATOR);
        kem.add("capture://video");
        kem.add("capture://image");
        kem.add(PROTOCOL_FILE);
        kem.add(PROTOCOL_HTTP);
        kem.add("https");
        Vector<String> vlc = new Vector<String>();
        vlc.add("rtsp");
        vlc.add("rtp");
        Vector<String> fullList = new Vector<String>(kem);
        if (Manager.isLibVlcSupported()) {
            fullList.addAll(vlc);
        }
        return fullList.toArray(new String[0]);
    }

    public static String getContentTypeFromURL(String url) throws IOException {
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.endsWith(".amr")) {
            return CONTENT_TYPE_AMR;
        }
        if (url.endsWith(".aac")) {
            return "audio/aac";
        }
        if (url.endsWith(".awb")) {
            return "audio/amr-wb";
        }
        if (url.endsWith(".mp3")) {
            return CONTENT_TYPE_MPEG;
        }
        if (url.endsWith(".wma")) {
            return "audio/x-ms-wma";
        }
        if (url.endsWith(".ra")) {
            return "audio/x-pn-realaudio";
        }
        if (url.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (url.endsWith(".mpg") || url.endsWith(".mpeg")) {
            return "video/mpeg";
        }
        if (url.endsWith(".3gpp") || url.endsWith(".3gp")) {
            return "video/3gpp";
        }
        if (url.endsWith(".3gpp2") || url.endsWith(".3g2")) {
            return "video/3gpp2";
        }
        if (url.endsWith(".mid")) {
            return CONTENT_TYPE_MIDI;
        }
        if (url.endsWith(".midi")) {
            return CONTENT_TYPE_XMIDI;
        }
        if (url.endsWith(".avi")) {
            return "video/x-msvideo";
        }
        if (url.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (url.endsWith(".flv")) {
            return "video/flv";
        }
        if (url.endsWith(".ogg") || url.endsWith(".oga")) {
            return "audio/ogg";
        }
        if (url.endsWith(".ogv")) {
            return "video/ogg";
        }
        if (url.endsWith(".opus")) {
            return "audio/opus";
        }
        if (url.endsWith(".webm")) {
            return "video/webm";
        }
        if (url.endsWith(".weba")) {
            return "audio/webm";
        }
        if (url.endsWith(".m3u")) {
            return "audio/x-mpegurl";
        }
        if (url.endsWith(".m4v")) {
            return "video/x-m4v";
        }
        if (url.endsWith(".mpga")) {
            return "audio/mpga";
        }
        if (url.endsWith(".wav")) {
            return CONTENT_TYPE_WAVE;
        }
        return null;
    }

    public static boolean isLibVlcSupported() {
        try {
            while (libVlcState == 0) {
                Thread.sleep(5L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return libVlcState == 1;
    }

    public static void checkLibVlcSupport() {
        try {
            NativeDiscovery nd;
            boolean b2;
            ArrayList<BaseNativeDiscoveryStrategy> list2 = new ArrayList<BaseNativeDiscoveryStrategy>();
            if (Settings.vlcDir != null && Settings.vlcDir.length() > 2) {
                BaseNativeDiscoveryStrategy win = new BaseNativeDiscoveryStrategy(new String[]{"libvlc\\.dll", "libvlccore\\.dll"}, new String[]{"%s\\plugins", "%s\\vlc\\plugins"}){

                    @Override
                    public boolean supported() {
                        return Emulator.isX64() ? RuntimeUtil.isWindows() : true;
                    }

                    @Override
                    public List<String> discoveryDirectories() {
                        ArrayList<String> directories = new ArrayList<String>();
                        try {
                            directories.add(new File(Settings.vlcDir).getCanonicalPath());
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        return directories;
                    }

                    @Override
                    protected boolean setPluginPath(String pluginPath) {
                        return LibC.INSTANCE._putenv(String.format("%s=%s", "VLC_PLUGIN_PATH", pluginPath)) == 0;
                    }
                };
                list2.add(win);
            }
            list2.add(new WindowsNativeDiscoveryStrategy());
            if (Emulator.isX64()) {
                list2.add(new OsxNativeDiscoveryStrategy());
                list2.add(new LinuxNativeDiscoveryStrategy());
            }
            int n = libVlcState = (b2 = (nd = new NativeDiscovery(list2.toArray(new NativeDiscoveryStrategy[0]))).discover()) ? 1 : -1;
            if (b2) {
                Manager.log("LibVlc loaded");
                return;
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        Manager.log("LibVlc not loaded");
        libVlcState = -1;
    }

    public static synchronized void playTone(int note, int duration, int volume) throws MediaException {
        ToneManager.play(note, duration, volume);
    }

    public static TimeBase getSystemTimeBase() {
        if (systemTimeBase == null) {
            systemTimeBase = new SystemTimeBaseImpl();
        }
        return systemTimeBase;
    }

    public static void log(String s) {
        Emulator.getEmulator().getLogStream().println("[MEDIA] " + s);
    }

    static {
        kemAudio = new Vector();
        kemAudio.add("audio/mid");
        kemAudio.add(CONTENT_TYPE_MIDI);
        kemAudio.add(CONTENT_TYPE_XMIDI);
        kemAudio.add(CONTENT_TYPE_WAVE);
        kemAudio.add(CONTENT_TYPE_XWAVE);
        kemAudio.add(CONTENT_TYPE_TONE);
        kemAudio.add(CONTENT_TYPE_AMR);
        kemAudio.add("audio/x-amr");
        kemAudio.add(CONTENT_TYPE_MPEG);
        kemAudio.add("audio/mp3");
        kemVideo = new Vector();
        vlcAudio = new Vector();
        vlcAudio.add("audio/amr-wb");
        vlcAudio.add("audio/aac");
        vlcAudio.add("audio/x-ms-wma");
        vlcAudio.add("audio/mp4");
        vlcAudio.add("audio/webm");
        vlcAudio.add("audio/3gpp");
        vlcAudio.add("audio/3gpp2");
        vlcAudio.add("audio/ogg");
        vlcAudio.add("audio/opus");
        vlcAudio.add("audio/adpcm");
        vlcAudio.add("audio/x-aac");
        vlcAudio.add("audio/x-mpegurl");
        vlcAudio.add("audio/mpga");
        vlcVideo = new Vector();
        vlcVideo.add("video/mpeg");
        vlcVideo.add("video/mpeg-4");
        vlcVideo.add("video/mp4");
        vlcVideo.add("video/h.263");
        vlcVideo.add("video/h264");
        vlcVideo.add("video/h.264");
        vlcVideo.add("video/h.265");
        vlcVideo.add("video/quicktime");
        vlcVideo.add("video/x-ms-video");
        vlcVideo.add("video/3gpp");
        vlcVideo.add("video/3gpp2");
        vlcVideo.add("video/flv");
        vlcVideo.add("video/mp2t");
        vlcVideo.add("video/webm");
        vlcVideo.add("video/ogg");
    }
}

