/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import emulator.Emulator;
import emulator.Settings;
import emulator.custom.ResourceManager;
import emulator.media.EmulatorMIDI;
import emulator.media.amr.AMRDecoder;
import emulator.media.tone.ToneControlImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.zip.CRC32;
import javax.microedition.io.Connector;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.MIDIControlImpl;
import javax.microedition.media.control.VolumeControlImpl;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javazoom.jl.decoder.JavaLayerException;

public class PlayerImpl
implements Player,
Runnable,
LineListener,
MetaEventListener {
    private static int count;
    private static boolean midiPlaying;
    public static Set<Player> players;
    Object sequence;
    Thread playerThread;
    boolean complete;
    private int state = 100;
    private String contentType;
    private Vector<PlayerListener> listeners;
    Control midiControl;
    Control toneControl;
    Control volumeControl;
    Control[] controls;
    TimeBase timeBase;
    public int loopCount = 1;
    public int dataLen;
    private DataSource dataSource;
    private boolean dataSourceDisconnected;
    private int level = 100;
    private byte[] data;
    private long mediaTime;
    private final Object playLock = new Object();
    private Sequencer midiSequencer;
    private Synthesizer midiSynthesizer;
    private boolean stopped;
    private InputStream inputStream;
    private boolean realized;
    private static final Vector<WavCache> wavCache;
    private WavCache cacheRef;

    public PlayerImpl() {
        this.listeners = new Vector();
        this.timeBase = Manager.getSystemTimeBase();
        this.volumeControl = new VolumeControlImpl(this);
        this.toneControl = new ToneControlImpl();
        if (Settings.enableMediaDump) {
            players.add(this);
        }
    }

    public PlayerImpl(String contentType, DataSource src) throws IOException, MediaException {
        this();
        this.contentType = contentType;
        this.dataSource = src;
    }

    public PlayerImpl(InputStream inputStream, String contentType) throws IOException {
        this();
        this.init(inputStream, contentType);
    }

    public PlayerImpl(String locator, String contentType, DataSource src) throws IOException {
        this();
        if (locator != null) {
            this.inputStream = Connector.openInputStream(locator);
        }
        this.contentType = contentType;
        this.dataSource = src;
    }

    public PlayerImpl(String file, String contentType) throws IOException {
        this();
        this.dataLen = (int)new File(file).length();
        this.init(new FileInputStream(file), contentType);
    }

    private void init(InputStream inputStream, String contentType) throws IOException {
        if (contentType == null) {
            contentType = "";
        }
        this.contentType = contentType.toLowerCase();
        if (this.dataLen == 0) {
            this.dataLen = inputStream.available();
        }
        this.inputStream = inputStream;
    }

    private void amr(InputStream inputStream) throws IOException {
        this.controls = new Control[]{this.toneControl, this.volumeControl};
        try {
            this.data = ResourceManager.getBytes(inputStream);
            byte[] b2 = AMRDecoder.decode(this.data);
            if (b2 == null) {
                throw new MediaException("Cannot parse AMR data");
            }
            if (Settings.enableMediaDump) {
                this.data = b2;
            }
            this.inputStream = new ByteArrayInputStream(b2);
            ByteArrayInputStream i2 = this.inputStream;
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false);
            AudioInputStream audioInputStream = new AudioInputStream(i2, audioFormat, -1L);
            Clip clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, audioFormat));
            clip.addLineListener(this);
            clip.open(audioInputStream);
            this.sequence = clip;
        }
        catch (Throwable e2) {
            Emulator.getEmulator().getLogStream().println("AMR realize error: " + e2);
            this.sequence = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wav(InputStream inputStream) throws IOException {
        block12: {
            this.controls = new Control[]{this.toneControl, this.volumeControl};
            WavCache key = null;
            try {
                if (inputStream instanceof ByteArrayInputStream || Settings.enableMediaDump) {
                    byte[] data = ResourceManager.getBytes(inputStream);
                    if (Settings.wavCache) {
                        key = new WavCache(data);
                        Vector<WavCache> vector2 = wavCache;
                        synchronized (vector2) {
                            int i2 = wavCache.indexOf(key);
                            if (i2 != -1) {
                                key = wavCache.get(i2);
                                this.sequence = key.clip;
                                this.cacheRef = key;
                                key.setPlayer(this);
                                this.setMediaTime(0L);
                                return;
                            }
                            wavCache.add(key);
                        }
                    }
                    inputStream = this.inputStream = new ByteArrayInputStream(data);
                }
                this.sequence = AudioSystem.getAudioInputStream(inputStream);
                AudioInputStream audioInputStream = (AudioInputStream)this.sequence;
                AudioFormat format = audioInputStream.getFormat();
                if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                    AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                    audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
                    format = audioFormat;
                }
                Clip clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * format.getFrameSize()));
                clip.addLineListener(Settings.wavCache ? key : this);
                clip.open(audioInputStream);
                this.sequence = clip;
                if (!Settings.wavCache || key == null) break block12;
                Vector<WavCache> vector3 = wavCache;
                synchronized (vector3) {
                    key.clip = (Clip)this.sequence;
                    key.setPlayer(this);
                    this.cacheRef = key;
                }
            }
            catch (Exception e2) {
                System.out.println("WAV realize error: " + e2);
                this.sequence = null;
            }
        }
    }

    private void midi(InputStream inputStream) throws IOException {
        try {
            byte[] data = ResourceManager.getBytes(inputStream);
            if (Settings.enableMediaDump) {
                this.data = data;
            }
            this.inputStream = new ByteArrayInputStream(data);
            this.sequence = MidiSystem.getSequence(this.inputStream);
        }
        catch (Exception e2) {
            this.sequence = null;
        }
        this.midiControl = new MIDIControlImpl(this);
        this.controls = new Control[]{this.toneControl, this.volumeControl, this.midiControl};
    }

    public void setMIDISequence(InputStream in) throws IOException {
        this.midi(in);
    }

    @Override
    public void addPlayerListener(PlayerListener playerListener) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (playerListener != null) {
            this.listeners.add(playerListener);
        }
    }

    @Override
    public void removePlayerListener(PlayerListener playerListener) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (playerListener != null) {
            this.listeners.remove(playerListener);
        }
    }

    protected void notifyListeners(String s, Object o) {
        if (this.listeners == null) {
            return;
        }
        Enumeration<PlayerListener> elements = this.listeners.elements();
        while (elements.hasMoreElements()) {
            elements.nextElement().playerUpdate(this, s.intern(), o);
        }
    }

    @Override
    public void close() {
        players.remove(this);
        if (this.playerThread != null) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sequence instanceof javazoom.jl.player.Player) {
            ((javazoom.jl.player.Player)this.sequence).close();
        } else if (this.sequence instanceof Sequence) {
            if (this.midiSynthesizer != null) {
                this.midiSynthesizer.close();
                this.midiSynthesizer = null;
            }
            if (this.midiSequencer != null) {
                this.midiSequencer.close();
                this.midiSequencer = null;
            }
            if (Settings.oneMidiAtTime) {
                EmulatorMIDI.close(false);
            }
        }
        if (this.inputStream != null) {
            this.inputStream = null;
        }
        if (this.dataSource != null && !this.dataSourceDisconnected) {
            this.dataSource.disconnect();
            this.dataSourceDisconnected = true;
        }
        this.sequence = null;
        this.state = 0;
        this.notifyListeners("closed", null);
    }

    @Override
    public void deallocate() throws IllegalStateException {
        players.remove(this);
        this.data = null;
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 400) {
            try {
                this.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        if (this.inputStream != null) {
            this.inputStream = null;
        }
        if (this.state == 300) {
            this.state = 200;
        } else if (this.state == 200) {
            this.state = 100;
        } else {
            return;
        }
        if (this.dataSource != null && this.dataSource.getStreams() != null && this.dataSource.getStreams()[0] != null && !this.dataSourceDisconnected && this.dataSource.getStreams()[0].getSeekType() == 0) {
            this.dataSource.disconnect();
            this.dataSourceDisconnected = true;
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getDuration() {
        double res;
        if (this.sequence == null) {
            return 0L;
        }
        if (this.sequence instanceof Sequence) {
            return ((Sequence)this.sequence).getMicrosecondLength();
        }
        if (this.sequence instanceof Clip) {
            Clip clip = (Clip)this.sequence;
            res = (float)clip.getBufferSize() / ((float)clip.getFormat().getFrameSize() * clip.getFormat().getFrameRate());
        } else if (this.sequence instanceof javazoom.jl.player.Player) {
            try {
                res = (double)(this.dataLen * 8) / (double)((javazoom.jl.player.Player)this.sequence).getBitrate();
            }
            catch (ArithmeticException e2) {
                return -1L;
            }
        } else {
            return 0L;
        }
        return (long)(res * 1000000.0);
    }

    @Override
    public long getMediaTime() {
        if (this.sequence == null) {
            return this.mediaTime;
        }
        if (this.sequence instanceof Clip) {
            this.mediaTime = ((Clip)this.sequence).getMicrosecondPosition();
            return this.mediaTime;
        }
        if (this.sequence instanceof Sequence) {
            try {
                if (this.midiSequencer != null) {
                    this.mediaTime = this.midiSequencer.getMicrosecondPosition();
                } else if (Settings.oneMidiAtTime && EmulatorMIDI.currentPlayer == this && midiPlaying) {
                    this.mediaTime = EmulatorMIDI.getMicrosecondPosition();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.mediaTime;
        }
        if (this.sequence instanceof javazoom.jl.player.Player) {
            this.mediaTime = (long)((javazoom.jl.player.Player)this.sequence).getPosition() * 1000L;
            return this.mediaTime;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public long setMediaTime(long t) throws MediaException {
        if (this.sequence == null) {
            return 0L;
        }
        ms = 0L;
        if (this.sequence instanceof Clip) {
            ms = ((Clip)this.sequence).getMicrosecondLength();
            if (t < ms) {
                ms = t;
            }
            if (ms < 0L) {
                ms = 0L;
            }
            var5_3 = this.sequence;
            synchronized (var5_3) {
                this.mediaTime = t;
                ((Clip)this.sequence).setMicrosecondPosition(this.mediaTime);
            }
        }
        if (this.sequence instanceof Sequence) {
            ms = ((Sequence)this.sequence).getMicrosecondLength();
            if (t < ms) {
                ms = t;
            }
            if (ms < 0L) {
                ms = 0L;
            }
            this.mediaTime = ms;
            try {
                if (this.midiSequencer != null) {
                    this.midiSequencer.setMicrosecondPosition(ms);
                }
                if (!Settings.oneMidiAtTime || EmulatorMIDI.currentPlayer != this) ** GOTO lbl61
                EmulatorMIDI.setMicrosecondPosition(ms);
            }
            catch (Exception e) {
                throw new MediaException(e);
            }
        } else if (this.sequence instanceof javazoom.jl.player.Player) {
            l = this.getMediaTime();
            if (t == 0L && l == 0L || !((javazoom.jl.player.Player)this.sequence).isBuffered) {
                return 0L;
            }
            if (t < l) {
                try {
                    this.stop();
                    old = ((javazoom.jl.player.Player)this.sequence).bitstream().header;
                    ((javazoom.jl.player.Player)this.sequence).reset();
                    ((javazoom.jl.player.Player)this.sequence).skip((int)(t / 1000L), old);
                    ms = (long)((javazoom.jl.player.Player)this.sequence).getPosition() * 1000L;
                    this.start();
                }
                catch (JavaLayerException e) {
                    throw new MediaException(e);
                }
            }
            try {
                this.stop();
                old = ((javazoom.jl.player.Player)this.sequence).bitstream().header;
                ((javazoom.jl.player.Player)this.sequence).reset();
                ((javazoom.jl.player.Player)this.sequence).skip((int)(t / 1000L), old);
                ms = (long)((javazoom.jl.player.Player)this.sequence).getPosition() * 1000L;
                this.start();
            }
            catch (JavaLayerException e) {
                throw new MediaException(e);
            }
        }
lbl61:
        // 8 sources

        this.mediaTime = ms;
        return this.mediaTime;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void prefetch() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 100) {
            this.realize();
        } else if (this.state != 200) {
            return;
        }
        if (this.sequence instanceof Sequence) {
            try {
                EmulatorMIDI.initDevice();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new MediaException(e2);
            }
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.connect();
            }
            catch (IOException e3) {
                e3.printStackTrace();
                throw new MediaException(e3);
            }
        }
        this.state = 300;
    }

    @Override
    public void realize() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.state == 100) {
            this.state = 200;
        }
        if (this.realized) {
            return;
        }
        this.realized = true;
        if (this.inputStream != null) {
            try {
                if ("audio/amr".equals(this.contentType) || "audio/x-amr".equals(this.contentType)) {
                    this.amr(this.inputStream);
                } else if ("audio/x-wav".equals(this.contentType) || "audio/wav".equals(this.contentType)) {
                    this.wav(this.inputStream);
                } else if ("audio/x-midi".equals(this.contentType) || "audio/midi".equals(this.contentType)) {
                    this.midi(this.inputStream);
                } else if ("audio/mpeg".equals(this.contentType) || "audio/mp3".equals(this.contentType)) {
                    try {
                        InputStream i2 = this.inputStream;
                        if (i2 instanceof ByteArrayInputStream || Settings.enableMediaDump) {
                            this.data = ResourceManager.getBytes(i2);
                            i2 = this.inputStream = new ByteArrayInputStream(this.data);
                        }
                        this.sequence = new javazoom.jl.player.Player(i2, false);
                    }
                    catch (JavaLayerException e2) {
                        e2.printStackTrace();
                        throw new IOException(e2);
                    }
                    this.controls = new Control[]{this.volumeControl};
                } else {
                    try {
                        this.midi(this.inputStream);
                    }
                    catch (Exception e3) {
                        try {
                            this.wav(this.inputStream);
                        }
                        catch (Exception e2) {
                            try {
                                this.amr(this.inputStream);
                            }
                            catch (Exception e32) {
                                Emulator.getEmulator().getLogStream().println("*** unsupported sound format ***");
                                this.sequence = null;
                            }
                        }
                    }
                }
                this.setLevel(this.level);
                return;
            }
            catch (IOException e4) {
                throw new MediaException(e4);
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.connect();
            }
            catch (IOException e5) {
                throw new MediaException(e5.toString());
            }
            boolean mp3 = false;
            final SourceStream stream = this.dataSource.getStreams()[0];
            String streamContentType = stream.getContentDescriptor().getContentType();
            if (streamContentType != null && (streamContentType.equalsIgnoreCase("audio/mpeg") || this.contentType.equalsIgnoreCase("audio/mp3"))) {
                mp3 = true;
                if (this.contentType == null) {
                    this.contentType = "audio/mpeg";
                }
            }
            if (mp3 || this.contentType.equalsIgnoreCase("audio/mpeg") || this.contentType.equalsIgnoreCase("audio/mp3")) {
                this.dataLen = (int)stream.getContentLength();
                try {
                    this.sequence = new javazoom.jl.player.Player(new InputStream(){

                        @Override
                        public int read() throws IOException {
                            byte[] b2 = new byte[1];
                            int i2 = this.read(b2, 0, 1);
                            if (i2 == 1) {
                                return b2[0] & 0xFF;
                            }
                            return -1;
                        }

                        @Override
                        public int read(byte[] b2, int i2, int j) throws IOException {
                            return stream.read(b2, i2, j);
                        }
                    }, false);
                }
                catch (IOException e6) {
                    throw new MediaException(e6);
                }
                catch (JavaLayerException e7) {
                    throw new MediaException(e7);
                }
                this.controls = new Control[]{this.volumeControl};
                this.setLevel(this.level);
                this.listeners = new Vector();
                this.timeBase = Manager.getSystemTimeBase();
            } else {
                throw new MediaException("Unsupported content type: " + this.contentType);
            }
        }
    }

    @Override
    public void setLoopCount(int loopCount) {
        if (loopCount == 0) {
            throw new IllegalArgumentException();
        }
        this.loopCount = loopCount;
    }

    @Override
    public void start() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        boolean midi = this.sequence instanceof Sequence;
        if (this.state == 100) {
            this.realize();
        }
        if (this.state < 300 && midi) {
            this.prefetch();
        }
        if (this.state != 400) {
            if (this.sequence != null) {
                if (midi) {
                    if (Settings.oneMidiAtTime && EmulatorMIDI.currentPlayer != null) {
                        if (midiPlaying && EmulatorMIDI.currentPlayer != this) {
                            try {
                                EmulatorMIDI.currentPlayer.stop();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        EmulatorMIDI.close(false);
                    }
                    if (this.midiSequencer != null) {
                        this.midiSequencer.close();
                        this.midiSequencer = null;
                    }
                }
                if (this.complete) {
                    this.setMediaTime(0L);
                    this.complete = false;
                }
                if (this.cacheRef != null) {
                    this.cacheRef.setPlayer(this);
                }
            } else {
                this.notifyListeners("started", 0);
                this.notifyListeners("endOfMedia", 0);
                return;
            }
            this.stopped = false;
            this.playerThread = new Thread((Runnable)this, "PlayerImpl-" + ++count);
            this.playerThread.start();
            this.setLevel(this.level);
            this.state = 400;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IllegalStateException, MediaException {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.sequence == null) {
            return;
        }
        if (this.sequence instanceof javazoom.jl.player.Player) {
            ((javazoom.jl.player.Player)this.sequence).stop();
            return;
        }
        this.stopped = true;
        Object object = this.playLock;
        synchronized (object) {
            this.playLock.notifyAll();
        }
        if (this.playerThread != null) {
            Thread t = this.playerThread;
            this.playerThread = null;
            if (t.isAlive()) {
                try {
                    Thread thread = t;
                    synchronized (thread) {
                        t.wait(1000L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Control getControl(String s) {
        if (s.contains("VolumeControl")) {
            return this.volumeControl;
        }
        if (s.contains("ToneControl")) {
            return this.toneControl;
        }
        if (s.contains("MIDIControl")) {
            return this.midiControl;
        }
        return null;
    }

    @Override
    public Control[] getControls() {
        return this.controls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.sequence == null) {
                this.playerThread = null;
                this.state = 300;
                return;
            }
            players.add(this);
            boolean globalMidi = Settings.oneMidiAtTime;
            int loopCount = this.loopCount;
            boolean complete = false;
            boolean b2 = true;
            while (this.playerThread != null && loopCount != 0) {
                Object object;
                complete = false;
                if (this.sequence instanceof Sequence) {
                    Sequencer sequencer = null;
                    if (globalMidi) {
                        EmulatorMIDI.start(this, (Sequence)this.sequence, this.mediaTime);
                        EmulatorMIDI.currentPlayer = this;
                    } else {
                        this.initMidiSequencer();
                        sequencer = this.midiSequencer;
                        sequencer.setSequence((Sequence)this.sequence);
                        if (this.midiSequencer == null || this.mediaTime >= this.getDuration()) {
                            sequencer.setMicrosecondPosition(this.mediaTime);
                        }
                        sequencer.start();
                    }
                    if (b2) {
                        this.mediaTime = globalMidi ? EmulatorMIDI.getMicrosecondPosition() : this.midiSequencer.getMicrosecondPosition();
                        this.notifyListeners("started", this.mediaTime);
                        b2 = false;
                    }
                    midiPlaying = true;
                    if (!this.stopped) {
                        object = this.playLock;
                        synchronized (object) {
                            this.playLock.wait();
                        }
                    }
                    this.stopped = false;
                    complete = this.complete;
                    midiPlaying = false;
                    if (globalMidi) {
                        this.mediaTime = EmulatorMIDI.getMicrosecondPosition();
                        EmulatorMIDI.stop();
                    } else {
                        this.mediaTime = sequencer.getMicrosecondPosition();
                        sequencer.stop();
                    }
                } else {
                    if (this.sequence instanceof Clip) {
                        Clip clip = (Clip)this.sequence;
                        object = clip;
                        synchronized (object) {
                            clip.start();
                        }
                        if (b2) {
                            this.notifyListeners("started", this.getMediaTime());
                            b2 = false;
                        }
                        object = this.playLock;
                        synchronized (object) {
                            this.playLock.wait();
                        }
                        complete = this.complete;
                        object = clip;
                        synchronized (object) {
                            clip.stop();
                        }
                    }
                    if (this.sequence instanceof javazoom.jl.player.Player) {
                        if (b2) {
                            this.notifyListeners("started", this.getMediaTime());
                            b2 = false;
                        }
                        try {
                            complete = ((javazoom.jl.player.Player)this.sequence).play(Integer.MAX_VALUE);
                        }
                        catch (JavaLayerException e2) {
                            e2.printStackTrace();
                            this.notifyListeners("error", e2.toString());
                        }
                        if (complete || this.sequence != null && ((javazoom.jl.player.Player)this.sequence).isComplete()) {
                            complete = true;
                            if (this.dataSource != null) {
                                this.dataSource.disconnect();
                            }
                        }
                    }
                }
                if (!complete) break;
                if (loopCount != -1) {
                    if (loopCount <= 0) continue;
                    --loopCount;
                }
                if (loopCount == 0) continue;
                try {
                    this.setMediaTime(0L);
                }
                catch (MediaException mediaException) {}
            }
            this.playerThread = null;
            this.state = 300;
            this.notifyListeners(complete ? "endOfMedia" : "stopped", this.getMediaTime());
        }
        catch (Exception e3) {
            System.err.println("Exception in player thread!");
            e3.printStackTrace();
        }
        if (!Settings.enableMediaDump) {
            players.remove(this);
        }
    }

    @Override
    public void update(LineEvent lineEvent) {
        if (lineEvent.getType() == LineEvent.Type.STOP) {
            this.notifyCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        if (this.level != n) {
            this.notifyListeners("volumeChanged", n);
        }
        this.level = n;
        if (this.sequence == null) {
            return;
        }
        double n2 = (double)n / 100.0;
        if (this.sequence instanceof Clip) {
            Object object = this.sequence;
            synchronized (object) {
                try {
                    ((FloatControl)((Clip)this.sequence).getControl(FloatControl.Type.MASTER_GAIN)).setValue((float)(Math.log(n2 == 0.0 ? 1.0E-4 : n2) / Math.log(10.0) * 20.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.sequence instanceof Sequence) {
            return;
        }
        if (this.sequence instanceof javazoom.jl.player.Player) {
            ((javazoom.jl.player.Player)this.sequence).setLevel(n);
        }
    }

    @Override
    public TimeBase getTimeBase() {
        if (this.state == 100 || this.state == 0) {
            throw new IllegalStateException();
        }
        return this.timeBase;
    }

    @Override
    public void setTimeBase(TimeBase timeBase) throws MediaException {
        if (this.state == 100 || this.state == 400 || this.state == 0) {
            throw new IllegalStateException();
        }
        throw new MediaException("TimeBase can't be set on this player.");
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return (byte[])this.data.clone();
    }

    public String getExportName() {
        String ext = "";
        if (this.sequence instanceof Sequence) {
            ext = "mid";
        } else if (this.sequence instanceof javazoom.jl.player.Player) {
            ext = "mp3";
        } else if (this.contentType != null) {
            if (this.contentType.equalsIgnoreCase("audio/wav") || this.contentType.equalsIgnoreCase("audio/wave") || this.contentType.equalsIgnoreCase("audio/x-wav")) {
                ext = "wav";
            } else if (this.contentType.equalsIgnoreCase("audio/amr")) {
                ext = "amr";
            } else if (this.contentType.equalsIgnoreCase("audio/x-mid") || this.contentType.equalsIgnoreCase("audio/mid") || this.contentType.equalsIgnoreCase("audio/midi")) {
                ext = "mid";
            } else if (this.contentType.equalsIgnoreCase("audio/mpeg") || this.contentType.equalsIgnoreCase("audio/mp3")) {
                ext = "mp3";
            }
        }
        if (ext.isEmpty()) {
            return "audio" + this.hashCode();
        }
        return this.hashCode() + "." + ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCompleted() {
        this.complete = true;
        Object object = this.playLock;
        synchronized (object) {
            this.playLock.notifyAll();
        }
    }

    private void initMidiSequencer() throws MidiUnavailableException {
        if (this.midiSequencer != null) {
            return;
        }
        this.midiSequencer = MidiSystem.getSequencer(false);
        if (EmulatorMIDI.useExternalReceiver()) {
            EmulatorMIDI.setupSequencer(this.midiSequencer);
        } else {
            this.midiSynthesizer = MidiSystem.getSynthesizer();
            this.midiSynthesizer.open();
            this.midiSequencer.getTransmitter().setReceiver(this.midiSynthesizer.getReceiver());
        }
        this.midiSequencer.open();
        this.midiSequencer.addMetaEventListener(this);
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47) {
            this.notifyCompleted();
        }
    }

    private static long crcUtil(byte[] b2) {
        CRC32 crc = new CRC32();
        crc.update(b2);
        return crc.getValue();
    }

    public String getReadableImplementationType() {
        if (this.sequence == null) {
            return "Empty player";
        }
        if (this.sequence instanceof Sequence) {
            return "JVM MIDI";
        }
        if (this.sequence instanceof Clip) {
            return "JVM clip";
        }
        if (this.sequence instanceof javazoom.jl.player.Player) {
            return "javazoom";
        }
        return "MMAPI/unknown";
    }

    static {
        players = Collections.newSetFromMap(new WeakHashMap());
        wavCache = new Vector();
    }

    static class WavCache
    implements LineListener {
        int length;
        long crc;
        Set<Player> references;
        PlayerImpl currentPlayer;
        Clip clip;

        WavCache(byte[] b2) {
            this.length = b2.length;
            this.crc = PlayerImpl.crcUtil(b2);
        }

        void setPlayer(PlayerImpl player) {
            if (this.references == null) {
                this.references = Collections.newSetFromMap(new WeakHashMap());
            }
            try {
                this.currentPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentPlayer = player;
            this.references.add(player);
        }

        public boolean equals(Object other) {
            if (other instanceof WavCache) {
                return this.length == ((WavCache)other).length && this.crc == ((WavCache)other).crc;
            }
            if (other instanceof byte[]) {
                return ((byte[])other).length == this.length && PlayerImpl.crcUtil((byte[])other) == this.crc;
            }
            return false;
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.STOP && this.currentPlayer != null) {
                this.currentPlayer.notifyCompleted();
            }
        }
    }
}

