/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.midlet;

import emulator.Emulator;
import emulator.Permission;
import emulator.Settings;
import emulator.custom.CustomMethod;
import java.io.File;
import java.lang.reflect.Method;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class MIDlet {
    private boolean destroyed;

    public MIDlet() {
        Emulator.setMIDlet(this);
    }

    public int checkPermission(String s) {
        return 1;
    }

    public String getAppProperty(String s) {
        String r = Emulator.getEmulator().getAppProperty(s);
        Emulator.getEmulator().getLogStream().println("MIDlet.getAppProperty: " + s + "=" + r);
        return r;
    }

    public void notifyDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        Emulator.getEmulator().getLogStream().println("Destroy stack trace:");
        for (StackTraceElement e2 : new Exception().getStackTrace()) {
            Emulator.getEmulator().getLogStream().println("\tat " + e2.toString());
        }
        Emulator.notifyDestroyed();
        Emulator.getEmulator().getLogStream().println("Exiting Emulator");
        CustomMethod.close();
        System.exit(0);
    }

    public void notifyPaused() {
    }

    public boolean platformRequest(String url) throws ConnectionNotFoundException {
        try {
            Emulator.getEmulator().getLogStream().println("MIDlet.platformRequest: " + url);
            if (url.startsWith("vlc.exe \"")) {
                url = "vlc:" + url.substring(9, url.length() - 1);
            }
            if (!Permission.requestURLAccess(url)) {
                throw new SecurityException();
            }
            if (Settings.networkNotAvailable) {
                throw new ConnectionNotFoundException();
            }
            if (url.startsWith("file:///root/")) {
                url = "file:///" + (Emulator.getUserPath().replace("\\", "/") + "/file/" + url.substring(8)).replace(" ", "%20");
            }
            if (url.startsWith("vlc:")) {
                if ((url = url.substring(4)).indexOf(58) == -1) {
                    throw new ConnectionNotFoundException("Invalid URL");
                }
                if (url.startsWith("file:///root/")) {
                    url = "file:///" + (Emulator.getUserPath().replace("\\", "/") + "/file" + url.substring(13)).replace(" ", "%20");
                }
                if (Settings.vlcDir != null && Settings.vlcDir.length() > 2) {
                    Runtime.getRuntime().exec(new File(Settings.vlcDir).getCanonicalPath() + "/vlc \"" + url + "\"");
                    return false;
                }
                String vlcdir = "C:/Program Files/VideoLAN/VLC/vlc.exe";
                if (!Emulator.isX64() && new File(vlcdir).exists()) {
                    Runtime.getRuntime().exec(vlcdir + " \"" + url + "\"");
                    return false;
                }
                throw new ConnectionNotFoundException("vlc dir not set");
            }
            Emulator.openUrlExternally(url);
            return false;
        }
        catch (ConnectionNotFoundException e2) {
            throw e2;
        }
        catch (SecurityException e3) {
            throw e3;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            throw new ConnectionNotFoundException(e4);
        }
    }

    public void resumeRequest() {
    }

    protected abstract void destroyApp(boolean var1) throws MIDletStateChangeException;

    protected abstract void startApp() throws MIDletStateChangeException;

    protected abstract void pauseApp();

    public void invokeDestroyApp(boolean b2) {
        try {
            this.destroyApp(b2);
        }
        catch (Exception ex) {
            System.out.println("destroyApp exception!");
            ex.printStackTrace();
        }
        this.notifyDestroyed();
    }

    public void invokeStartApp() {
        try {
            this.startApp();
        }
        catch (MIDletStateChangeException ex) {
            System.out.println("startApp exception!");
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            System.out.println("startApp exception!");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        if (Settings.bypassVserv) {
            try {
                Class<?> cls = this.getClass();
                if (cls.getName().endsWith("ALW1")) {
                    Emulator.getEmulator().getLogStream().println("Trying to bypass ALW1");
                    Method m2 = cls.getMethod("startRealApp", new Class[0]);
                    m2.setAccessible(true);
                    m2.invoke((Object)this, new Object[0]);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void invokePauseApp() {
        this.pauseApp();
    }
}

