/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordEnumerationImpl
implements RecordEnumeration,
RecordListener {
    private RecordStore recordStore;
    private Object iSync;
    private RecordFilter iRecordFilter;
    private RecordComparator iRecordComparator;
    private boolean iKeepUpdated;
    private int[] iRecordIDs;
    private int iCurrentPos;

    public RecordEnumerationImpl(RecordStore aRms, Object aSync, RecordFilter aFilter, RecordComparator aComparator, boolean aKeepUpdated) {
        this.recordStore = aRms;
        this.iSync = aSync;
        this.iRecordFilter = aFilter;
        this.iRecordComparator = aComparator;
        this.keepUpdated(aKeepUpdated);
        this.reset();
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numRecords() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            return this.iRecordIDs.length;
        }
    }

    int getRecordId(int aIndex) throws IllegalArgumentException {
        Object object = this.iSync;
        synchronized (object) {
            try {
                return this.iRecordIDs[aIndex];
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] nextRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            int recID = this.nextRecordId();
            return this.getRecord(recID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextRecordId() throws InvalidRecordIDException {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            ++this.iCurrentPos;
            if (this.iCurrentPos >= this.iRecordIDs.length) {
                throw new InvalidRecordIDException("Next/previous record not found");
            }
            return this.iRecordIDs[this.iCurrentPos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] previousRecord() throws InvalidRecordIDException, RecordStoreNotOpenException, RecordStoreException {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            int recID = this.previousRecordId();
            return this.getRecord(recID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousRecordId() throws InvalidRecordIDException {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            if (this.iCurrentPos == 0 || this.iRecordIDs.length == 0) {
                throw new InvalidRecordIDException("Next/previous record not found");
            }
            this.iCurrentPos = this.iCurrentPos == -1 ? this.iRecordIDs.length - 1 : --this.iCurrentPos;
            return this.iRecordIDs[this.iCurrentPos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNextElement() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            return this.iCurrentPos < this.iRecordIDs.length - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPreviousElement() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            return this.iRecordIDs.length != 0 && this.iCurrentPos != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            this.iCurrentPos = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            try {
                this.iRecordIDs = this.recordStore.getRecordIds();
            }
            catch (RecordStoreException e2) {
                this.iRecordIDs = new int[0];
            }
            if (this.iRecordFilter != null) {
                this.doTagFilter();
            }
            if (this.iRecordComparator != null) {
                this.doSort();
            }
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keepUpdated(boolean aKeepUpdated) {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            this.iKeepUpdated = aKeepUpdated;
            if (this.iKeepUpdated) {
                this.rebuild();
                this.recordStore.addRecordListener(this);
            } else {
                this.recordStore.removeRecordListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeptUpdated() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            return this.iKeepUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.iSync;
        synchronized (object) {
            this.ensureNotDestroyed();
            this.keepUpdated(false);
            this.iRecordFilter = null;
            this.iRecordComparator = null;
            this.iRecordIDs = null;
            this.recordStore = null;
        }
    }

    @Override
    public void recordAdded(RecordStore aRecordStore, int aRecordId) {
        try {
            byte[] newRecord = this.getRecord(aRecordId);
            if (this.iRecordFilter != null && !this.iRecordFilter.matches(newRecord)) {
                return;
            }
            int[] temp = new int[this.iRecordIDs.length + 1];
            temp[0] = aRecordId;
            System.arraycopy(this.iRecordIDs, 0, temp, 1, this.iRecordIDs.length);
            this.iRecordIDs = temp;
            if (this.iRecordComparator != null) {
                int i2 = 0;
                for (int j = 1; j < this.iRecordIDs.length && this.iRecordComparator.compare(newRecord, this.getRecord(this.iRecordIDs[j])) == 1; ++j) {
                    this.iRecordIDs[i2] = this.iRecordIDs[j];
                    this.iRecordIDs[j] = aRecordId;
                    ++i2;
                }
                if (this.iCurrentPos != -1 && i2 <= this.iCurrentPos) {
                    ++this.iCurrentPos;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    @Override
    public void recordChanged(RecordStore aRecordStore, int aRecordId) {
        this.recordDeleted(aRecordStore, aRecordId);
        this.recordAdded(aRecordStore, aRecordId);
    }

    @Override
    public void recordDeleted(RecordStore aRecordStore, int aRecordId) {
        for (int i2 = 0; i2 < this.iRecordIDs.length; ++i2) {
            if (aRecordId != this.iRecordIDs[i2]) continue;
            int[] temp = new int[this.iRecordIDs.length - 1];
            System.arraycopy(this.iRecordIDs, 0, temp, 0, i2);
            System.arraycopy(this.iRecordIDs, i2 + 1, temp, i2, this.iRecordIDs.length - i2 - 1);
            if (this.iCurrentPos == temp.length || i2 <= this.iCurrentPos) {
                --this.iCurrentPos;
            }
            this.iRecordIDs = temp;
        }
    }

    private void ensureNotDestroyed() {
        if (this.recordStore == null) {
            throw new IllegalStateException("RecordEnumeration is not usable after destroy() has been called");
        }
    }

    private void doTagFilter() {
        try {
            Vector<Integer> filtered = new Vector<Integer>();
            for (int i2 = 0; i2 < this.iRecordIDs.length; ++i2) {
                byte[] record = this.getRecord(this.iRecordIDs[i2]);
                if (!this.filterMatches(record)) continue;
                filtered.addElement(new Integer(this.iRecordIDs[i2]));
            }
            this.iRecordIDs = this.vectorToIntArray(filtered);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private boolean filterMatches(byte[] aRecord) {
        return this.iRecordFilter == null || this.iRecordFilter.matches(aRecord);
    }

    private int[] vectorToIntArray(Vector aVector) {
        int[] array = new int[aVector.size()];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Integer id = (Integer)aVector.elementAt(i2);
            array[i2] = id;
        }
        return array;
    }

    private void doSort() {
        try {
            this.quickSort(this.iRecordIDs, 0, this.iRecordIDs.length - 1);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private byte[] getRecord(int aRecordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        return this.recordStore.getRecord(aRecordId);
    }

    private void quickSort(int[] aArray, int aLeft, int aRight) throws RecordStoreException {
        if (aLeft >= aRight) {
            return;
        }
        int index = this.partition(aArray, aLeft, aRight);
        if (aLeft < index - 1) {
            this.quickSort(aArray, aLeft, index - 1);
        }
        if (index < aRight) {
            this.quickSort(aArray, index, aRight);
        }
    }

    private int partition(int[] aArray, int aLeft, int aRight) throws RecordStoreException {
        int i2 = aLeft;
        int j = aRight;
        int pivotIndex = aLeft + aRight >>> 1;
        byte[] pivot = this.getRecord(this.iRecordIDs[pivotIndex]);
        while (i2 <= j) {
            while (this.iRecordComparator.compare(this.getRecord(aArray[i2]), pivot) == -1) {
                ++i2;
            }
            while (this.iRecordComparator.compare(this.getRecord(aArray[j]), pivot) == 1) {
                --j;
            }
            if (i2 > j) continue;
            int tmp = aArray[i2];
            aArray[i2] = aArray[j];
            aArray[j] = tmp;
            ++i2;
            --j;
        }
        return i2;
    }
}

