/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import emulator.Emulator;
import emulator.ui.IEmulatorFrontend;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordEnumerationImpl;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordStore {
    private static Vector openRecordStores = new Vector();
    static String rmsRootDir = Emulator.getEmulator().getProperty().getRmsFolderPath();
    static String homeRootPath;
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    private String name;
    Vector records;
    Vector recordListeners;
    int count;
    private boolean closed;
    private long lastModified;
    private int version;
    private String rootPath;
    private Object sync = new Object();
    private boolean homeSuite;
    private int authmode;
    private boolean writable;
    private int openCount = 1;

    RecordStore(String aName, String aRootPath, boolean aHomeSuite, boolean existing) throws RecordStoreException, RecordStoreNotFoundException, RecordStoreFullException {
        this.records = new Vector();
        this.recordListeners = new Vector(3);
        this.name = aName;
        this.rootPath = aRootPath;
        this.homeSuite = aHomeSuite;
        try {
            if (!existing) {
                this.count = 1;
                this.writeIndex();
                openRecordStores.addElement(this);
                return;
            }
            boolean convert = false;
            File file = new File(this.rootPath + "idx");
            String oldPath = Emulator.getEmulator().getProperty().getOldRmsPath() + "." + aName + "/" + aName;
            if (!file.exists()) {
                if (aHomeSuite) {
                    file = new File(oldPath + ".idx");
                    RecordStore.logln("Fallback to " + file.getAbsolutePath());
                    if (!file.exists()) {
                        throw new RecordStoreNotFoundException(this.name);
                    }
                    convert = true;
                } else {
                    throw new RecordStoreNotFoundException(this.name);
                }
            }
            if (file.length() == 0L) {
                this.count = 1;
                this.writeIndex();
                openRecordStores.addElement(this);
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            this.count = dataInputStream.readInt();
            int j22 = dataInputStream.readInt();
            for (int i2 = 0; i2 < j22; ++i2) {
                this.records.addElement(new Integer(dataInputStream.readInt()));
            }
            try {
                if (dataInputStream.available() > 0) {
                    this.lastModified = dataInputStream.readLong();
                    this.version = dataInputStream.readInt();
                    this.authmode = dataInputStream.readInt();
                    this.writable = dataInputStream.readBoolean();
                }
            }
            catch (IOException j22) {
                // empty catch block
            }
            dataInputStream.close();
            if (!this.homeSuite && this.authmode == 0) {
                throw new SecurityException();
            }
            if (convert) {
                RecordStore.logln("Converting: " + aName);
                this.writeIndex();
                file.delete();
                try {
                    for (int i3 = 0; i3 < this.records.size(); ++i3) {
                        String n = this.records.elementAt(i3).toString();
                        String s1 = oldPath + "_" + n + ".rms";
                        String s2 = this.rootPath + n + ".rms";
                        new File(s1).renameTo(new File(s2));
                    }
                }
                catch (Exception e2) {
                    RecordStore.logln("Conversion failed: " + e2.toString());
                }
            }
            openRecordStores.addElement(this);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            throw new RecordStoreNotFoundException(this.name);
        }
    }

    public void setMode(int aAuthmode, boolean aWritable) throws RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        if (!this.homeSuite) {
            throw new SecurityException("Only read operations allowed");
        }
        if (aAuthmode < 0 || aAuthmode > 1) {
            throw new IllegalArgumentException("Access mode is invalid");
        }
        this.authmode = aAuthmode;
        this.writable = aWritable;
        this.writeIndex();
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        return this.lastModified;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        return this.version;
    }

    public String getName() throws RecordStoreNotOpenException {
        return this.name;
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        return this.count;
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (!this.recordIdExists(recordId)) {
            throw new InvalidRecordIDException();
        }
        try {
            return (int)new File(this.rootPath + recordId + ".rms").length();
        }
        catch (Exception e2) {
            throw new RecordStoreException(e2.toString());
        }
    }

    public int getSize() throws RecordStoreNotOpenException {
        int n = 0;
        try {
            for (int i2 = 0; i2 < this.records.size(); ++i2) {
                n += this.getRecordSize((Integer)this.records.elementAt(i2));
            }
        }
        catch (RecordStoreNotOpenException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RecordStoreNotOpenException(e3.toString());
        }
        return n;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        int r;
        try {
            r = (int)Math.min(32000000L, new File(this.rootPath).getUsableSpace());
        }
        catch (Exception e2) {
            r = 32000000;
        }
        RecordStore.logln("getSizeAvailable: " + r);
        return r;
    }

    public RecordEnumeration enumerateRecords(RecordFilter recordFilter, RecordComparator recordComparator, boolean keepUpdated) {
        RecordStore.logln("enumerateRecords " + this.name + (!this.homeSuite ? " (guest)" : ""));
        return new RecordEnumerationImpl(this, this.sync, recordFilter, recordComparator, keepUpdated);
    }

    public static RecordStore openRecordStore(String name, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        return RecordStore.openRecordStore(name, createIfNecessary, 0, true);
    }

    public static RecordStore openRecordStore(String name, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        boolean exists;
        if (name.length() > 32 || name.length() < 1) {
            throw new IllegalArgumentException("Record store name is invalid");
        }
        RecordStore.logln("openRecordStore " + name);
        String rootPath = homeRootPath + RecordStore.encodeBase64(name) + "/";
        RecordStore rs = RecordStore.findRecordStore(rootPath);
        if (rs != null) {
            ++rs.openCount;
            rs.setMode(authmode, writable);
            return rs;
        }
        File file = new File(rootPath);
        boolean bl = exists = file.exists() && file.isDirectory() && (file = new File(rootPath + "idx")).exists();
        if (!exists) {
            String oldPath = Emulator.getEmulator().getProperty().getOldRmsPath() + "." + name + "/" + name + ".idx";
            file = new File(oldPath);
            exists = file.exists();
        }
        if (exists && !createIfNecessary && file.length() == 0L) {
            throw new RecordStoreNotFoundException(name);
        }
        if (exists || createIfNecessary) {
            rs = new RecordStore(name, rootPath, true, exists);
            rs.setMode(authmode, writable);
            return rs;
        }
        throw new RecordStoreNotFoundException(name);
    }

    public static RecordStore openRecordStore(String name, String vendorName, String suiteName) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        if (name.length() > 32 || name.length() < 1) {
            throw new IllegalArgumentException("Record store name is invalid");
        }
        RecordStore.logln("openRecordStore " + name + " " + vendorName + " " + suiteName);
        String rootPath = RecordStore.getRootPath(name, vendorName, suiteName) + RecordStore.encodeBase64(name) + "/";
        RecordStore rs = RecordStore.findRecordStore(rootPath);
        if (rs != null) {
            ++rs.openCount;
            return rs;
        }
        File file = new File(rootPath);
        if (!(file.exists() && file.isDirectory() && new File(rootPath + "idx").exists())) {
            throw new RecordStoreNotFoundException(name);
        }
        IEmulatorFrontend e2 = Emulator.getEmulator();
        return new RecordStore(name, rootPath, vendorName.equals(e2.getAppProperty("MIDlet-Vendor")) && suiteName.equals(e2.getAppProperty("MIDlet-Name")), true);
    }

    public static void deleteRecordStore(String name) throws RecordStoreException, RecordStoreNotFoundException {
        if (name.length() > 32 || name.length() < 1) {
            throw new IllegalArgumentException("Record store name is invalid");
        }
        RecordStore.logln("deleteRecordStore " + name);
        String rootPath = homeRootPath + RecordStore.encodeBase64(name) + "/";
        if (RecordStore.findRecordStore(rootPath) != null) {
            RecordStore.logln("tried to delete active store");
            throw new RecordStoreException("Cannot delete currently opened record store: " + name);
        }
        File file = new File(rootPath);
        if (!file.exists()) {
            RecordStore.logln("not exist " + rootPath);
            throw new RecordStoreNotFoundException(name);
        }
        try {
            for (File value : file.listFiles()) {
                value.delete();
            }
            file.delete();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RecordStoreException(e2.toString());
        }
    }

    public static String[] listRecordStores() {
        String[] list2 = null;
        try {
            if (homeRootPath == null) {
                return null;
            }
            File file = new File(homeRootPath);
            list2 = file.list();
            ArrayList<String> tmp = new ArrayList<String>();
            if (list2 != null) {
                for (String s : list2) {
                    if (!new File(file.getAbsolutePath() + "/" + s + "/idx").exists()) continue;
                    tmp.add(RecordStore.decodeBase64(s));
                }
            }
            list2 = tmp.toArray(new String[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return list2;
    }

    public void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        if (!this.homeSuite && !this.writable) {
            throw new SecurityException("Only read operations allowed");
        }
        RecordStore.logln("deleteRecord " + this.name + " " + recordId + (!this.homeSuite ? " (guest)" : ""));
        Object object = this.sync;
        synchronized (object) {
            int i2 = this.records.indexOf(new Integer(recordId));
            if (i2 != -1) {
                this.records.removeElementAt(i2);
                this.modify();
                try {
                    File file = new File(this.rootPath + recordId + ".rms");
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception e2) {
                    throw new RecordStoreException(e2.toString());
                }
                this.writeIndex();
                this.recordDeleted(recordId);
                return;
            }
            throw new InvalidRecordIDException();
        }
    }

    public int getRecord(int recordId, byte[] b2, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        RecordStore.logln("getRecord " + this.name + " " + recordId + (!this.homeSuite ? " (guest)" : ""));
        if (!this.recordIdExists(recordId)) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        try {
            File file = new File(this.rootPath + recordId + ".rms");
            int length = (int)file.length();
            if (length > b2.length - offset) {
                throw new ArrayIndexOutOfBoundsException(length);
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dataInputStream.readFully(b2, offset, length);
            dataInputStream.close();
            return length;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RecordStoreException("recordId=" + recordId, e3);
        }
    }

    public byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        RecordStore.logln("getRecord " + this.name + " " + recordId + (!this.homeSuite ? " (guest)" : ""));
        if (!this.recordIdExists(recordId)) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        try {
            File file = new File(this.rootPath + recordId + ".rms");
            long length = file.length();
            if (length > 0L) {
                byte[] b2 = new byte[(int)length];
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                dataInputStream.readFully(b2);
                dataInputStream.close();
                return b2;
            }
            return null;
        }
        catch (Exception e2) {
            throw new RecordStoreException("recordId=" + recordId);
        }
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        int r = this.records.size();
        RecordStore.logln("getNumRecords: " + r);
        return r;
    }

    private boolean recordIdExists(int recordId) {
        boolean b2 = false;
        for (int i2 = 0; i2 < this.records.size(); ++i2) {
            if ((Integer)this.records.elementAt(i2) != recordId) continue;
            b2 = true;
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] data, int offset, int length) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        if (!this.homeSuite && !this.writable) {
            throw new SecurityException("Only read operations allowed");
        }
        RecordStore.logln("addRecord " + this.name + " " + this.count + (!this.homeSuite ? " (guest)" : ""));
        Object object = this.sync;
        synchronized (object) {
            this.records.addElement(new Integer(this.count));
            this.modify();
            try {
                File file = new File(this.rootPath);
                if (!file.exists() && !file.isDirectory()) {
                    file.mkdir();
                }
                if (!(file = new File(this.rootPath + this.count + ".rms")).exists()) {
                    file.createNewFile();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    if (data != null) {
                        ((OutputStream)fileOutputStream).write(data, offset, length);
                    }
                }
                this.writeIndex();
            }
            catch (Exception e2) {
                throw new RecordStoreException(e2.toString());
            }
            this.recordAdded(this.count);
            return this.count++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecord(int recordId, byte[] data, int offset, int length) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        if (!this.homeSuite && !this.writable) {
            throw new SecurityException("Only read operations allowed");
        }
        if (recordId == this.count) {
            this.addRecord(data, offset, length);
            return;
        }
        RecordStore.logln("setRecord " + this.name + " " + recordId + (!this.homeSuite ? " (guest)" : ""));
        if (!this.recordIdExists(recordId)) {
            throw new InvalidRecordIDException("recordId=" + recordId);
        }
        Object object = this.sync;
        synchronized (object) {
            this.modify();
            try {
                File file = new File(this.rootPath);
                if (!file.exists() && !file.isDirectory()) {
                    file.mkdir();
                }
                if (!(file = new File(this.rootPath + recordId + ".rms")).exists()) {
                    file.createNewFile();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    if (data != null) {
                        fileOutputStream.write(data, offset, length);
                    }
                }
                this.writeIndex();
            }
            catch (Exception e2) {
                throw new RecordStoreException("recordId=" + recordId, e2);
            }
            this.recordChanged(recordId);
        }
    }

    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        RecordStore.logln("closeRecordStore " + this.name + (!this.homeSuite ? " (guest)" : ""));
        if (--this.openCount < 1) {
            this.closed = true;
            openRecordStores.removeElement(this);
            if (!this.recordListeners.isEmpty()) {
                this.recordListeners.removeAllElements();
            }
            if (this.homeSuite || this.writable) {
                this.writeIndex();
            }
        }
    }

    private void modify() {
        this.lastModified = System.currentTimeMillis();
        ++this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex() throws RecordStoreException {
        try {
            File file = new File(this.rootPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File(this.rootPath + "idx")).exists()) {
                file.createNewFile();
            }
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));){
                dataOutputStream.writeInt(this.count);
                dataOutputStream.writeInt(this.records.size());
                for (int i2 = 0; i2 < this.records.size(); ++i2) {
                    dataOutputStream.writeInt((Integer)this.records.elementAt(i2));
                }
                dataOutputStream.writeLong(this.lastModified);
                dataOutputStream.writeInt(this.version);
                dataOutputStream.writeInt(this.authmode);
                dataOutputStream.writeBoolean(this.writable);
            }
        }
        catch (Exception e2) {
            throw new RecordStoreException(this.name);
        }
    }

    public void addRecordListener(RecordListener listener) {
        if (!this.recordListeners.contains(listener)) {
            this.recordListeners.addElement(listener);
        }
    }

    public void removeRecordListener(RecordListener listener) {
        this.recordListeners.removeElement(listener);
    }

    private void recordChanged(int n) {
        for (int i2 = 0; i2 < this.recordListeners.size(); ++i2) {
            ((RecordListener)this.recordListeners.elementAt(i2)).recordChanged(this, n);
        }
    }

    private void recordAdded(int n) {
        for (int i2 = 0; i2 < this.recordListeners.size(); ++i2) {
            ((RecordListener)this.recordListeners.elementAt(i2)).recordAdded(this, n);
        }
    }

    private void recordDeleted(int n) {
        for (int i2 = 0; i2 < this.recordListeners.size(); ++i2) {
            ((RecordListener)this.recordListeners.elementAt(i2)).recordDeleted(this, n);
        }
    }

    private static String getRootPath(String name, String vendorName, String suiteName) throws RecordStoreNotFoundException {
        String s = rmsRootDir + RecordStore.encodeBase64(vendorName + "_" + suiteName) + "/";
        File file = new File(s);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdir();
        }
        return s;
    }

    private static String encodeBase64(String name) {
        try {
            return new String(Base64.getEncoder().encode(name.getBytes("UTF-8")), "UTF-8").replace('/', '-');
        }
        catch (Exception e2) {
            return name;
        }
    }

    private static String decodeBase64(String name) {
        try {
            return new String(Base64.getDecoder().decode(name.replace('-', '/').getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception e2) {
            return name;
        }
    }

    private static RecordStore findRecordStore(String rootPath) {
        int num = openRecordStores.size();
        for (int i2 = 0; i2 < num; ++i2) {
            RecordStore rs = (RecordStore)openRecordStores.elementAt(i2);
            if (!rs.rootPath.equals(rootPath)) continue;
            return rs;
        }
        return null;
    }

    int[] getRecordIds() throws RecordStoreException {
        if (this.closed) {
            throw new RecordStoreNotOpenException();
        }
        int[] recordIds = new int[this.records.size()];
        for (int i2 = 0; i2 < recordIds.length; ++i2) {
            recordIds[i2] = (Integer)this.records.elementAt(i2);
        }
        return recordIds;
    }

    private static void logln(String s) {
        Emulator.getEmulator().getLogStream().println("[RMS] " + s);
    }

    private static void log(String s) {
        Emulator.getEmulator().getLogStream().print("[RMS] " + s);
    }

    private static void logendln(String s) {
        Emulator.getEmulator().getLogStream().println(s);
    }

    static {
        try {
            IEmulatorFrontend em = Emulator.getEmulator();
            if (em.getAppProperties() != null) {
                homeRootPath = RecordStore.getRootPath(null, em.getAppProperty("MIDlet-Vendor"), em.getAppProperty("MIDlet-Name"));
                RecordStore.logln("midlet rms path: " + homeRootPath);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

