/*
 * Decompiled with CFR 0.152.
 */
package javax.wireless.messaging;

import emulator.Emulator;
import emulator.Permission;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.BinaryMessageImpl;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessageImpl;

public class MessageConnectionImpl
implements MessageConnection {
    private final String aString314;
    private MessageListener aMessageListener1365;
    private boolean aBoolean313;

    public MessageConnectionImpl(String aString314) {
        this.aString314 = aString314;
        this.aMessageListener1365 = null;
        this.aBoolean313 = false;
    }

    @Override
    public Message newMessage(String s) {
        return this.newMessage(s, this.aString314);
    }

    @Override
    public Message newMessage(String s, String s2) {
        if (s.equals("text")) {
            return new TextMessageImpl(s2, null);
        }
        if (s.equals("binary")) {
            return new BinaryMessageImpl(s2, null);
        }
        return null;
    }

    @Override
    public void send(Message message) throws IOException, InterruptedIOException {
        Permission.checkPermission("messageconnection.send");
        Emulator.getEmulator().getMessage().send(message, this.aString314);
    }

    @Override
    public Message receive() throws IOException, InterruptedIOException {
        Permission.checkPermission("messageconnection.receive");
        Message receive = null;
        while (receive == null && !this.aBoolean313) {
            try {
                receive = Emulator.getEmulator().getMessage().receive(this.aString314);
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (receive != null) {
            this.aMessageListener1365.notifyIncomingMessage(this);
        }
        return receive;
    }

    @Override
    public void setMessageListener(MessageListener aMessageListener1365) throws IOException {
        this.aMessageListener1365 = aMessageListener1365;
    }

    @Override
    public int numberOfSegments(Message message) {
        if (message instanceof TextMessageImpl) {
            return ((TextMessageImpl)message).data.length() / 160 + 1;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.aBoolean313 = true;
    }
}

