/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;

public class Player {
    private int frame = 0;
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audio;
    private boolean closed = false;
    private boolean complete = false;
    private int lastPosition = 0;
    private boolean paused;
    private int bitrate;
    private byte[] data;
    private int dataIndex;
    public boolean isBuffered;
    private InputStream dataStream;
    private int positionOffset;
    private int vol;
    private boolean reset;

    public Player(InputStream stream, boolean buffer) throws JavaLayerException, IOException {
        this(stream, null, buffer);
    }

    public Player(InputStream stream, AudioDevice device, boolean buffer) throws JavaLayerException, IOException {
        if (stream instanceof ByteArrayInputStream) {
            buffer = true;
        }
        if (buffer) {
            int r;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(stream.available());
            byte[] b2 = new byte[2048];
            while ((r = stream.read(b2)) != -1) {
                baos.write(b2, 0, r);
            }
            this.data = baos.toByteArray();
            stream.close();
            stream = this.dataStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    if (Player.this.dataIndex == Player.this.data.length) {
                        return -1;
                    }
                    return Player.this.data[Player.this.dataIndex++];
                }

                @Override
                public int read(byte[] b2, int i2, int len) throws IOException {
                    if (len > Player.this.data.length - Player.this.dataIndex) {
                        len = Player.this.data.length - Player.this.dataIndex;
                    }
                    if (len == 0) {
                        return -1;
                    }
                    System.arraycopy(Player.this.data, Player.this.dataIndex, b2, i2, len);
                    Player.this.dataIndex = Player.this.dataIndex + len;
                    return len;
                }
            };
        }
        this.isBuffered = buffer;
        this.vol = 100;
        this.lastPosition = 0;
        this.bitstream = new Bitstream(stream);
        this.decoder = new Decoder();
        if (device != null) {
            this.audio = device;
        } else {
            FactoryRegistry r = FactoryRegistry.systemRegistry();
            this.audio = r.createAudioDevice();
        }
        this.audio.open(this.decoder);
    }

    public void play() throws JavaLayerException, InterruptedException {
        this.play(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(int frames) throws JavaLayerException, InterruptedException {
        AudioDevice out;
        this.paused = false;
        boolean ret = true;
        while (frames-- > 0 && ret) {
            if (this.paused) {
                return false;
            }
            if (this.closed) {
                ret = false;
                break;
            }
            if (this.reset) {
                System.out.println("play locked");
                InputStream inputStream = this.dataStream;
                synchronized (inputStream) {
                    this.dataStream.wait();
                }
                System.out.println("play unlocked");
            }
            try {
                ret = this.decodeFrame();
            }
            catch (JavaLayerException e2) {
                if (this.reset) continue;
                throw e2;
            }
        }
        if (!ret && (out = this.audio) != null) {
            out.flush();
            Player player = this;
            synchronized (player) {
                this.complete = !this.closed;
                this.reset();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (!this.isBuffered) {
            return;
        }
        this.positionOffset = 0;
        this.dataIndex = 0;
        this.reset = true;
        try {
            if (this.bitstream != null) {
                this.bitstream.close();
                this.bitstream = null;
            }
            this.bitstream = new Bitstream(this.dataStream);
            this.decoder = new Decoder();
            if (this.audio != null) {
                this.audio.close();
                this.audio = null;
            }
            FactoryRegistry r = FactoryRegistry.systemRegistry();
            this.audio = r.createAudioDevice();
            this.audio.open(this.decoder);
            this.closed = false;
            this.paused = false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.reset = false;
        InputStream inputStream = this.dataStream;
        synchronized (inputStream) {
            this.dataStream.notifyAll();
        }
    }

    public int getBitrate() {
        if (this.bitrate == 0) {
            try {
                this.bitrate = this.bitstream.header.bitrate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bitrate;
    }

    public synchronized void close() {
        this.closed = true;
        AudioDevice a2 = this.audio;
        if (a2 != null) {
            this.audio = null;
            a2.close();
            this.lastPosition = a2.getPosition();
            try {
                this.bitstream.close();
                this.data = null;
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    public int getPosition() {
        int position = this.lastPosition;
        AudioDevice out = this.audio;
        if (out != null) {
            position = out.getPosition();
        }
        return position + this.positionOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean decodeFrame() throws JavaLayerException {
        try {
            AudioDevice out = this.audio;
            if (out == null) {
                return false;
            }
            Header h2 = this.bitstream.readFrame();
            if (h2 == null) {
                return false;
            }
            this.bitrate = h2.bitrate();
            SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h2, this.bitstream);
            Player player = this;
            synchronized (player) {
                out = this.audio;
                if (out != null) {
                    out.setVolume(this.vol);
                    out.write(output.getBuffer(), 0, output.getBufferLength());
                }
            }
            this.bitstream.closeFrame();
        }
        catch (RuntimeException ex) {
            throw new JavaLayerException("Exception decoding audio frame", ex);
        }
        return true;
    }

    protected boolean skipFrame() throws JavaLayerException {
        Header h2 = this.bitstream.readFrame();
        if (h2 == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    public float framesPerSecond() {
        return Player.framesPerSecond(this.bitstream.header);
    }

    public static float framesPerSecond(Header h2) {
        if (h2.frequency() == 0) {
            return 0.0f;
        }
        float o = 1.0f;
        switch (h2.frequency()) {
            case 44100: {
                o = 38.333332f;
                break;
            }
            case 32000: {
                o = 27.6f;
                break;
            }
            case 48000: {
                o = 42.0f;
                break;
            }
            default: {
                int i2 = h2.frequency();
                o = 38.5f;
                o /= 44100.0f;
                o *= (float)i2;
            }
        }
        return o;
    }

    public boolean skip(int skip, Header h2) throws JavaLayerException {
        if (h2 == null) {
            h2 = this.bitstream.header;
        }
        this.bitrate = h2.bitrate();
        this.positionOffset = skip;
        float o = Player.framesPerSecond(h2);
        int offset = (int)((double)skip / 1000.0 * (double)o);
        boolean ret = true;
        int initial = offset;
        while (offset-- > 0 && ret) {
            ret = this.skipFrame();
            try {
                double i2 = initial;
                double d = (i2 - (double)offset) / i2;
                int n = (int)(d * (double)skip);
            }
            catch (ArithmeticException arithmeticException) {}
        }
        return ret;
    }

    public boolean playSkip(int to, Player old) throws JavaLayerException, InterruptedException {
        this.positionOffset = to;
        float o = 1.0f;
        switch (old.bitstream.header.frequency()) {
            case 44100: {
                o = 38.333332f;
                break;
            }
            case 32000: {
                o = 27.6f;
                break;
            }
            case 48000: {
                o = 42.0f;
                break;
            }
            default: {
                int i2 = old.bitstream.header.frequency();
                o = 38.5f;
                o /= 44100.0f;
                o *= (float)i2;
            }
        }
        int offset = (int)((double)to / 1000.0 * (double)o);
        boolean ret = true;
        int initial = offset;
        while (offset-- > 0 && ret) {
            ret = this.skipFrame();
        }
        return ret && this.play(Integer.MAX_VALUE);
    }

    public int getFrame() {
        return this.frame;
    }

    public void setLevel(int n) {
        this.vol = n;
        if (this.audio != null) {
            this.audio.setVolume(n);
        }
    }

    public void stop() {
        this.paused = true;
    }

    public Bitstream bitstream() {
        return this.bitstream;
    }
}

