/*
 * Decompiled with CFR 0.152.
 */
package mmpp.media;

import emulator.custom.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MediaPlayer {
    private Player player;
    private boolean loop;
    private String currentVolume = String.valueOf(5);
    private static final int MAX_VOLUME = 5;

    public void setMediaLocation(String location) {
        try {
            InputStream is = ResourceManager.getResourceAsStream(null, location);
            this.player = Manager.createPlayer(is, "audio/midi");
            this.player.realize();
            is.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (MediaException e3) {
            e3.printStackTrace();
        }
    }

    public void setMediaSource(byte[] buffer, int offset, int length) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buffer, offset, length);
            this.player = Manager.createPlayer(bis, "audio/midi");
            this.player.realize();
            bis.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (MediaException e3) {
            e3.printStackTrace();
        }
    }

    public void setVolumeLevel(String level) {
        int setLevel = Integer.valueOf(level) * 100 / 5;
        VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
        volumeControl.setLevel(setLevel);
        this.currentVolume = level;
    }

    public String getVolumeLevel() {
        return this.currentVolume;
    }

    public void start() {
        try {
            this.player.start();
        }
        catch (MediaException e2) {
            e2.printStackTrace();
        }
    }

    public void pause() {
        try {
            this.player.stop();
        }
        catch (MediaException e2) {
            e2.printStackTrace();
        }
    }

    public void resume() {
        try {
            this.player.start();
        }
        catch (MediaException e2) {
            e2.printStackTrace();
        }
    }

    public void stop() {
        this.player.close();
    }

    public void setPlayBackLoop(boolean val) {
        this.loop = val;
        int loopCount = val ? -1 : 1;
        this.player.setLoopCount(loopCount);
    }

    public boolean getPlayBackLoop() {
        return this.loop;
    }
}

