/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.UnrecognizedExtraField;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static Hashtable implementations = new Hashtable();
    static Class class$org$apache$tools$zip$AsiExtraField;
    static Class class$org$apache$tools$zip$JarMarker;

    public static void register(Class clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.newInstance();
            implementations.put(zipExtraField.getHeaderId(), clazz);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) throws InstantiationException, IllegalAccessException {
        Class clazz = (Class)implementations.get(zipShort);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        Object[] objectArray;
        int n;
        int n2;
        Vector<ZipExtraField> vector2 = new Vector<ZipExtraField>();
        for (n = 0; n <= byArray.length - 4; n += n2 + 4) {
            objectArray = new ZipShort(byArray, n);
            n2 = new ZipShort(byArray, n + 2).getValue();
            if (n + 4 + n2 > byArray.length) {
                throw new ZipException("data starting at " + n + " is in unknown format");
            }
            try {
                ZipExtraField zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)objectArray);
                zipExtraField.parseFromLocalFileData(byArray, n + 4, n2);
                vector2.addElement(zipExtraField);
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new ZipException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ZipException(illegalAccessException.getMessage());
            }
        }
        if (n != byArray.length) {
            throw new ZipException("data starting at " + n + " is in unknown format");
        }
        objectArray = new ZipExtraField[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        for (int j = 0; j < zipExtraFieldArray.length; ++j) {
            n += zipExtraFieldArray[j].getLocalFileDataLength().getValue();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int j = 0; j < zipExtraFieldArray.length; ++j) {
            System.arraycopy(zipExtraFieldArray[j].getHeaderId().getBytes(), 0, byArray, n2, 2);
            System.arraycopy(zipExtraFieldArray[j].getLocalFileDataLength().getBytes(), 0, byArray, n2 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[j].getLocalFileDataData();
            System.arraycopy(byArray2, 0, byArray, n2 + 4, byArray2.length);
            n2 += byArray2.length + 4;
        }
        return byArray;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        for (int j = 0; j < zipExtraFieldArray.length; ++j) {
            n += zipExtraFieldArray[j].getCentralDirectoryLength().getValue();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int j = 0; j < zipExtraFieldArray.length; ++j) {
            System.arraycopy(zipExtraFieldArray[j].getHeaderId().getBytes(), 0, byArray, n2, 2);
            System.arraycopy(zipExtraFieldArray[j].getCentralDirectoryLength().getBytes(), 0, byArray, n2 + 2, 2);
            byte[] byArray2 = zipExtraFieldArray[j].getCentralDirectoryData();
            System.arraycopy(byArray2, 0, byArray, n2 + 4, byArray2.length);
            n2 += byArray2.length + 4;
        }
        return byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ExtraFieldUtils.register(class$org$apache$tools$zip$AsiExtraField == null ? (class$org$apache$tools$zip$AsiExtraField = ExtraFieldUtils.class$("org.apache.tools.zip.AsiExtraField")) : class$org$apache$tools$zip$AsiExtraField);
        ExtraFieldUtils.register(class$org$apache$tools$zip$JarMarker == null ? (class$org$apache$tools$zip$JarMarker = ExtraFieldUtils.class$("org.apache.tools.zip.JarMarker")) : class$org$apache$tools$zip$JarMarker);
    }
}

