/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.jar.Manifest;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;
import org.apache.tools.zip.a;
import org.apache.tools.zip.b;

public class ZipFile {
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] DD_SIG = ZipLong.getBytes(134695760L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    private static final int HASH_SIZE = 509;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private Hashtable entries = new Hashtable(509);
    private Hashtable nameMap = new Hashtable(509);
    private String encoding = null;
    private RandomAccessFile archive;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private ZipEntry manEntry;
    static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public ZipFile(File file) throws IOException {
        this(file, null);
    }

    public ZipFile(String string) throws IOException {
        this(new File(string), null);
    }

    public ZipFile(String string, String string2) throws IOException {
        this(new File(string), string2);
    }

    public ZipFile(File file, String string) throws IOException {
        this.encoding = string;
        this.archive = new RandomAccessFile(file, "r");
        try {
            this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData();
            return;
        }
        catch (IOException iOException) {
            try {
                this.archive.close();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public Enumeration getEntries() {
        return this.entries.keys();
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.nameMap.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
        b b2 = (b)this.entries.get(zipEntry);
        if (b2 == null) {
            return null;
        }
        long l = b.a(b2);
        a a2 = new a(this, l, zipEntry.getCompressedSize());
        switch (zipEntry.getMethod()) {
            case 0: {
                return a2;
            }
            case 8: {
                a2.a();
                return new InflaterInputStream(a2, new Inflater(true));
            }
        }
        throw new ZipException("Found unsupported compression method " + zipEntry.getMethod());
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] byArray = new byte[42];
        byte[] byArray2 = new byte[4];
        this.archive.readFully(byArray2);
        long l = ZipLong.getValue(byArray2);
        long l2 = ZipLong.getValue(CFH_SIG);
        while (l == l2) {
            this.archive.readFully(byArray);
            ZipEntry zipEntry = new ZipEntry();
            int n = ZipShort.getValue(byArray, 0);
            zipEntry.setPlatform(n >> 8 & 0xF);
            zipEntry.setMethod(ZipShort.getValue(byArray, 6));
            long l3 = ZipFile.dosToJavaTime(ZipLong.getValue(byArray, 8));
            zipEntry.setTime(l3);
            zipEntry.setCrc(ZipLong.getValue(byArray, 12));
            zipEntry.setCompressedSize(ZipLong.getValue(byArray, 16));
            zipEntry.setSize(ZipLong.getValue(byArray, 20));
            int n2 = ZipShort.getValue(byArray, 24);
            int n3 = ZipShort.getValue(byArray, 26);
            int n4 = ZipShort.getValue(byArray, 28);
            zipEntry.setInternalAttributes(ZipShort.getValue(byArray, 32));
            zipEntry.setExternalAttributes(ZipLong.getValue(byArray, 34));
            byte[] byArray3 = new byte[n2];
            this.archive.readFully(byArray3);
            zipEntry.setName(this.getString(byArray3));
            b b2 = new b(null);
            b.a(b2, ZipLong.getValue(byArray, 38));
            this.entries.put(zipEntry, b2);
            this.nameMap.put(zipEntry.getName(), zipEntry);
            this.archive.skipBytes(n3);
            byte[] byArray4 = new byte[n4];
            this.archive.readFully(byArray4);
            zipEntry.setComment(this.getString(byArray4));
            this.archive.readFully(byArray2);
            l = ZipLong.getValue(byArray2);
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        byte[] byArray;
        boolean bl = false;
        long l = this.archive.length() - 22L;
        if (l >= 0L) {
            int n;
            this.archive.seek(l);
            byArray = EOCD_SIG;
            while ((n = this.archive.read()) != -1) {
                if (n == byArray[0] && (n = this.archive.read()) == byArray[1] && (n = this.archive.read()) == byArray[2] && (n = this.archive.read()) == byArray[3]) {
                    bl = true;
                    break;
                }
                this.archive.seek(--l);
            }
        }
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(l + 16L);
        byArray = new byte[4];
        this.archive.readFully(byArray);
        this.archive.seek(ZipLong.getValue(byArray));
    }

    private void resolveLocalFileHeaderData() throws IOException {
        Enumeration enumeration = this.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            b b2 = (b)this.entries.get(zipEntry);
            long l = b.b(b2);
            this.archive.seek(l + 26L);
            byte[] byArray = new byte[2];
            this.archive.readFully(byArray);
            int n = ZipShort.getValue(byArray);
            this.archive.readFully(byArray);
            int n2 = ZipShort.getValue(byArray);
            this.archive.skipBytes(n);
            byte[] byArray2 = new byte[n2];
            this.archive.readFully(byArray2);
            zipEntry.setExtra(byArray2);
            b.b(b2, l + 26L + 2L + 2L + (long)n + (long)n2);
        }
    }

    protected static Date fromDosTime(ZipLong zipLong) {
        long l = zipLong.getValue();
        return new Date(ZipFile.dosToJavaTime(l));
    }

    private static long dosToJavaTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        return calendar.getTime().getTime();
    }

    protected String getString(byte[] byArray) throws ZipException {
        if (this.encoding == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException.getMessage());
        }
    }

    public Manifest getManifest() throws IOException {
        ZipEntry zipEntry = this.getManEntry();
        return new Manifest(this.getInputStream(zipEntry));
    }

    private ZipEntry getManEntry() {
        if (this.manEntry == null) {
            this.manEntry = this.getEntry(MANIFEST_NAME);
            if (this.manEntry == null) {
                Enumeration enumeration = this.entries.keys();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    if (!MANIFEST_NAME.equals(zipEntry.getName().toUpperCase(Locale.ENGLISH))) continue;
                    this.manEntry = this.getEntry(zipEntry.getName());
                    break;
                }
            }
        }
        return this.manEntry;
    }

    static RandomAccessFile access$300(ZipFile zipFile) {
        return zipFile.archive;
    }
}

