/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import org.bridj.Pointer;
import org.bridj.PointerIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PointerLRUCache {
    private final Pointer<?>[] values;
    private int index;
    private final int tolerance;

    PointerLRUCache(int length, int tolerance) {
        assert (tolerance >= 0);
        this.tolerance = tolerance;
        this.values = new Pointer[length];
    }

    protected abstract <T> Pointer<T> pointerToAddress(long var1, PointerIO<T> var3);

    Pointer<?> get(long peer, PointerIO<?> pointerIO) {
        int idx = this.index;
        int length = this.values.length;
        for (int i2 = 0; i2 < length; ++i2) {
            Pointer<?> ptr = this.values[idx];
            if (ptr == null) {
                ptr = this.pointerToAddress(peer, pointerIO);
                this.values[idx] = ptr;
                return ptr;
            }
            if (ptr.getPeer() == peer && ptr.getIO() == pointerIO) {
                int idx2;
                if (i2 > this.tolerance && idx != (idx2 = this.decrementedIndex())) {
                    Pointer<?> temp = this.values[idx];
                    this.values[idx] = this.values[idx2];
                    this.values[idx2] = temp;
                }
                return ptr;
            }
            if (++idx != length) continue;
            idx = 0;
        }
        Pointer<?> ptr = this.pointerToAddress(peer, pointerIO);
        this.values[this.decrementedIndex()] = ptr;
        return ptr;
    }

    private int decrementedIndex() {
        int i2 = this.index;
        if (--i2 < 0) {
            i2 = this.values.length - 1;
        }
        this.index = i2;
        return i2;
    }
}

