/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp.std;

import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.ann.Array;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Struct;
import org.bridj.ann.Template;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPRuntime;
import org.bridj.cpp.std.STL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Template(value={Type.class})
@Struct(customizer=STL.class)
public class list<T>
extends CPPObject {
    protected volatile Type _T;

    @Library(value="c")
    @Ptr
    protected static native long malloc(@Ptr long var0);

    @Library(value="c")
    protected static native void free(@Ptr long var0);

    protected Type T() {
        if (this._T == null) {
            CPPRuntime.getInstance();
            this._T = (Type)CPPRuntime.getTemplateParameters(this, list.class)[0];
        }
        return this._T;
    }

    protected list_node<T> createNode() {
        Type T = this.T();
        long size = BridJ.sizeOf(T);
        return new list_node(Pointer.pointerToAddress(list.malloc(size)), T);
    }

    protected void deleteNode(list_node<T> node) {
        list.free(Pointer.getAddress(node, list_node.class));
    }

    private Pointer<list_node<T>> node() {
        return Pointer.getPointer(this).as(list_node.class);
    }

    @Deprecated
    @Field(value=0)
    public Pointer<list_node<T>> next() {
        return this.io.getPointerField(this, 0);
    }

    @Deprecated
    @Field(value=0)
    public void next(Pointer<list_node<T>> value) {
        this.io.setPointerField(this, 0, value);
    }

    @Deprecated
    @Field(value=1)
    public Pointer<list_node<T>> prev() {
        return this.io.getPointerField(this, 1);
    }

    @Deprecated
    @Field(value=1)
    public void prev(Pointer<list_node<T>> value) {
        this.io.setPointerField(this, 1, value);
    }

    public list(Type t) {
        super((Void)null, -2, t);
    }

    public list(Pointer<? extends list<T>> peer, Type t) {
        super((Pointer<? extends CPPObject>)peer, new Object[]{t});
    }

    private void checkNotEmpty() {
        if (this.isRoot(this.next()) && this.isRoot(this.prev())) {
            throw new NoSuchElementException();
        }
    }

    public boolean empty() {
        return Pointer.getPeer(this.next()) == Pointer.getPeer(this.node());
    }

    public T back() {
        this.checkNotEmpty();
        return this.next().get().get();
    }

    public T front() {
        this.checkNotEmpty();
        Pointer<list_node<T>> prev = this.prev();
        Pointer<list_node<T>> next = this.next();
        Pointer<list_node<list_node<T>>> nextPrev = next == null ? null : next.get().prev();
        Pointer<list_node<list_node<T>>> prevNext = prev == null ? null : prev.get().next();
        int[] nextValues = next == null ? null : next.getInts(20);
        int[] prevValues = prev == null ? null : prev.getInts(20);
        list_node<T> n = prev.get();
        int[] values = Pointer.pointerTo(n).getInts(20);
        return n.get();
    }

    private boolean same(Pointer a2, Pointer b2) {
        return Pointer.getPeer(a2) == Pointer.getPeer(b2);
    }

    private boolean isRoot(Pointer a2) {
        return this.same(a2, Pointer.getPointer(this));
    }

    protected void hook(Pointer<list_node<T>> prev, Pointer<list_node<T>> next, T value) {
        list_node<T> tmp = this.createNode();
        Pointer<list_node<T>> pTmp = Pointer.getPointer(tmp);
        tmp.set(value);
        tmp.next(next);
        tmp.prev(prev);
        if (!this.isRoot(next)) {
            next.get().prev(pTmp);
        }
        if (!this.isRoot(prev)) {
            prev.get().next(pTmp);
        }
    }

    public void push_back(T value) {
        this.hook(this.prev(), null, value);
    }

    public void push_front(T value) {
        this.hook(null, this.next(), value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Template(value={Type.class})
    public static class list_node<T>
    extends CPPObject {
        @Deprecated
        @Field(value=0)
        public Pointer<list_node<T>> next() {
            return this.io.getPointerField(this, 0);
        }

        @Deprecated
        @Field(value=0)
        public void next(Pointer<list_node<T>> value) {
            this.io.setPointerField(this, 0, value);
        }

        @Deprecated
        @Field(value=1)
        public Pointer<list_node<T>> prev() {
            return this.io.getPointerField(this, 1);
        }

        @Field(value=1)
        public void prev(Pointer<list_node<T>> value) {
            this.io.setPointerField(this, 1, value);
        }

        @Deprecated
        @Field(value=2)
        @Array(value={1L})
        public Pointer<T> data() {
            return this.io.getPointerField(this, 2);
        }

        public list_node(Type t) {
            super((Void)null, -2, t);
        }

        public list_node(Pointer<? extends list_node> peer, Type t) {
            super((Pointer<? extends CPPObject>)peer, new Object[]{t});
            if (!this.isValid()) {
                throw new RuntimeException("Invalid list internal data ! Are you trying to use an unsupported version of the STL ?");
            }
        }

        protected boolean isValid() {
            long next = Pointer.getPeer(this.next());
            long prev = Pointer.getPeer(this.prev());
            return next != 0L || prev != 0L;
        }

        public T get() {
            return this.data().get();
        }

        public void set(T value) {
            this.data().set(value);
        }
    }
}

