/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.bridj.ann.Forwardable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    public static <A extends Annotation> A getInheritableAnnotation(Class<A> ac, AnnotatedElement m2, Annotation ... directAnnotations) {
        return AnnotationUtils.getAnnotation(ac, true, m2, directAnnotations);
    }

    public static <A extends Annotation> A getAnnotation(Class<A> ac, AnnotatedElement m2, Annotation ... directAnnotations) {
        return AnnotationUtils.getAnnotation(ac, false, m2, directAnnotations);
    }

    private static boolean isForwardable(Class<? extends Annotation> ac) {
        return ac.isAnnotationPresent(Forwardable.class);
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> ac, Annotation ... annotations) {
        return AnnotationUtils.isAnnotationPresent(ac, AnnotationUtils.isForwardable(ac), annotations);
    }

    private static boolean isAnnotationPresent(Class<? extends Annotation> ac, boolean isForwardable, Annotation ... annotations) {
        for (Annotation ann : annotations) {
            if (ac.isInstance(ann)) {
                return true;
            }
            if (!isForwardable || !ann.annotationType().isAnnotationPresent(ac)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class<? extends Annotation> ac, AnnotatedElement m2, Annotation ... directAnnotations) {
        boolean isForwardable = AnnotationUtils.isForwardable(ac);
        if (m2 != null && (isForwardable ? AnnotationUtils.isAnnotationPresent(ac, true, m2.getAnnotations()) : m2.isAnnotationPresent(ac))) {
            return true;
        }
        if (directAnnotations != null) {
            return AnnotationUtils.isAnnotationPresent(ac, isForwardable, directAnnotations);
        }
        return false;
    }

    private static <A extends Annotation> A getAnnotation(Class<A> ac, boolean inherit, AnnotatedElement m2, Annotation ... directAnnotations) {
        if (directAnnotations != null) {
            for (Annotation ann : directAnnotations) {
                if (!ac.isInstance(ann)) continue;
                return (A)((Annotation)ac.cast(ann));
            }
        }
        if (m2 == null) {
            return null;
        }
        A a2 = m2.getAnnotation(ac);
        if (a2 != null) {
            return a2;
        }
        if (inherit) {
            if (m2 instanceof Member) {
                return AnnotationUtils.getAnnotation(ac, inherit, ((Member)((Object)m2)).getDeclaringClass(), new Annotation[0]);
            }
            if (m2 instanceof Class) {
                Class c2 = (Class)m2;
                Class<?> dc = c2.getDeclaringClass();
                for (Class p = c2.getSuperclass(); p != null; p = p.getSuperclass()) {
                    a2 = AnnotationUtils.getAnnotation(ac, true, p, new Annotation[0]);
                    if (a2 == null) continue;
                    return a2;
                }
                if (dc != null) {
                    return AnnotationUtils.getAnnotation(ac, inherit, dc, new Annotation[0]);
                }
            }
        }
        return null;
    }
}

