/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.system.Platform;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.swt.PlatformVKCanvas;
import org.lwjgl.vulkan.swt.VKData;

public class VKCanvas
extends Canvas {
    private static PlatformVKCanvas platformCanvas;
    public long surface;

    public VKCanvas(Composite parent, int style, VKData data) {
        super(parent, platformCanvas.checkStyle(parent, style));
        if (Platform.get() == Platform.WINDOWS) {
            platformCanvas.resetStyle(parent);
        }
        if (data == null) {
            SWT.error((int)4);
        }
        this.surface = platformCanvas.create((Composite)this, data);
    }

    public boolean getPhysicalDevicePresentationSupport(VkPhysicalDevice physicalDevice, int queueFamily) {
        return platformCanvas.getPhysicalDevicePresentationSupport(physicalDevice, queueFamily);
    }

    static {
        String platformClassName;
        switch (Platform.get()) {
            case WINDOWS: {
                platformClassName = "org.lwjgl.vulkan.swt.PlatformWin32VKCanvas";
                break;
            }
            default: {
                throw new AssertionError((Object)"NYI");
            }
        }
        try {
            Class<?> clazz = VKCanvas.class.getClassLoader().loadClass(platformClassName);
            platformCanvas = (PlatformVKCanvas)clazz.newInstance();
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionError((Object)("Platform-specific VKCanvas class not found: " + platformClassName));
        }
        catch (InstantiationException e3) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + platformClassName));
        }
        catch (IllegalAccessException e4) {
            throw new AssertionError((Object)("Could not instantiate platform-specific VKCanvas class: " + platformClassName));
        }
    }
}

