/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class TraceMethodVisitor
extends TraceAbstractVisitor {
    protected MethodVisitor mv;
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final HashMap labelNames = new HashMap();

    public TraceMethodVisitor() {
        this(null);
    }

    public TraceMethodVisitor(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        this.buf.append(" : unknown\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitAttribute(attribute);
        }
    }

    @Override
    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.buf.append("FRAME ");
        switch (type) {
            case -1: 
            case 0: {
                this.buf.append("FULL [");
                this.appendFrameTypes(nLocal, local);
                this.buf.append("] [");
                this.appendFrameTypes(nStack, stack);
                this.buf.append("]");
                break;
            }
            case 1: {
                this.buf.append("APPEND [");
                this.appendFrameTypes(nLocal, local);
                this.buf.append("]");
                break;
            }
            case 2: {
                this.buf.append("CHOP ").append(nLocal);
                break;
            }
            case 3: {
                this.buf.append("SAME");
                break;
            }
            case 4: {
                this.buf.append("SAME1 ");
                this.appendFrameTypes(1, stack);
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInsn(opcode);
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ').append(opcode == 188 ? AbstractVisitor.TYPES[operand] : Integer.toString(operand)).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ').append(var).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        int n;
        TraceMethodVisitor traceMethodVisitor;
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ');
        if (type.startsWith("[")) {
            traceMethodVisitor = this;
            n = 1;
        } else {
            traceMethodVisitor = this;
            n = 0;
        }
        traceMethodVisitor.appendDescriptor(n, type);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTypeInsn(opcode, type);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.buf.append('.').append(name).append(" : ");
        this.appendDescriptor(1, descriptor);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFieldInsn(opcode, owner, name, descriptor);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ');
        this.appendDescriptor(0, owner);
        this.buf.append('.').append(name).append(' ');
        this.appendDescriptor(3, descriptor);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner, name, descriptor);
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[opcode]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitJumpInsn(opcode, label);
        }
    }

    @Override
    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (value instanceof String) {
            AbstractVisitor.appendString(this.buf, (String)value);
        } else if (value instanceof Type) {
            this.buf.append(((Type)value).getDescriptor() + ".class");
        } else {
            this.buf.append(value);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLdcInsn(value);
        }
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(var).append(' ').append(increment).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIincInsn(var, increment);
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i2 = 0; i2 < labels.length; ++i2) {
            this.buf.append(this.tab3).append(min + i2).append(": ");
            this.appendLabel(labels[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i2 = 0; i2 < labels.length; ++i2) {
            this.buf.append(this.tab3).append(keys[i2]).append(": ");
            this.appendLabel(labels[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(dflt);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, descriptor);
        this.buf.append(' ').append(numDimensions).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(descriptor, numDimensions);
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(start);
        this.buf.append(' ');
        this.appendLabel(end);
        this.buf.append(' ');
        this.appendLabel(handler);
        this.buf.append(' ');
        this.appendDescriptor(0, type);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(start, end, handler, type);
        }
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String s, Label start, Label end, int index) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(name).append(' ');
        this.appendDescriptor(1, descriptor);
        this.buf.append(' ');
        this.appendLabel(start);
        this.buf.append(' ');
        this.appendLabel(end);
        this.buf.append(' ').append(index).append('\n');
        if (s != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, s);
            TraceSignatureVisitor signatureVisitor = new TraceSignatureVisitor(0);
            new SignatureReader(s).acceptType(signatureVisitor);
            this.buf.append(this.tab2).append("// declaration: ").append(signatureVisitor.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLocalVariable(name, descriptor, s, start, end, index);
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(line).append(' ');
        this.appendLabel(start);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLineNumber(line, start);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(maxStack).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(maxLocals).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMaxs(maxStack, maxLocals);
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }

    private void appendFrameTypes(int n, Object[] array) {
        block9: for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                this.buf.append(' ');
            }
            if (array[i2] instanceof String) {
                int n2;
                TraceMethodVisitor traceMethodVisitor;
                String s = (String)array[i2];
                if (s.startsWith("[")) {
                    traceMethodVisitor = this;
                    n2 = 1;
                } else {
                    traceMethodVisitor = this;
                    n2 = 0;
                }
                traceMethodVisitor.appendDescriptor(n2, s);
                continue;
            }
            if (array[i2] instanceof Integer) {
                TraceMethodVisitor traceMethodVisitor2 = null;
                int n3 = 0;
                String s2 = null;
                switch ((Integer)array[i2]) {
                    case 0: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "T";
                        break;
                    }
                    case 1: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "I";
                        break;
                    }
                    case 2: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "F";
                        break;
                    }
                    case 3: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "D";
                        break;
                    }
                    case 4: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "J";
                        break;
                    }
                    case 5: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "N";
                        break;
                    }
                    case 6: {
                        traceMethodVisitor2 = this;
                        n3 = 1;
                        s2 = "U";
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                traceMethodVisitor2.appendDescriptor(n3, s2);
                continue;
            }
            this.appendLabel((Label)array[i2]);
        }
    }

    protected void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

