/*
 * Decompiled with CFR 0.152.
 */
package org.pigler.api;

import com.nokia.mid.ui.SoftNotificationImpl;
import emulator.Emulator;
import emulator.graphics2D.awt.ImageAWT;
import emulator.ui.swt.EmulatorScreen;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import javax.microedition.lcdui.Image;
import org.eclipse.swt.widgets.Shell;
import org.pigler.api.IPiglerTapHandler;
import org.pigler.api.PiglerException;

public class PiglerAPI {
    private String appName;
    private IPiglerTapHandler listener;
    private boolean launch = true;
    private boolean created;
    private boolean tapped;

    public int init() {
        if (!SystemTray.isSupported()) {
            throw new PiglerException("Not supported");
        }
        this.appName = "KEmulator";
        SoftNotificationImpl.setPigler(this);
        return 0;
    }

    public int init(String appName) throws Exception {
        this.init();
        this.appName = appName;
        return 0;
    }

    public int getAPIVersion() {
        return 4;
    }

    public int createNotification(String title, String text, Image icon, boolean removeOnTap) throws Exception {
        this.created = true;
        SoftNotificationImpl.trayIcon.displayMessage(title, text, TrayIcon.MessageType.NONE);
        this.updateNotification(2100, icon);
        return 2100;
    }

    public void updateNotification(int uid, String title, String text, Image icon) throws Exception {
        this.updateNotification(uid, title, text);
        this.updateNotification(uid, icon);
    }

    public void updateNotification(int uid, String title, String text) throws Exception {
        SoftNotificationImpl.trayIcon.displayMessage(title, text, TrayIcon.MessageType.NONE);
    }

    public void updateNotification(int uid, Image icon) throws Exception {
        if (icon == null) {
            return;
        }
        try {
            SoftNotificationImpl.trayIcon.setImage(((ImageAWT)icon.getImpl()).getBufferedImage());
            SoftNotificationImpl.trayIcon.setImageAutoSize(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeNotification(int uid) throws Exception {
        if (uid == 2100) {
            this.created = false;
        }
    }

    public int removeAllNotifications() {
        if (this.created) {
            this.created = false;
            return 1;
        }
        return 0;
    }

    public int getLastTappedNotification() {
        if (this.tapped) {
            return 2100;
        }
        return 0;
    }

    public void setRemoveNotificationOnTap(int uid, boolean remove) throws Exception {
    }

    public void setLaunchAppOnTap(int uid, boolean launch) throws Exception {
        if (uid != 2100) {
            throw new PiglerException("Invalid uid");
        }
        this.launch = launch;
    }

    public void setListener(IPiglerTapHandler listener) {
        this.listener = listener;
    }

    public void close() {
        SoftNotificationImpl.setPigler(null);
    }

    public String getAppName() {
        return this.appName;
    }

    public int getMaxNotificationsCount() {
        return 1;
    }

    public int getNotificationsCount() {
        return this.created ? 1 : 0;
    }

    public int getGlobalNotificationsCount() throws Exception {
        return this.created ? 1 : 0;
    }

    public boolean isSingleLine() {
        return false;
    }

    public int getIconSize() {
        return 52;
    }

    public void showGlobalPopup(String title, String text, int flags) {
        throw new PiglerException("showGlobalPopup not supported");
    }

    public void _callback(int i2) {
        this.tapped = true;
        if (this.launch) {
            try {
                if (Emulator.getEmulator().getScreen() instanceof EmulatorScreen) {
                    Shell shell = ((EmulatorScreen)Emulator.getEmulator().getScreen()).getShell();
                    shell.getDisplay().asyncExec(() -> {
                        try {
                            shell.setMinimized(false);
                            shell.setActive();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.created) {
            return;
        }
        this.created = false;
        if (this.listener != null) {
            this.listener.handleNotificationTap(2100);
        }
    }
}

