/*
 * Decompiled with CFR 0.152.
 */
package ru.nnproject.kemulator.windowapi;

import emulator.graphics2D.awt.ImageAWT;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Canvas;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class SecondaryWindow {
    JFrame frame = new JFrame();
    CanvasImpl canvas;
    Canvas listener;
    private ImageAWT screenBuffer;

    private SecondaryWindow(String title, int w, int h2) {
        this.frame.setTitle(title);
        this.canvas = new CanvasImpl();
        this.canvas.addKeyListener(this.canvas);
        this.canvas.addMouseListener(this.canvas);
        this.canvas.addComponentListener(this.canvas);
        this.canvas.addMouseMotionListener(this.canvas);
        this.canvas.setDoubleBuffered(true);
        this.frame.add(this.canvas);
        this.frame.addWindowListener(this.canvas);
        this.frame.setBounds(100, 100, w, h2);
        this.canvas.setPreferredSize(new Dimension(w, h2));
        this.frame.pack();
    }

    public static SecondaryWindow create(String title, int w, int h2) {
        return new SecondaryWindow(title, w, h2);
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public void setBounds(int x, int y, int w, int h2) {
        this.frame.setBounds(x, y, w, h2);
    }

    public void setSize(int w, int h2) {
        this.canvas.setPreferredSize(new Dimension(w, h2));
        this.frame.pack();
    }

    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    public void setResizable(boolean b2) {
        this.frame.setResizable(b2);
    }

    public void setAlwaysOnTop(boolean b2) {
        this.frame.setAlwaysOnTop(b2);
    }

    public void setTitle(String s) {
        this.frame.setTitle(s);
    }

    public void setVisible(boolean b2) {
        this.frame.setVisible(b2);
        if (b2) {
            this.frame.repaint();
        }
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void setListener(Canvas c2) {
        this.listener = c2;
        if (c2 != null) {
            c2.setFullScreenMode(true);
            this.canvas.repaint();
        }
    }

    private class CanvasImpl
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    ComponentListener,
    WindowListener {
        private CanvasImpl() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (SecondaryWindow.this.screenBuffer == null || SecondaryWindow.this.screenBuffer.getWidth() != this.getWidth() || SecondaryWindow.this.screenBuffer.getHeight() != this.getHeight()) {
                SecondaryWindow.this.screenBuffer = new ImageAWT(new BufferedImage(this.getWidth(), this.getHeight(), 1));
            }
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokePaint(SecondaryWindow.this.screenBuffer, null);
            }
            g.drawImage(SecondaryWindow.this.screenBuffer.getBufferedImage(), 0, 0, null);
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeKeyPressed(e2.getKeyCode());
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeKeyReleased(e2.getKeyCode());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerPressed(e2.getX(), e2.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerReleased(e2.getX(), e2.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeSizeChanged(this.getWidth(), this.getHeight());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeSizeChanged(this.getWidth(), this.getHeight());
            }
        }

        @Override
        public void componentShown(ComponentEvent e2) {
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener.invokePointerDragged(e2.getX(), e2.getY());
            }
        }

        @Override
        public void windowOpened(WindowEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeShowNotify();
            }
        }

        @Override
        public void windowClosing(WindowEvent e2) {
            if (SecondaryWindow.this.listener != null) {
                SecondaryWindow.this.listener._invokeHideNotify();
            }
        }

        @Override
        public void windowClosed(WindowEvent e2) {
        }

        @Override
        public void windowIconified(WindowEvent e2) {
        }

        @Override
        public void windowDeiconified(WindowEvent e2) {
        }

        @Override
        public void windowActivated(WindowEvent e2) {
        }

        @Override
        public void windowDeactivated(WindowEvent e2) {
        }
    }
}

