/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.custom.ResourceManager;
import java.io.IOException;
import ru.woesss.j2me.micro3d.Action;
import ru.woesss.j2me.micro3d.Loader;
import ru.woesss.j2me.micro3d.SparseIntArray;

public class ActTableImpl {
    Action[] actions;

    public ActTableImpl(byte[] b2) {
        if (b2 == null) {
            throw new NullPointerException();
        }
        try {
            this.actions = Loader.loadMtraData(b2, 0, b2.length);
        }
        catch (IOException e2) {
            System.err.println("Error loading data");
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public ActTableImpl(byte[] b2, int offset, int length) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > b2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.actions = Loader.loadMtraData(b2, offset, length);
        }
        catch (Exception e2) {
            System.err.println("Error loading data");
            e2.printStackTrace();
            throw e2;
        }
    }

    public ActTableImpl(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        byte[] bytes = ResourceManager.getBytes(name);
        if (bytes == null) {
            throw new IOException();
        }
        try {
            this.actions = Loader.loadMtraData(bytes, 0, bytes.length);
        }
        catch (IOException e2) {
            System.err.println("Error loading data from [" + name + "]");
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public final void dispose() {
        this.actions = null;
    }

    public final int getNumActions() {
        this.checkDisposed();
        return this.actions.length;
    }

    public final int getNumFrames(int idx) {
        this.checkDisposed();
        if (idx < 0 || idx >= this.actions.length) {
            throw new IllegalArgumentException();
        }
        return this.actions[idx].keyframes << 16;
    }

    private void checkDisposed() {
        if (this.actions == null) {
            throw new IllegalStateException("ActionTable disposed!");
        }
    }

    public int getPattern(int action, int frame, int defValue) {
        Action act = this.actions[action];
        SparseIntArray dynamic = act.dynamic;
        if (dynamic != null) {
            int iFrame = frame < 0 ? 0 : frame >> 16;
            for (int i2 = dynamic.size() - 1; i2 >= 0; --i2) {
                if (dynamic.keyAt(i2) > iFrame) continue;
                return dynamic.valueAt(i2);
            }
        }
        return defValue;
    }
}

