/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import ru.woesss.j2me.micro3d.BufferUtils;

class Model {
    final int numPatterns;
    final boolean hasPolyC;
    final boolean hasPolyT;
    FloatBuffer vertexArray;
    FloatBuffer normalsArray;
    final ByteBuffer texCoordArray;
    final FloatBuffer originalVertices;
    FloatBuffer normals;
    FloatBuffer originalNormals;
    final Polygon[] polygonsC;
    final Polygon[] polygonsT;
    final FloatBuffer vertices;
    final int vertexArrayCapacity;
    final int[][][] subMeshesLengthsT;
    final int[][] subMeshesLengthsC;
    final int numVerticesPolyT;
    final int[] indices;
    final ByteBuffer bones;

    Model(int vertices, int numBones, int patterns, int numTextures, int polyT3, int polyT4, int polyC3, int polyC4) {
        this.numPatterns = patterns;
        this.subMeshesLengthsT = new int[4][numTextures][2];
        this.subMeshesLengthsC = new int[4][2];
        this.numVerticesPolyT = polyT3 * 3 + polyT4 * 6;
        int numVertices = (polyT3 + polyC3) * 3 + (polyT4 + polyC4) * 6;
        this.indices = new int[numVertices];
        this.vertexArrayCapacity = numVertices * 3;
        this.polygonsC = new Polygon[polyC3 + polyC4];
        this.polygonsT = new Polygon[polyT3 + polyT4];
        this.hasPolyT = polyT3 + polyT4 > 0;
        this.hasPolyC = polyC3 + polyC4 > 0;
        this.texCoordArray = BufferUtils.createByteBuffer(numVertices * 5);
        this.originalVertices = BufferUtils.createFloatBuffer(vertices * 3);
        int i2 = vertices * 3 + 3;
        this.vertices = BufferUtils.createFloatBuffer(i2);
        this.vertices.put(--i2, Float.POSITIVE_INFINITY);
        this.bones = BufferUtils.createByteBuffer(numBones * 14 * 4);
    }

    static final class Polygon {
        static final int TRANSPARENT = 1;
        static final int BLEND_HALF = 2;
        static final int BLEND_ADD = 4;
        static final int BLEND_SUB = 6;
        private static final int DOUBLE_FACE = 16;
        static final int LIGHTING = 32;
        static final int SPECULAR = 64;
        final int[] indices;
        final int blendMode;
        final int doubleFace;
        byte[] texCoords;
        int face = -1;
        int pattern;

        Polygon(int material, byte[] texCoords, int ... indices) {
            this.indices = indices;
            this.texCoords = texCoords;
            this.doubleFace = (material & 0x10) >> 4;
            this.blendMode = material & 6;
        }
    }
}

