/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.Settings;
import emulator.custom.ResourceManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import org.lwjgl.opengl.ARBES2Compatibility;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.Light;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

abstract class Program {
    static Tex tex;
    static Color color;
    static Simple simple;
    static Sprite sprite;
    private static boolean isCreated;
    protected final int id;
    protected int uAmbIntensity;
    protected int uDirIntensity;
    protected int uLightDir;
    protected int uMatrix;
    protected int uNormalMatrix;
    int aPosition;
    int aNormal;
    int aColorData;
    int aMaterial;

    Program(String vertexShader, String fragmentShader) {
        try {
            this.id = this.createProgram(vertexShader, fragmentShader);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.getLocations();
        Render.checkGlError("getLocations");
    }

    static void create() {
        if (isCreated) {
            return;
        }
        tex = new Tex();
        color = new Color();
        simple = new Simple();
        sprite = new Sprite();
        ARBES2Compatibility.glReleaseShaderCompiler();
    }

    private int createProgram(String vertexShader, String fragmentShader) throws IOException {
        String vertexShaderCode = new String(ResourceManager.getBytes(this.getClass().getResourceAsStream(vertexShader)), StandardCharsets.UTF_8);
        String fragmentShaderCode = new String(ResourceManager.getBytes(this.getClass().getResourceAsStream(fragmentShader)), StandardCharsets.UTF_8);
        System.out.println("loadShader " + vertexShader);
        int vertexId = this.loadShader(35633, vertexShaderCode);
        System.out.println("loadShader " + fragmentShader);
        int fragmentId = this.loadShader(35632, fragmentShaderCode);
        int program = GL20.glCreateProgram();
        GL20.glAttachShader(program, vertexId);
        GL20.glAttachShader(program, fragmentId);
        GL20.glLinkProgram(program);
        IntBuffer status = BufferUtils.createIntBuffer(1);
        GL20.glGetProgramiv(program, 35714, status);
        if (status.get(0) == 0) {
            String s = GL20.glGetProgramInfoLog(program, 512);
            System.out.println("createProgram: " + s);
        }
        GL20.glDeleteShader(vertexId);
        GL20.glDeleteShader(fragmentId);
        Render.checkGlError("glLinkProgram");
        return program;
    }

    protected int loadShader(int type, String shaderCode) {
        int shader = GL20.glCreateShader(type);
        GL20.glShaderSource(shader, (CharSequence)shaderCode);
        GL20.glCompileShader(shader);
        IntBuffer status = BufferUtils.createIntBuffer(1);
        GL20.glGetShaderiv(shader, 35713, status);
        if (status.get(0) == 0) {
            String s = GL20.glGetShaderInfoLog(shader, 512);
            System.out.println("loadShader: " + s);
        }
        Render.checkGlError("glCompileShader");
        return shader;
    }

    void use() {
        GL20.glUseProgram(this.id);
    }

    protected abstract void getLocations();

    static void release() {
        if (!isCreated) {
            return;
        }
        tex.delete();
        color.delete();
        simple.delete();
        sprite.delete();
        isCreated = false;
    }

    void delete() {
        GL20.glDeleteProgram(this.id);
        Render.checkGlError("program delete");
    }

    void setLight(Light light) {
        if (light == null) {
            GL20.glUniform1f(this.uAmbIntensity, -1.0f);
            return;
        }
        GL20.glUniform1f(this.uAmbIntensity, (float)MathUtil.clamp(light.ambIntensity, 0, 4096) * 2.4414062E-4f);
        GL20.glUniform1f(this.uDirIntensity, (float)MathUtil.clamp(light.dirIntensity, 0, 16384) * 2.4414062E-4f);
        float x = light.x;
        float y = light.y;
        float z = light.z;
        float rlf = -1.0f / (float)Math.sqrt(x * x + y * y + z * z);
        GL20.glUniform3f(this.uLightDir, x * rlf, y * rlf, z * rlf);
    }

    static class Sprite
    extends Program {
        private static final String VERTEX = "/shaders/sprite.vsh";
        private static final String FRAGMENT = "/shaders/sprite.fsh";
        int uTexSize;
        int uIsTransparency;

        Sprite() {
            super(VERTEX, FRAGMENT);
        }

        @Override
        protected int loadShader(int type, String shaderCode) {
            if (Settings.mascotTextureFilter) {
                shaderCode = "#define FILTER\n" + shaderCode;
            }
            return super.loadShader(type, shaderCode);
        }

        @Override
        protected void getLocations() {
            this.aPosition = GL20.glGetAttribLocation(this.id, "aPosition");
            this.aColorData = GL20.glGetAttribLocation(this.id, "aColorData");
            this.uTexSize = GL20.glGetUniformLocation(this.id, "uTexSize");
            this.uIsTransparency = GL20.glGetUniformLocation(this.id, "uIsTransparency");
            this.use();
            GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "uTextureUnit"), 0);
        }

        void setTexture(TextureImpl texture) {
            int id = texture.getId();
            GL20.glActiveTexture(33984);
            GL11.glBindTexture(3553, id);
            GL20.glUniform2f(this.uTexSize, texture.getWidth(), texture.getHeight());
        }
    }

    static final class Tex
    extends Program {
        private static final String VERTEX = "/shaders/tex.vsh";
        private static final String FRAGMENT = "/shaders/tex.fsh";
        int uTexSize;
        int uSphereSize;
        int uToonThreshold;
        int uToonHigh;
        int uToonLow;

        Tex() {
            super(VERTEX, FRAGMENT);
        }

        @Override
        protected int loadShader(int type, String shaderCode) {
            if (Settings.mascotTextureFilter) {
                shaderCode = "#define FILTER\n" + shaderCode;
            }
            return super.loadShader(type, shaderCode);
        }

        @Override
        protected void getLocations() {
            this.aPosition = GL20.glGetAttribLocation(this.id, "aPosition");
            this.aNormal = GL20.glGetAttribLocation(this.id, "aNormal");
            this.aColorData = GL20.glGetAttribLocation(this.id, "aColorData");
            this.aMaterial = GL20.glGetAttribLocation(this.id, "aMaterial");
            this.uTexSize = GL20.glGetUniformLocation(this.id, "uTexSize");
            this.uSphereSize = GL20.glGetUniformLocation(this.id, "uSphereSize");
            this.uMatrix = GL20.glGetUniformLocation(this.id, "uMatrix");
            this.uNormalMatrix = GL20.glGetUniformLocation(this.id, "uNormalMatrix");
            this.uAmbIntensity = GL20.glGetUniformLocation(this.id, "uAmbIntensity");
            this.uDirIntensity = GL20.glGetUniformLocation(this.id, "uDirIntensity");
            this.uLightDir = GL20.glGetUniformLocation(this.id, "uLightDir");
            this.uToonThreshold = GL20.glGetUniformLocation(this.id, "uToonThreshold");
            this.uToonHigh = GL20.glGetUniformLocation(this.id, "uToonHigh");
            this.uToonLow = GL20.glGetUniformLocation(this.id, "uToonLow");
            this.use();
            GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "uTextureUnit"), 0);
            GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "uSphereUnit"), 2);
        }

        void setTex(TextureImpl tex) {
            if (tex != null) {
                int id = tex.getId();
                GL20.glActiveTexture(33984);
                GL11.glBindTexture(3553, id);
                GL20.glUniform2f(this.uTexSize, tex.getWidth(), tex.getHeight());
            } else {
                GL20.glUniform2f(this.uTexSize, 256.0f, 256.0f);
                GL11.glBindTexture(3553, 0);
            }
        }

        void setToonShading(int attrs, int threshold, int high, int low) {
            if ((attrs & 4) != 0) {
                GL20.glUniform1f(this.uToonThreshold, (float)threshold / 255.0f);
                GL20.glUniform1f(this.uToonHigh, (float)high / 255.0f);
                GL20.glUniform1f(this.uToonLow, (float)low / 255.0f);
            } else {
                GL20.glUniform1f(this.uToonThreshold, -1.0f);
            }
        }

        void bindMatrices(float[] mvp, float[] mv) {
            GL20.glUniformMatrix4fv(this.uMatrix, false, mvp);
            GL20.glUniformMatrix3fv(this.uNormalMatrix, false, mv);
        }

        void setSphere(TextureImpl sphere) {
            if (sphere != null) {
                int id = sphere.getId();
                GL20.glActiveTexture(33986);
                GL11.glBindTexture(3553, id);
                GL20.glUniform2f(this.uSphereSize, sphere.getWidth(), sphere.getHeight());
            } else {
                GL20.glUniform2f(this.uSphereSize, -1.0f, -1.0f);
            }
        }
    }

    static final class Simple
    extends Program {
        private static final String VERTEX = "/shaders/simple.vsh";
        private static final String FRAGMENT = "/shaders/simple.fsh";
        int aTexture;

        Simple() {
            super(VERTEX, FRAGMENT);
        }

        @Override
        protected void getLocations() {
            this.aPosition = GL20.glGetAttribLocation(this.id, "a_position");
            this.aTexture = GL20.glGetAttribLocation(this.id, "a_texcoord0");
            this.use();
            GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "sampler0"), 1);
        }
    }

    static final class Color
    extends Program {
        private static final String VERTEX = "/shaders/color.vsh";
        private static final String FRAGMENT = "/shaders/color.fsh";
        int uSphereSize;
        int uToonThreshold;
        int uToonHigh;
        int uToonLow;

        Color() {
            super(VERTEX, FRAGMENT);
        }

        @Override
        protected void getLocations() {
            this.aPosition = GL20.glGetAttribLocation(this.id, "aPosition");
            this.aNormal = GL20.glGetAttribLocation(this.id, "aNormal");
            this.aColorData = GL20.glGetAttribLocation(this.id, "aColorData");
            this.aMaterial = GL20.glGetAttribLocation(this.id, "aMaterial");
            this.uMatrix = GL20.glGetUniformLocation(this.id, "uMatrix");
            this.uNormalMatrix = GL20.glGetUniformLocation(this.id, "uNormalMatrix");
            this.uAmbIntensity = GL20.glGetUniformLocation(this.id, "uAmbIntensity");
            this.uDirIntensity = GL20.glGetUniformLocation(this.id, "uDirIntensity");
            this.uLightDir = GL20.glGetUniformLocation(this.id, "uLightDir");
            this.uSphereSize = GL20.glGetUniformLocation(this.id, "uSphereSize");
            this.uToonThreshold = GL20.glGetUniformLocation(this.id, "uToonThreshold");
            this.uToonHigh = GL20.glGetUniformLocation(this.id, "uToonHigh");
            this.uToonLow = GL20.glGetUniformLocation(this.id, "uToonLow");
            this.use();
            GL20.glUniform1i(GL20.glGetUniformLocation(this.id, "uSphereUnit"), 2);
        }

        void setColor(ByteBuffer rgb) {
            rgb.rewind();
            float r = (float)(rgb.get() & 0xFF) / 255.0f;
            float g = (float)(rgb.get() & 0xFF) / 255.0f;
            float b2 = (float)(rgb.get() & 0xFF) / 255.0f;
            GL20.glVertexAttrib3f(this.aColorData, r, g, b2);
        }

        void setToonShading(int attrs, int threshold, int high, int low) {
            if ((attrs & 4) != 0) {
                GL20.glUniform1f(this.uToonThreshold, (float)threshold / 255.0f);
                GL20.glUniform1f(this.uToonHigh, (float)high / 255.0f);
                GL20.glUniform1f(this.uToonLow, (float)low / 255.0f);
            } else {
                GL20.glUniform1f(this.uToonThreshold, -1.0f);
            }
        }

        void bindMatrices(float[] mvp, float[] mv) {
            GL20.glUniformMatrix4fv(this.uMatrix, false, mvp);
            GL20.glUniformMatrix3fv(this.uNormalMatrix, false, mv);
        }

        void setSphere(TextureImpl sphere) {
            if (sphere != null) {
                int id = sphere.getId();
                GL20.glActiveTexture(33986);
                GL11.glBindTexture(3553, id);
                GL20.glUniform2f(this.uSphereSize, sphere.getWidth(), sphere.getHeight());
            } else {
                GL20.glUniform2f(this.uSphereSize, -1.0f, -1.0f);
            }
        }
    }
}

