/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.Settings;
import emulator.debug.Profiler3D;
import emulator.graphics2D.IImage;
import emulator.graphics3D.lwjgl.Emulator3D;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.FigureImpl;
import ru.woesss.j2me.micro3d.Light;
import ru.woesss.j2me.micro3d.MathUtil;
import ru.woesss.j2me.micro3d.Model;
import ru.woesss.j2me.micro3d.Program;
import ru.woesss.j2me.micro3d.RenderNode;
import ru.woesss.j2me.micro3d.TextureImpl;
import ru.woesss.j2me.micro3d.Utils;

public class Render {
    private static final FloatBuffer BG_VBO = BufferUtils.createFloatBuffer(16).put(new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
    private static final int PDATA_COLOR_MASK = 3072;
    private static final int PDATA_COLOR_PER_VERTEX = 3072;
    private static final int PDATA_NORMAL_MASK = 768;
    private static final int PDATA_TEXCOORD_MASK = 12288;
    private static final int[] PRIMITIVE_SIZES = new int[]{0, 1, 2, 3, 4, 1};
    final Environment env = new Environment();
    private final IntBuffer bgTextureId = BufferUtils.createIntBuffer(1).put(-1);
    private final float[] MVP_TMP = new float[16];
    private Graphics targetGraphics;
    private final Rectangle gClip = new Rectangle();
    private final Rectangle clip = new Rectangle();
    private boolean backCopied;
    private final LinkedList<RenderNode> stack = new LinkedList();
    private int flushStep;
    private final boolean postCopy2D = !Settings.mascotNo2DMixing;
    private final boolean preCopy2D = !Settings.mascotIgnoreBackground;
    private IntBuffer bufHandles;
    private int clearColor;
    private TextureImpl targetTexture;
    private ByteBuffer imageBuffer;
    private Emulator3D g3d;
    private boolean wasBinded;

    static void checkGlError(String glOperation) {
        int error = GL20.glGetError();
        if (error != 0) {
            System.err.println(glOperation + ": glError " + error);
            throw new RuntimeException(glOperation + ": glError " + error);
        }
    }

    public static Render getRender() {
        return InstanceHolder.instance;
    }

    private void init() {
        this.g3d = Emulator3D.getInstance();
        this.g3d.setFlipImage(true);
        this.g3d.start();
    }

    public synchronized void bind(Graphics graphics, boolean doClip) {
        ++Profiler3D.MC3D_bindGraphicsCallCount;
        this.targetGraphics = graphics;
        if (this.g3d == null) {
            this.init();
        }
        this.g3d.sync(() -> {
            boolean aa;
            IImage bitmap = graphics.getImage();
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (this.env.width != width || this.env.height != height) {
                try {
                    if (this.wasBinded) {
                        this.g3d.releaseTarget();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.g3d.bindTarget(graphics);
                this.wasBinded = true;
                GL20.glViewport(0, 0, width, height);
                Program.create();
                this.env.width = width;
                this.env.height = height;
                GL20.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                GL20.glClear(16384);
            } else {
                this.g3d.bindTarget(graphics);
                GL20.glViewport(0, 0, width, height);
            }
            Rectangle clip = this.clip;
            if (doClip) {
                clip.setBounds(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
            } else {
                clip.width = width;
                clip.height = height;
            }
            int l = clip.x;
            int t = clip.y;
            int w = clip.width;
            int h2 = clip.height;
            this.gClip.setBounds(l, t, w, h2);
            if (l == 0 && t == 0 && w == this.env.width && h2 == this.env.height) {
                GL20.glDisable(3089);
            } else {
                GL20.glEnable(3089);
                GL20.glScissor(l, t, w, h2);
            }
            GL20.glClear(256);
            boolean bl = aa = Settings.m3gAA == 2;
            if (aa) {
                GL11.glEnable(2832);
                GL11.glEnable(2848);
                GL11.glEnable(2881);
                if (!Emulator3D.useGL11()) {
                    GL11.glEnable(32925);
                }
            } else {
                GL11.glDisable(2832);
                GL11.glDisable(2848);
                GL11.glDisable(2881);
                if (!Emulator3D.useGL11()) {
                    GL11.glDisable(32925);
                }
            }
            this.backCopied = false;
        });
    }

    public synchronized void bind(TextureImpl tex) {
        ++Profiler3D.MC3D_bindTextureCallCount;
        this.targetTexture = tex;
        int width = tex.getWidth();
        int height = tex.getHeight();
        if (this.g3d == null) {
            this.init();
        }
        this.g3d.sync(() -> {
            if (this.env.width != width || this.env.height != height) {
                if (this.wasBinded) {
                    this.g3d.releaseTarget();
                }
                this.g3d.bindTarget(Image.createImage(width, height, 0).getGraphics());
                GL20.glViewport(0, 0, width, height);
                Program.create();
                this.env.width = width;
                this.env.height = height;
            } else {
                this.g3d.bindTarget(Image.createImage(width, height, 0).getGraphics());
                GL20.glViewport(0, 0, width, height);
            }
            Rectangle clip = this.clip;
            clip.setBounds(0, 0, width, height);
            int l = clip.x;
            int t = clip.y;
            int w = clip.width;
            int h2 = clip.height;
            this.gClip.setBounds(l, t, w, h2);
            if (l == 0 && t == 0 && w == this.env.width && h2 == this.env.height) {
                GL20.glDisable(3089);
            } else {
                GL20.glEnable(3089);
                GL20.glScissor(l, t, w, h2);
            }
            GL20.glClearColor((float)(this.clearColor >> 16 & 0xFF) / 255.0f, (float)(this.clearColor >> 8 & 0xFF) / 255.0f, (float)(this.clearColor & 0xFF) / 255.0f, 1.0f);
            GL20.glClear(16640);
            this.backCopied = false;
        });
    }

    private static void applyBlending(int blendMode) {
        switch (blendMode) {
            case 2: {
                GL20.glEnable(3042);
                GL20.glBlendColor(0.5f, 0.5f, 0.5f, 1.0f);
                GL20.glBlendEquation(32774);
                GL20.glBlendFunc(32769, 32769);
                break;
            }
            case 4: {
                GL20.glEnable(3042);
                GL20.glBlendEquation(32774);
                GL20.glBlendFunc(1, 1);
                break;
            }
            case 6: {
                GL20.glEnable(3042);
                GL20.glBlendEquation(32779);
                GL20.glBlendFuncSeparate(1, 1, 0, 1);
                break;
            }
            default: {
                GL20.glDisable(3042);
            }
        }
    }

    private void copy2d(boolean preProcess) {
        if (this.targetTexture != null) {
            return;
        }
        ++Profiler3D.MC3D_copy2dCount;
        if (!GL20.glIsTexture(this.bgTextureId.get(0))) {
            this.bgTextureId.rewind();
            GL20.glGenTextures(this.bgTextureId);
            GL20.glActiveTexture(33985);
            GL20.glBindTexture(3553, this.bgTextureId.get(0));
            boolean filter = Settings.mascotBackgroundFilter;
            GL20.glTexParameteri(3553, 10241, filter ? 9729 : 9728);
            GL20.glTexParameteri(3553, 10240, filter ? 9729 : 9728);
            GL20.glTexParameteri(3553, 10242, 33071);
            GL20.glTexParameteri(3553, 10243, 33071);
        } else {
            GL20.glActiveTexture(33985);
            GL20.glBindTexture(3553, this.bgTextureId.get(0));
        }
        IImage targetImage = this.targetGraphics.getImage();
        int texFormat = targetImage.isTransparent() ? 6408 : 6407;
        GL11.glTexImage2D(3553, 0, texFormat, targetImage.getWidth(), targetImage.getHeight(), 0, texFormat, 5121, this.getImageBuffer(Render.convert(targetImage.getData(), targetImage.isTransparent())));
        Render.checkGlError("texImage2D");
        Program.Simple program = Program.simple;
        program.use();
        BG_VBO.rewind();
        GL20.glVertexAttribPointer(program.aPosition, 2, 5126, false, 16, BG_VBO);
        GL20.glEnableVertexAttribArray(program.aPosition);
        BG_VBO.position(2);
        GL20.glVertexAttribPointer(program.aTexture, 2, 5126, false, 16, BG_VBO);
        GL20.glEnableVertexAttribArray(program.aTexture);
        if (preProcess) {
            GL20.glDisable(3042);
        } else {
            GL20.glEnable(3042);
            GL20.glBlendEquation(32774);
            GL20.glBlendFunc(770, 771);
        }
        GL20.glDisable(2929);
        GL20.glDepthMask(false);
        GL20.glDrawArrays(5, 0, 4);
        GL20.glDisableVertexAttribArray(program.aPosition);
        GL20.glDisableVertexAttribArray(program.aTexture);
        Render.checkGlError("copy2d");
        if (!preProcess) {
            return;
        }
        if (this.postCopy2D) {
            this.targetGraphics.setColor(0);
            this.targetGraphics.fillRect(this.gClip.x, this.gClip.y, this.gClip.width, this.gClip.height);
        }
        this.backCopied = true;
    }

    public ByteBuffer getImageBuffer(byte[] var0) {
        if (this.imageBuffer == null || this.imageBuffer.capacity() < var0.length) {
            this.imageBuffer = org.lwjgl.BufferUtils.createByteBuffer(var0.length * 4 / 3);
        }
        this.imageBuffer.position(this.imageBuffer.capacity() - var0.length);
        this.imageBuffer.put(var0);
        this.imageBuffer.position(this.imageBuffer.capacity() - var0.length);
        return this.imageBuffer;
    }

    private static byte[] convert(int[] data, boolean alpha) {
        int l = data.length;
        if (!alpha) {
            byte[] b2 = new byte[l * 3];
            for (int i2 = l - 1; i2 >= 0; --i2) {
                b2[i2 * 3] = (byte)(data[i2] >> 16 & 0xFF);
                b2[i2 * 3 + 1] = (byte)(data[i2] >> 8 & 0xFF);
                b2[i2 * 3 + 2] = (byte)(data[i2] & 0xFF);
            }
            return b2;
        }
        byte[] b3 = new byte[l * 4];
        for (int i3 = l - 1; i3 >= 0; --i3) {
            b3[i3 * 4] = (byte)(data[i3] >> 16 & 0xFF);
            b3[i3 * 4 + 1] = (byte)(data[i3] >> 8 & 0xFF);
            b3[i3 * 4 + 2] = (byte)(data[i3] & 0xFF);
            b3[i3 * 4 + 3] = (byte)(data[i3] >> 24 & 0xFF);
        }
        return b3;
    }

    protected void finalize() throws Throwable {
        try {
            this.g3d.releaseTarget();
        }
        finally {
            super.finalize();
        }
    }

    void renderFigure(Model model, TextureImpl[] textures, int attrs, float[] projMatrix, float[] viewMatrix, FloatBuffer vertices, FloatBuffer normals, Light light, TextureImpl specular, int toonThreshold, int toonHigh, int toonLow) {
        ++Profiler3D.MC3D_renderFigureCallCount;
        this.g3d.sync(() -> {
            boolean isTransparency;
            boolean bl = isTransparency = (attrs & 8) != 0;
            if (!isTransparency && this.flushStep == 2) {
                return;
            }
            if (!model.hasPolyT && !model.hasPolyC) {
                return;
            }
            GL20.glEnable(2929);
            GL20.glDepthMask(this.flushStep == 1);
            MathUtil.multiplyMM(this.MVP_TMP, projMatrix, viewMatrix);
            if (this.bufHandles == null) {
                this.bufHandles = BufferUtils.createIntBuffer(3);
                GL20.glGenBuffers(this.bufHandles);
            }
            try {
                Program program;
                boolean isLight;
                GL20.glBindBuffer(34962, this.bufHandles.get(0));
                GL20.glBufferData(34962, (FloatBuffer)vertices.rewind(), 35040);
                ByteBuffer texCoords = model.texCoordArray;
                GL20.glBindBuffer(34962, this.bufHandles.get(1));
                GL20.glBufferData(34962, (ByteBuffer)texCoords.rewind(), 35040);
                boolean bl2 = isLight = (attrs & 1) != 0 && normals != null;
                if (isLight) {
                    GL20.glBindBuffer(34962, this.bufHandles.get(2));
                    GL20.glBufferData(34962, (FloatBuffer)normals.rewind(), 35040);
                }
                if (model.hasPolyT) {
                    program = Program.tex;
                    program.use();
                    GL20.glBindBuffer(34962, this.bufHandles.get(0));
                    GL20.glEnableVertexAttribArray(((Program.Tex)program).aPosition);
                    GL20.glVertexAttribPointer(((Program.Tex)program).aPosition, 3, 5126, false, 12, 0L);
                    GL20.glBindBuffer(34962, this.bufHandles.get(1));
                    GL20.glEnableVertexAttribArray(((Program.Tex)program).aColorData);
                    GL20.glVertexAttribPointer(((Program.Tex)program).aColorData, 2, 5121, false, 5, 0L);
                    GL20.glEnableVertexAttribArray(((Program.Tex)program).aMaterial);
                    GL20.glVertexAttribPointer(((Program.Tex)program).aMaterial, 3, 5121, false, 5, 2L);
                    if (isLight) {
                        GL20.glBindBuffer(34962, this.bufHandles.get(2));
                        GL20.glEnableVertexAttribArray(((Program.Tex)program).aNormal);
                        GL20.glVertexAttribPointer(((Program.Tex)program).aNormal, 3, 5126, false, 12, 0L);
                        ((Program.Tex)program).setToonShading(attrs, toonThreshold, toonHigh, toonLow);
                        program.setLight(light);
                        ((Program.Tex)program).setSphere((attrs & 2) == 0 ? null : specular);
                    } else {
                        GL20.glDisableVertexAttribArray(((Program.Tex)program).aNormal);
                        program.setLight(null);
                    }
                    ((Program.Tex)program).bindMatrices(this.MVP_TMP, viewMatrix);
                    this.renderModel(textures, model, isTransparency);
                    GL20.glDisableVertexAttribArray(((Program.Tex)program).aPosition);
                    GL20.glDisableVertexAttribArray(((Program.Tex)program).aColorData);
                    GL20.glDisableVertexAttribArray(((Program.Tex)program).aMaterial);
                    GL20.glDisableVertexAttribArray(((Program.Tex)program).aNormal);
                    GL20.glBindBuffer(34962, 0);
                }
                if (model.hasPolyC) {
                    program = Program.color;
                    program.use();
                    int offset = model.numVerticesPolyT;
                    GL20.glBindBuffer(34962, this.bufHandles.get(0));
                    GL20.glEnableVertexAttribArray(((Program.Color)program).aPosition);
                    GL20.glVertexAttribPointer(((Program.Color)program).aPosition, 3, 5126, false, 12, 12 * offset);
                    GL20.glBindBuffer(34962, this.bufHandles.get(1));
                    GL20.glVertexAttribPointer(((Program.Color)program).aColorData, 3, 5121, true, 5, 5 * offset);
                    GL20.glEnableVertexAttribArray(((Program.Color)program).aColorData);
                    GL20.glEnableVertexAttribArray(((Program.Color)program).aMaterial);
                    GL20.glVertexAttribPointer(((Program.Color)program).aMaterial, 2, 5121, false, 5, 5 * offset + 3);
                    if (isLight) {
                        GL20.glBindBuffer(34962, this.bufHandles.get(2));
                        GL20.glVertexAttribPointer(((Program.Color)program).aNormal, 3, 5126, false, 12, 12 * offset);
                        GL20.glEnableVertexAttribArray(((Program.Color)program).aNormal);
                        program.setLight(light);
                        ((Program.Color)program).setSphere((attrs & 2) == 0 ? null : specular);
                        ((Program.Color)program).setToonShading(attrs, toonThreshold, toonHigh, toonLow);
                    } else {
                        GL20.glDisableVertexAttribArray(((Program.Color)program).aNormal);
                        program.setLight(null);
                    }
                    ((Program.Color)program).bindMatrices(this.MVP_TMP, viewMatrix);
                    this.renderModel(model, isTransparency);
                    GL20.glDisableVertexAttribArray(((Program.Color)program).aPosition);
                    GL20.glDisableVertexAttribArray(((Program.Color)program).aColorData);
                    GL20.glDisableVertexAttribArray(((Program.Color)program).aMaterial);
                    GL20.glDisableVertexAttribArray(((Program.Color)program).aNormal);
                }
            }
            finally {
                GL20.glBindBuffer(34962, 0);
            }
        });
    }

    private void renderModel(TextureImpl[] textures, Model model, boolean enableBlending) {
        if (textures == null || textures.length == 0) {
            return;
        }
        ++Profiler3D.MC3D_renderModelCallCount;
        Program.Tex program = Program.tex;
        int[][][] meshes = model.subMeshesLengthsT;
        int length = meshes.length;
        int blendMode = 0;
        int pos = 0;
        if (this.flushStep == 1) {
            if (enableBlending) {
                length = 1;
            }
            GL20.glDisable(3042);
        } else {
            int[][] mesh = meshes[blendMode++];
            int cnt = 0;
            int[][] nArray = mesh;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int[] lens;
                for (int len : lens = nArray[j]) {
                    cnt += len;
                }
            }
            pos += cnt;
        }
        while (blendMode < length) {
            int[][] texMesh = meshes[blendMode];
            if (this.flushStep == 2) {
                Render.applyBlending(blendMode << 1);
            }
            for (int face = 0; face < texMesh.length; ++face) {
                int[] lens = texMesh[face];
                if (face >= textures.length) {
                    program.setTex(null);
                } else {
                    TextureImpl tex = textures[face];
                    program.setTex(tex);
                }
                int cnt = lens[0];
                if (cnt > 0) {
                    GL20.glEnable(2884);
                    GL20.glDrawArrays(4, pos, cnt);
                    pos += cnt;
                }
                if ((cnt = lens[1]) <= 0) continue;
                GL20.glDisable(2884);
                GL20.glDrawArrays(4, pos, cnt);
                pos += cnt;
            }
            ++blendMode;
        }
        Render.checkGlError("glDrawArrays");
    }

    private void renderModel(Model model, boolean enableBlending) {
        int cnt;
        int[] mesh;
        ++Profiler3D.MC3D_renderModelCallCount;
        int[][] meshes = model.subMeshesLengthsC;
        int length = meshes.length;
        int pos = 0;
        int blendMode = 0;
        if (this.flushStep == 1) {
            if (enableBlending) {
                length = 1;
            }
            GL20.glDisable(3042);
        } else {
            mesh = meshes[blendMode++];
            cnt = 0;
            for (int len : mesh) {
                cnt += len;
            }
            pos += cnt;
        }
        while (blendMode < length) {
            mesh = meshes[blendMode];
            if (this.flushStep == 2) {
                Render.applyBlending(blendMode << 1);
            }
            if ((cnt = mesh[0]) > 0) {
                GL20.glEnable(2884);
                GL20.glDrawArrays(4, pos, cnt);
                pos += cnt;
            }
            if ((cnt = mesh[1]) > 0) {
                GL20.glDisable(2884);
                GL20.glDrawArrays(4, pos, cnt);
                pos += cnt;
            }
            ++blendMode;
        }
        Render.checkGlError("glDrawArrays");
    }

    public synchronized void release() {
        ++Profiler3D.MC3D_releaseCallCount;
        this.g3d.sync(() -> {
            this.stack.clear();
            if (this.targetTexture != null) {
                GL20.glReadPixels(0, 0, 256, 256, 6408, 5121, this.targetTexture.image.getRaster());
                this.targetTexture = null;
            } else if (this.targetGraphics != null) {
                if (this.postCopy2D) {
                    this.copy2d(false);
                }
                this.swapBuffers();
                this.targetGraphics = null;
            }
        });
        this.g3d.releaseTarget();
    }

    public synchronized void flush() {
        ++Profiler3D.MC3D_flushCallCount;
        if (this.stack.isEmpty()) {
            return;
        }
        this.g3d.sync(() -> {
            try {
                if (!this.backCopied && this.preCopy2D) {
                    this.copy2d(true);
                }
                this.flushStep = 1;
                for (RenderNode r : this.stack) {
                    r.render(this);
                }
                this.flushStep = 2;
                for (RenderNode r : this.stack) {
                    r.render(this);
                    r.recycle();
                }
                GL20.glDisable(3042);
                GL20.glDepthMask(true);
                GL20.glClear(256);
                GL20.glFlush();
            }
            finally {
                this.stack.clear();
                this.swapBuffers();
            }
        });
    }

    private void renderMeshC(RenderNode.PrimitiveNode node) {
        int command = node.command;
        Program.Color program = Program.color;
        program.use();
        if ((node.attrs & 1) != 0 && (command & 1) != 0 && node.normals != null) {
            TextureImpl sphere = node.specular;
            if ((node.attrs & 2) != 0 && (command & 2) != 0 && sphere != null) {
                GL20.glVertexAttrib2f(program.aMaterial, 1.0f, 1.0f);
                program.setSphere(sphere);
            } else {
                GL20.glVertexAttrib2f(program.aMaterial, 1.0f, 0.0f);
                program.setSphere(null);
            }
            program.setLight(node.light);
            program.setToonShading(node.attrs, node.toonThreshold, node.toonHigh, node.toonLow);
            GL20.glVertexAttribPointer(program.aNormal, 3, 5126, false, 12, (FloatBuffer)node.normals.rewind());
            GL20.glEnableVertexAttribArray(program.aNormal);
        } else {
            GL20.glVertexAttrib2f(program.aMaterial, 0.0f, 0.0f);
            program.setLight(null);
            GL20.glDisableVertexAttribArray(program.aNormal);
        }
        program.bindMatrices(this.MVP_TMP, node.viewMatrix);
        GL20.glVertexAttribPointer(program.aPosition, 3, 5126, false, 12, (FloatBuffer)node.vertices.rewind());
        GL20.glEnableVertexAttribArray(program.aPosition);
        if ((command & 0xC00) == 1024) {
            program.setColor(node.colors);
        } else {
            GL20.glVertexAttribPointer(program.aColorData, 3, 5121, true, 3, (ByteBuffer)node.colors.rewind());
            GL20.glEnableVertexAttribArray(program.aColorData);
        }
        GL20.glDrawArrays(4, 0, node.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program.aPosition);
        GL20.glDisableVertexAttribArray(program.aColorData);
        GL20.glDisableVertexAttribArray(program.aNormal);
        Render.checkGlError("renderMeshC");
    }

    private void renderMeshT(RenderNode.PrimitiveNode node) {
        int command = node.command;
        Program.Tex program = Program.tex;
        program.use();
        if ((node.attrs & 1) != 0 && (command & 1) != 0 && node.normals != null) {
            TextureImpl sphere = node.specular;
            if ((node.attrs & 2) != 0 && (command & 2) != 0 && sphere != null) {
                GL20.glVertexAttrib3f(program.aMaterial, 1.0f, 1.0f, command & 0x10);
                program.setSphere(sphere);
            } else {
                GL20.glVertexAttrib3f(program.aMaterial, 1.0f, 0.0f, command & 0x10);
                program.setSphere(null);
            }
            program.setLight(node.light);
            program.setToonShading(node.attrs, node.toonThreshold, node.toonHigh, node.toonLow);
            GL20.glVertexAttribPointer(program.aNormal, 3, 5126, false, 12, (FloatBuffer)node.normals.rewind());
            GL20.glEnableVertexAttribArray(program.aNormal);
        } else {
            GL20.glVertexAttrib3f(program.aMaterial, 0.0f, 0.0f, command & 0x10);
            program.setLight(null);
            GL20.glDisableVertexAttribArray(program.aNormal);
        }
        program.bindMatrices(this.MVP_TMP, node.viewMatrix);
        GL20.glVertexAttribPointer(program.aPosition, 3, 5126, false, 12, (FloatBuffer)node.vertices.rewind());
        GL20.glEnableVertexAttribArray(program.aPosition);
        GL20.glVertexAttribPointer(program.aColorData, 2, 5121, false, 2, (ByteBuffer)node.texCoords.rewind());
        GL20.glEnableVertexAttribArray(program.aColorData);
        program.setTex(node.texture);
        GL20.glDrawArrays(4, 0, node.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program.aPosition);
        GL20.glDisableVertexAttribArray(program.aColorData);
        GL20.glDisableVertexAttribArray(program.aNormal);
        Render.checkGlError("renderMeshT");
    }

    public void drawCommandList(int[] cmds) {
        ++Profiler3D.MC3D_renderCommandListCallCount;
        if (-33554431 != cmds[0]) {
            throw new IllegalArgumentException("Unsupported command list version: " + cmds[0]);
        }
        int i2 = 1;
        block17: while (i2 < cmds.length) {
            int cmd = cmds[i2++];
            switch (cmd & 0xFF000000) {
                case -2030043136: {
                    this.selectAffineTrans(cmd & 0xFFFFFF);
                    continue block17;
                }
                case -1610612736: {
                    this.env.light.ambIntensity = i2++;
                    continue block17;
                }
                case -2097152000: {
                    this.env.attrs = cmd & 0xFFFFFF;
                    continue block17;
                }
                case -2063597568: {
                    this.setCenter(cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -2080374784: {
                    Rectangle r = this.clip.intersection(new Rectangle(cmds[i2++], cmds[i2++], cmds[i2++], cmds[i2++]));
                    this.clip.setBounds(r);
                    this.updateClip();
                    continue block17;
                }
                case -1593835520: {
                    this.env.light.x = i2++;
                    this.env.light.y = i2++;
                    this.env.light.z = i2++;
                    this.env.light.dirIntensity = i2++;
                    continue block17;
                }
                case -2113929216: {
                    this.flush();
                    continue block17;
                }
                case -2130706432: {
                    i2 += cmd & 0xFFFFFF;
                    continue block17;
                }
                case -1879048192: {
                    this.setOrthographicScale(cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -1862270976: {
                    this.setOrthographicWH(cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -1845493760: {
                    this.setPerspectiveFov(cmds[i2++], cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -1828716544: {
                    this.setPerspectiveWH(cmds[i2++], cmds[i2++], cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -2046820352: {
                    int tid = cmd & 0xFFFFFF;
                    if (tid <= 0 || tid >= 16) continue block17;
                    this.env.textureIdx = tid;
                    continue block17;
                }
                case -1358954496: {
                    this.setToonParam(cmds[i2++], cmds[i2++], cmds[i2++]);
                    continue block17;
                }
                case -2147483648: {
                    return;
                }
            }
            int type = cmd & 0x7000000;
            if (type == 0 || cmd < 0) {
                throw new IllegalArgumentException();
            }
            int num = cmd >> 16 & 0xFF;
            int sizeOf = PRIMITIVE_SIZES[type >> 24];
            int len = num * 3 * sizeOf;
            int vo = i2;
            int no = i2 += len;
            if ((cmd & 0x300) == 512) {
                i2 += num * 3;
            } else if ((cmd & 0x300) == 768) {
                i2 += len;
            }
            int to = i2;
            if (type == 0x5000000) {
                if ((cmd & 0x3000) == 4096) {
                    i2 += 8;
                } else if ((cmd & 0x3000) != 0) {
                    i2 += num * 8;
                }
            } else if ((cmd & 0x3000) == 12288) {
                i2 += num * 2 * sizeOf;
            }
            int co = i2++;
            if ((cmd & 0xC00) != 1024) {
                if ((cmd & 0xC00) == 2048) {
                    i2 += num;
                } else if ((cmd & 0xC00) == 3072) {
                    i2 += num * sizeOf;
                }
            }
            if (i2 > cmds.length) {
                throw new IllegalArgumentException();
            }
            this.postPrimitives(cmd, cmds, vo, cmds, no, cmds, to, cmds, co);
        }
    }

    private void updateClip() {
        this.g3d.sync(() -> {
            Rectangle clip = this.clip;
            int l = clip.x;
            int t = clip.y;
            int w = clip.width;
            int h2 = clip.height;
            if (l == 0 && t == 0 && w == this.env.width && h2 == this.env.height) {
                GL20.glDisable(3089);
            } else {
                GL20.glEnable(3089);
                GL20.glScissor(l, t, w, h2);
            }
        });
    }

    public synchronized void postFigure(FigureImpl figure) {
        RenderNode.FigureNode rn;
        ++Profiler3D.MC3D_postFigureCallCount;
        if (figure.stack.empty()) {
            rn = new RenderNode.FigureNode(this, figure);
        } else {
            rn = figure.stack.pop();
            rn.setData(this);
        }
        this.stack.add(rn);
    }

    public synchronized void postPrimitives(int command, int[] vertices, int vo, int[] normals, int no, int[] textureCoords, int to, int[] colors, int co) {
        FloatBuffer vcBuf;
        ++Profiler3D.MC3D_postPrimitivesCallCount;
        if (command < 0) {
            throw new IllegalArgumentException();
        }
        int numPrimitives = command >> 16 & 0xFF;
        FloatBuffer ncBuf = null;
        ByteBuffer tcBuf = null;
        ByteBuffer colorBuf = null;
        switch (command & 0x7000000) {
            case 0x1000000: {
                int i2;
                int vcLen = numPrimitives * 3;
                vcBuf = BufferUtils.createFloatBuffer(vcLen);
                for (i2 = 0; i2 < vcLen; ++i2) {
                    vcBuf.put(vertices[vo++]);
                }
                if ((command & 0xC00) == 1024) {
                    colorBuf = BufferUtils.createByteBuffer(3);
                    int color = colors[co];
                    colorBuf.put((byte)(color >> 16 & 0xFF));
                    colorBuf.put((byte)(color >> 8 & 0xFF));
                    colorBuf.put((byte)(color & 0xFF));
                    break;
                }
                if ((command & 0xC00) != 0) {
                    colorBuf = BufferUtils.createByteBuffer(vcLen);
                    for (i2 = 0; i2 < numPrimitives; ++i2) {
                        int color = colors[co++];
                        colorBuf.put((byte)(color >> 16 & 0xFF));
                        colorBuf.put((byte)(color >> 8 & 0xFF));
                        colorBuf.put((byte)(color & 0xFF));
                    }
                    break;
                }
                return;
            }
            case 0x2000000: {
                int i3;
                int vcLen = numPrimitives * 2 * 3;
                vcBuf = BufferUtils.createFloatBuffer(vcLen);
                for (i3 = 0; i3 < vcLen; ++i3) {
                    vcBuf.put(vertices[vo++]);
                }
                if ((command & 0xC00) == 1024) {
                    colorBuf = BufferUtils.createByteBuffer(3);
                    int color = colors[co];
                    colorBuf.put((byte)(color >> 16 & 0xFF));
                    colorBuf.put((byte)(color >> 8 & 0xFF));
                    colorBuf.put((byte)(color & 0xFF));
                    break;
                }
                if ((command & 0xC00) != 0) {
                    colorBuf = BufferUtils.createByteBuffer(vcLen);
                    for (i3 = 0; i3 < numPrimitives; ++i3) {
                        int color = colors[co++];
                        byte r = (byte)(color >> 16 & 0xFF);
                        byte g = (byte)(color >> 8 & 0xFF);
                        byte b2 = (byte)(color & 0xFF);
                        colorBuf.put(r).put(g).put(b2);
                        colorBuf.put(r).put(g).put(b2);
                    }
                    break;
                }
                return;
            }
            case 0x3000000: {
                int end;
                int i4;
                int vcLen = numPrimitives * 3 * 3;
                vcBuf = BufferUtils.createFloatBuffer(vcLen);
                for (i4 = 0; i4 < vcLen; ++i4) {
                    vcBuf.put(vertices[vo++]);
                }
                if ((command & 0x300) == 512) {
                    ncBuf = BufferUtils.createFloatBuffer(vcLen);
                    end = no + numPrimitives * 3;
                    while (no < end) {
                        float x = normals[no++];
                        float y = normals[no++];
                        float z = normals[no++];
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                    }
                } else if ((command & 0x300) == 768) {
                    ncBuf = BufferUtils.createFloatBuffer(vcLen);
                    end = no + vcLen;
                    while (no < end) {
                        ncBuf.put(normals[no++]);
                    }
                }
                if ((command & 0x3000) == 12288) {
                    if (this.env.getTexture() == null) {
                        return;
                    }
                    int tcLen = numPrimitives * 3 * 2;
                    tcBuf = BufferUtils.createByteBuffer(tcLen);
                    for (int i5 = 0; i5 < tcLen; ++i5) {
                        tcBuf.put((byte)textureCoords[to++]);
                    }
                    break;
                }
                if ((command & 0xC00) == 1024) {
                    colorBuf = BufferUtils.createByteBuffer(3);
                    int color = colors[co];
                    colorBuf.put((byte)(color >> 16 & 0xFF));
                    colorBuf.put((byte)(color >> 8 & 0xFF));
                    colorBuf.put((byte)(color & 0xFF));
                    break;
                }
                if ((command & 0xC00) != 0) {
                    colorBuf = BufferUtils.createByteBuffer(vcLen);
                    for (i4 = 0; i4 < numPrimitives; ++i4) {
                        int color = colors[co++];
                        byte r = (byte)(color >> 16 & 0xFF);
                        byte g = (byte)(color >> 8 & 0xFF);
                        byte b3 = (byte)(color & 0xFF);
                        colorBuf.put(r).put(g).put(b3);
                        colorBuf.put(r).put(g).put(b3);
                        colorBuf.put(r).put(g).put(b3);
                    }
                    break;
                }
                return;
            }
            case 0x4000000: {
                int pos;
                int offset;
                int i6;
                vcBuf = BufferUtils.createFloatBuffer(numPrimitives * 6 * 3);
                for (i6 = 0; i6 < numPrimitives; ++i6) {
                    pos = offset = vo + i6 * 4 * 3;
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos++]);
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos++]);
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos++]);
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos]);
                    pos = offset;
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos]);
                    pos = offset + 6;
                    vcBuf.put(vertices[pos++]).put(vertices[pos++]).put(vertices[pos]);
                }
                if ((command & 0x300) == 512) {
                    ncBuf = BufferUtils.createFloatBuffer(numPrimitives * 6 * 3);
                    int end = no + numPrimitives * 3;
                    while (no < end) {
                        float x = normals[no++];
                        float y = normals[no++];
                        float z = normals[no++];
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                        ncBuf.put(x).put(y).put(z);
                    }
                } else if ((command & 0x300) == 768) {
                    ncBuf = BufferUtils.createFloatBuffer(numPrimitives * 6 * 3);
                    for (i6 = 0; i6 < numPrimitives; ++i6) {
                        pos = offset = no + i6 * 4 * 3;
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos++]);
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos++]);
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos++]);
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos]);
                        pos = offset;
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos]);
                        pos = offset + 6;
                        ncBuf.put(normals[pos++]).put(normals[pos++]).put(normals[pos]);
                    }
                }
                if ((command & 0x3000) == 12288) {
                    if (this.env.getTexture() == null) {
                        return;
                    }
                    tcBuf = BufferUtils.createByteBuffer(numPrimitives * 6 * 2);
                    for (i6 = 0; i6 < numPrimitives; ++i6) {
                        int offset2;
                        int pos2 = offset2 = to + i6 * 4 * 2;
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2++]);
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2++]);
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2++]);
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2]);
                        pos2 = offset2;
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2]);
                        pos2 = offset2 + 4;
                        tcBuf.put((byte)textureCoords[pos2++]).put((byte)textureCoords[pos2]);
                    }
                    break;
                }
                if ((command & 0xC00) == 1024) {
                    colorBuf = BufferUtils.createByteBuffer(3);
                    int color = colors[co];
                    colorBuf.put((byte)(color >> 16 & 0xFF));
                    colorBuf.put((byte)(color >> 8 & 0xFF));
                    colorBuf.put((byte)(color & 0xFF));
                    break;
                }
                if ((command & 0xC00) != 0) {
                    colorBuf = BufferUtils.createByteBuffer(numPrimitives * 6 * 3);
                    for (i6 = 0; i6 < numPrimitives; ++i6) {
                        int color = colors[co++];
                        byte r = (byte)(color >> 16 & 0xFF);
                        byte g = (byte)(color >> 8 & 0xFF);
                        byte b4 = (byte)(color & 0xFF);
                        colorBuf.put(r).put(g).put(b4);
                        colorBuf.put(r).put(g).put(b4);
                        colorBuf.put(r).put(g).put(b4);
                        colorBuf.put(r).put(g).put(b4);
                        colorBuf.put(r).put(g).put(b4);
                        colorBuf.put(r).put(g).put(b4);
                    }
                    break;
                }
                return;
            }
            case 0x5000000: {
                if (this.env.getTexture() == null) {
                    return;
                }
                int psParams = command & 0x3000;
                if (psParams == 0) {
                    return;
                }
                float[] vertex = new float[24];
                vcBuf = BufferUtils.createFloatBuffer(numPrimitives * 6 * 4);
                tcBuf = BufferUtils.createByteBuffer(numPrimitives * 6 * 2);
                int angle = 0;
                float halfWidth = 0.0f;
                float halfHeight = 0.0f;
                byte tx0 = 0;
                byte ty0 = 0;
                byte tx1 = 0;
                byte ty1 = 0;
                MathUtil.multiplyMM(this.MVP_TMP, this.env.projMatrix, this.env.viewMatrix);
                for (int i7 = 0; i7 < numPrimitives; ++i7) {
                    vertex[4] = vertices[vo++];
                    vertex[5] = vertices[vo++];
                    vertex[6] = vertices[vo++];
                    vertex[7] = 1.0f;
                    Utils.multiplyMV(vertex, this.MVP_TMP);
                    if (psParams != 4096 || i7 == 0) {
                        float width = textureCoords[to++];
                        float height = textureCoords[to++];
                        angle = textureCoords[to++];
                        tx0 = (byte)textureCoords[to++];
                        ty0 = (byte)textureCoords[to++];
                        tx1 = (byte)(textureCoords[to++] - 1);
                        ty1 = (byte)(textureCoords[to++] - 1);
                        switch (textureCoords[to++]) {
                            case 0: {
                                halfWidth = width * this.env.projMatrix[0] * 0.5f;
                                halfHeight = height * this.env.projMatrix[5] * 0.5f;
                                break;
                            }
                            case 1: {
                                if (this.env.projection <= -1862270976) {
                                    halfWidth = width / (float)this.env.width;
                                    halfHeight = height / (float)this.env.height;
                                    break;
                                }
                                halfWidth = width / (float)this.env.width * this.env.near;
                                halfHeight = height / (float)this.env.height * this.env.near;
                                break;
                            }
                            case 2: {
                                if (this.env.projection <= -1862270976) {
                                    halfWidth = width * this.env.projMatrix[0] * 0.5f;
                                    halfHeight = height * this.env.projMatrix[5] * 0.5f;
                                    break;
                                }
                                float near = this.env.near;
                                halfWidth = width * this.env.projMatrix[0] / near * 0.5f * vertex[3];
                                halfHeight = height * this.env.projMatrix[5] / near * 0.5f * vertex[3];
                                break;
                            }
                            case 3: {
                                halfWidth = width / (float)this.env.width * vertex[3];
                                halfHeight = height / (float)this.env.height * vertex[3];
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    Utils.getSpriteVertex(vertex, angle, halfWidth, halfHeight);
                    vcBuf.put(vertex);
                    tcBuf.put(tx0).put(ty1);
                    tcBuf.put(tx0).put(ty0);
                    tcBuf.put(tx1).put(ty1);
                    tcBuf.put(tx1).put(ty1);
                    tcBuf.put(tx0).put(ty0);
                    tcBuf.put(tx1).put(ty0);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stack.add(new RenderNode.PrimitiveNode(this, command, vcBuf, ncBuf, tcBuf, colorBuf));
    }

    public synchronized void drawFigure(FigureImpl figure) {
        ++Profiler3D.MC3D_drawFigureCallCount;
        this.g3d.sync(() -> {
            if (!this.backCopied && this.preCopy2D) {
                this.copy2d(true);
            }
            Model model = figure.model;
            figure.prepareBuffers();
            this.flushStep = 1;
            for (RenderNode r : this.stack) {
                r.render(this);
            }
            this.renderFigure(model, this.env.textures, this.env.attrs, this.env.projMatrix, this.env.viewMatrix, model.vertexArray, model.normalsArray, this.env.light, this.env.specular, this.env.toonThreshold, this.env.toonHigh, this.env.toonLow);
            this.flushStep = 2;
            for (RenderNode r : this.stack) {
                r.render(this);
                r.recycle();
            }
            this.renderFigure(model, this.env.textures, this.env.attrs, this.env.projMatrix, this.env.viewMatrix, model.vertexArray, model.normalsArray, this.env.light, this.env.specular, this.env.toonThreshold, this.env.toonHigh, this.env.toonLow);
            GL20.glDisable(3042);
            GL20.glDepthMask(true);
            GL20.glClear(256);
        });
    }

    public void reset() {
        this.stack.clear();
    }

    public void setTexture(TextureImpl tex) {
        if (tex == null) {
            return;
        }
        this.env.textures[0] = tex;
        this.env.textureIdx = 0;
        this.env.texturesLen = 1;
    }

    public void setTextureArray(TextureImpl[] tex) {
        if (tex == null) {
            return;
        }
        int len = tex.length;
        System.arraycopy(tex, 0, this.env.textures, 0, len);
        this.env.texturesLen = len;
    }

    public float[] getViewMatrix() {
        return this.env.viewMatrix;
    }

    public void setLight(int ambIntensity, int dirIntensity, int x, int y, int z) {
        this.env.light.set(ambIntensity, dirIntensity, x, y, z);
    }

    public int getAttributes() {
        return this.env.attrs;
    }

    public void setToonParam(int tress, int high, int low) {
        this.env.toonThreshold = tress;
        this.env.toonHigh = high;
        this.env.toonLow = low;
    }

    public void setSphereTexture(TextureImpl tex) {
        if (tex != null) {
            this.env.specular = tex;
        }
    }

    public void setAttribute(int attrs) {
        this.env.attrs = attrs;
    }

    void renderPrimitive(RenderNode.PrimitiveNode node) {
        int blend;
        int command = node.command;
        int n = blend = (node.attrs & 8) != 0 ? (command & 0x60) >> 4 : 0;
        if (blend != 0 ? this.flushStep == 1 : this.flushStep == 2) {
            return;
        }
        MathUtil.multiplyMM(this.MVP_TMP, node.projMatrix, node.viewMatrix);
        GL20.glEnable(2929);
        GL20.glDepthFunc(513);
        GL20.glDepthMask(this.flushStep == 1);
        GL20.glDisable(2884);
        Render.applyBlending(blend);
        int numPrimitives = command >> 16 & 0xFF;
        switch (command & 0x7000000) {
            case 0x1000000: {
                this.renderMesh(node, 0);
                Render.checkGlError("renderPrimitive[PRIMITIVE_POINTS]");
                break;
            }
            case 0x2000000: {
                this.renderMesh(node, 1);
                Render.checkGlError("renderPrimitive[PRIMITIVE_LINES]");
                break;
            }
            case 0x3000000: 
            case 0x4000000: {
                if ((command & 0x3000) == 12288) {
                    this.renderMeshT(node);
                    break;
                }
                if ((command & 0xC00) == 0) break;
                this.renderMeshC(node);
                break;
            }
            case 0x5000000: {
                Program.Sprite program = Program.sprite;
                program.use();
                GL20.glVertexAttribPointer(program.aPosition, 4, 5126, false, 16, (FloatBuffer)node.vertices.rewind());
                GL20.glEnableVertexAttribArray(program.aPosition);
                GL20.glVertexAttribPointer(program.aColorData, 2, 5121, false, 2, (ByteBuffer)node.texCoords.rewind());
                GL20.glEnableVertexAttribArray(program.aColorData);
                program.setTexture(node.texture);
                GL20.glUniform1i(program.uIsTransparency, command & 0x10);
                GL20.glDrawArrays(4, 0, numPrimitives * 6);
                GL20.glDisableVertexAttribArray(program.aPosition);
                GL20.glDisableVertexAttribArray(program.aColorData);
                Render.checkGlError("renderPrimitive[PRIMITIVE_POINT_SPRITES]");
            }
        }
    }

    private void renderMesh(RenderNode.PrimitiveNode node, int type) {
        Program.Color program = Program.color;
        program.use();
        GL20.glVertexAttrib2f(program.aMaterial, 0.0f, 0.0f);
        program.bindMatrices(this.MVP_TMP, node.viewMatrix);
        GL20.glVertexAttribPointer(program.aPosition, 3, 5126, false, 12, (FloatBuffer)node.vertices.rewind());
        GL20.glEnableVertexAttribArray(program.aPosition);
        if ((node.command & 0xC00) == 1024) {
            program.setColor(node.colors);
        } else {
            GL20.glVertexAttribPointer(program.aColorData, 3, 5121, true, 3, (ByteBuffer)node.colors.rewind());
            GL20.glEnableVertexAttribArray(program.aColorData);
        }
        GL20.glDrawArrays(type, 0, node.vertices.capacity() / 3);
        GL20.glDisableVertexAttribArray(program.aPosition);
        GL20.glDisableVertexAttribArray(program.aColorData);
    }

    public void setOrthographicScale(int scaleX, int scaleY) {
        this.env.projection = -1879048192;
        float vw = this.env.width;
        float vh = this.env.height;
        float w = vw * (4096.0f / (float)scaleX);
        float h2 = vh * (4096.0f / (float)scaleY);
        float sx = 2.0f / w;
        float sy = 2.0f / h2;
        float sz = 1.5258789E-5f;
        float tx = 2.0f * (float)this.env.centerX / vw - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / vh - 1.0f;
        float tz = 0.0f;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = 0.0f;
        pm[12] = tx;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = 0.0f;
        pm[13] = ty;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 0.0f;
        pm[15] = 1.0f;
    }

    public void setOrthographicW(int w) {
        if (w <= 0) {
            return;
        }
        this.env.projection = -1862270976;
        float vw = this.env.width;
        float vh = this.env.height;
        float sx = 2.0f / (float)w;
        float sy = sx * (vw / vh);
        float sz = 1.5258789E-5f;
        float tx = 2.0f * (float)this.env.centerX / vw - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / vh - 1.0f;
        float tz = 0.0f;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = 0.0f;
        pm[12] = tx;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = 0.0f;
        pm[13] = ty;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 0.0f;
        pm[15] = 1.0f;
    }

    public void setOrthographicWH(int w, int h2) {
        if (w <= 0 || h2 <= 0) {
            return;
        }
        this.env.projection = -1862270976;
        float sx = 2.0f / (float)w;
        float sy = 2.0f / (float)h2;
        float sz = 1.5258789E-5f;
        float tx = 2.0f * (float)this.env.centerX / (float)this.env.width - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / (float)this.env.height - 1.0f;
        float tz = 0.0f;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = 0.0f;
        pm[12] = tx;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = 0.0f;
        pm[13] = ty;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 0.0f;
        pm[15] = 1.0f;
    }

    public void setPerspectiveFov(int near, int far, int angle) {
        if (near <= 0 || far <= 0 || near >= far) {
            return;
        }
        angle = MathUtil.clamp(angle, 2, 2046);
        this.env.projection = -1845493760;
        this.env.near = near;
        float rd = 1.0f / (float)(near - far);
        float sx = 1.0f / (float)Math.tan((double)((float)angle * 2.4414062E-4f) * Math.PI);
        float vw = this.env.width;
        float vh = this.env.height;
        float sy = sx * (vw / vh);
        float sz = (float)(-(far + near)) * rd;
        float tx = 2.0f * (float)this.env.centerX / vw - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / vh - 1.0f;
        float tz = 2.0f * (float)far * (float)near * rd;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = tx;
        pm[12] = 0.0f;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = ty;
        pm[13] = 0.0f;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 1.0f;
        pm[15] = 0.0f;
    }

    public void setPerspectiveW(int near, int far, int w) {
        if (near <= 0 || far <= 0 || near >= far || w <= 0) {
            return;
        }
        this.env.projection = -1828716544;
        this.env.near = near;
        float vw = this.env.width;
        float vh = this.env.height;
        float rd = 1.0f / (float)(near - far);
        float sx = 2.0f * (float)near / ((float)w * 2.4414062E-4f);
        float sy = sx * (vw / vh);
        float sz = (float)(-(near + far)) * rd;
        float tx = 2.0f * (float)this.env.centerX / vw - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / vh - 1.0f;
        float tz = 2.0f * (float)far * (float)near * rd;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = tx;
        pm[12] = 0.0f;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = ty;
        pm[13] = 0.0f;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 1.0f;
        pm[15] = 0.0f;
    }

    public void setPerspectiveWH(float near, float far, int w, int h2) {
        if (near <= 0.0f || far <= 0.0f || near >= far || w == 0 || h2 == 0) {
            return;
        }
        this.env.projection = -1828716544;
        this.env.near = near;
        float width = (float)w * 2.4414062E-4f;
        float height = (float)h2 * 2.4414062E-4f;
        float rd = 1.0f / (near - far);
        float sx = 2.0f * near / width;
        float sy = 2.0f * near / height;
        float sz = -(near + far) * rd;
        float tx = 2.0f * (float)this.env.centerX / (float)this.env.width - 1.0f;
        float ty = 2.0f * (float)this.env.centerY / (float)this.env.height - 1.0f;
        float tz = 2.0f * far * near * rd;
        float[] pm = this.env.projMatrix;
        pm[0] = sx;
        pm[4] = 0.0f;
        pm[8] = tx;
        pm[12] = 0.0f;
        pm[1] = 0.0f;
        pm[5] = sy;
        pm[9] = ty;
        pm[13] = 0.0f;
        pm[2] = 0.0f;
        pm[6] = 0.0f;
        pm[10] = sz;
        pm[14] = tz;
        pm[3] = 0.0f;
        pm[7] = 0.0f;
        pm[11] = 1.0f;
        pm[15] = 0.0f;
    }

    public void setViewTransArray(float[] matrices) {
        this.env.matrices = matrices;
    }

    private void selectAffineTrans(int n) {
        float[] matrices = this.env.matrices;
        if (matrices != null && matrices.length >= (n + 1) * 12) {
            System.arraycopy(matrices, n * 12, this.env.viewMatrix, 0, 12);
        }
    }

    public void setCenter(int cx, int cy) {
        this.env.centerX = cx;
        this.env.centerY = cy;
    }

    public void setClearColor(int color) {
        this.clearColor = color;
    }

    public synchronized void flushToBuffer() {
        ++Profiler3D.MC3D_flushCallCount;
        this.g3d.sync(() -> {
            if (this.stack.isEmpty()) {
                return;
            }
            try {
                this.copy2d(true);
                this.flushStep = 1;
                for (RenderNode r : this.stack) {
                    r.render(this);
                }
                this.flushStep = 2;
                for (RenderNode r : this.stack) {
                    r.render(this);
                    r.recycle();
                }
                GL20.glDisable(3042);
                GL20.glDepthMask(true);
                GL20.glClear(256);
                GL20.glFlush();
                if (this.targetTexture != null) {
                    GL20.glReadPixels(0, 0, 256, 256, 6408, 5121, this.targetTexture.image.getRaster());
                } else if (this.targetGraphics != null) {
                    this.swapBuffers();
                }
            }
            finally {
                this.stack.clear();
            }
        });
    }

    private void swapBuffers() {
        if (this.targetGraphics == null) {
            return;
        }
        Rectangle clip = this.clip;
        this.g3d.swapBuffers(true, clip.x, clip.y, clip.width, clip.height);
    }

    private static final class InstanceHolder {
        static final Render instance = new Render();

        private InstanceHolder() {
        }
    }

    static class Environment {
        final TextureImpl[] textures = new TextureImpl[16];
        final Light light = new Light();
        final float[] viewMatrix = new float[12];
        final float[] projMatrix = new float[16];
        int projection;
        float near;
        float[] matrices;
        int centerX;
        int centerY;
        int width;
        int height;
        int toonThreshold;
        int toonHigh;
        int toonLow;
        int attrs;
        int textureIdx;
        int texturesLen;
        TextureImpl specular;

        Environment() {
        }

        TextureImpl getTexture() {
            if (this.textureIdx < 0 || this.textureIdx >= this.texturesLen) {
                return null;
            }
            return this.textures[this.textureIdx];
        }
    }
}

