/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.FigureImpl;
import ru.woesss.j2me.micro3d.Light;
import ru.woesss.j2me.micro3d.Model;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureImpl;

abstract class RenderNode {
    final float[] viewMatrix = new float[12];
    final float[] projMatrix = new float[16];
    int attrs;
    Light light;
    TextureImpl specular;
    int toonHigh;
    int toonLow;
    int toonThreshold;

    RenderNode() {
    }

    void setData(Render render) {
        Render.Environment env = render.env;
        System.arraycopy(env.viewMatrix, 0, this.viewMatrix, 0, 12);
        System.arraycopy(env.projMatrix, 0, this.projMatrix, 0, 16);
        this.attrs = env.attrs;
        Light light = env.light;
        if (this.light == null) {
            this.light = new Light(light);
        } else {
            this.light.set(light.ambIntensity, light.dirIntensity, light.x, light.y, light.z);
        }
        this.specular = env.specular;
        this.toonHigh = env.toonHigh;
        this.toonLow = env.toonLow;
        this.toonThreshold = env.toonThreshold;
    }

    abstract void render(Render var1);

    void recycle() {
    }

    static final class PrimitiveNode
    extends RenderNode {
        final int command;
        final FloatBuffer vertices;
        final FloatBuffer normals;
        final ByteBuffer texCoords;
        final ByteBuffer colors;
        final TextureImpl texture;

        PrimitiveNode(Render render, int command, FloatBuffer vertices, FloatBuffer normals, ByteBuffer texCoords, ByteBuffer colors) {
            this.setData(render);
            Render.Environment env = render.env;
            this.texture = env.getTexture();
            this.command = command;
            this.vertices = vertices;
            this.normals = normals;
            this.texCoords = texCoords;
            this.colors = colors;
        }

        @Override
        void render(Render render) {
            render.renderPrimitive(this);
        }
    }

    static final class FigureNode
    extends RenderNode {
        TextureImpl[] textures;
        final FloatBuffer vertices;
        final FigureImpl figure;
        final FloatBuffer normals;

        FigureNode(Render render, FigureImpl figure) {
            this.figure = figure;
            Model model = figure.model;
            this.vertices = BufferUtils.createFloatBuffer(model.vertexArrayCapacity);
            this.normals = model.originalNormals != null ? BufferUtils.createFloatBuffer(model.vertexArrayCapacity) : null;
            this.setData(render);
        }

        @Override
        void setData(Render render) {
            super.setData(render);
            Render.Environment env = render.env;
            this.textures = new TextureImpl[env.texturesLen];
            System.arraycopy(env.textures, 0, this.textures, 0, env.texturesLen);
            this.figure.fillBuffers(this.vertices, this.normals);
        }

        @Override
        void render(Render render) {
            render.renderFigure(this.figure.model, this.textures, this.attrs, this.projMatrix, this.viewMatrix, this.vertices, this.normals, this.light, this.specular, this.toonThreshold, this.toonHigh, this.toonLow);
        }

        @Override
        void recycle() {
            this.figure.stack.push(this);
        }
    }
}

