/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.Settings;
import emulator.custom.ResourceManager;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.microedition.lcdui.Image;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import ru.woesss.j2me.micro3d.BufferUtils;
import ru.woesss.j2me.micro3d.Loader;
import ru.woesss.j2me.micro3d.Render;
import ru.woesss.j2me.micro3d.TextureData;

public final class TextureImpl {
    static int sLastId;
    public final TextureData image;
    private final boolean isMutable;
    int mTexId = -1;

    public TextureImpl() {
        this.image = new TextureData(256, 256);
        this.isMutable = true;
    }

    public TextureImpl(byte[] b2) {
        if (b2 == null) {
            throw new NullPointerException();
        }
        try {
            this.image = Loader.loadBmpData(b2, 0, b2.length);
        }
        catch (IOException e2) {
            System.err.println("Error loading data");
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
        this.isMutable = false;
    }

    public TextureImpl(byte[] b2, int offset, int length) throws IOException {
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > b2.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.image = Loader.loadBmpData(b2, offset, length);
        }
        catch (Exception e2) {
            System.err.println("Error loading data");
            e2.printStackTrace();
            throw e2;
        }
        this.isMutable = false;
    }

    public TextureImpl(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        byte[] b2 = ResourceManager.getBytes(name);
        if (b2 == null) {
            throw new IOException();
        }
        try {
            this.image = Loader.loadBmpData(b2, 0, b2.length);
        }
        catch (IOException e2) {
            System.err.println("Error loading data from [" + name + "]");
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
        this.isMutable = false;
    }

    public TextureImpl(Image image, int x, int y, int width, int height) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (x < 0 || y < 0 || width <= 0 || height <= 0 || x + width > image.getWidth() || y + height > image.getHeight()) {
            throw new IllegalArgumentException();
        }
        this.isMutable = false;
        this.image = new TextureData(width, height);
        int len = width * height;
        int[] pixels = new int[len];
        image.getRGB(pixels, 0, width, x, y, width, height);
        for (int i2 = 0; i2 < len; ++i2) {
            int pixel = pixels[i2];
            pixels[i2] = pixel << 8 | pixel >>> 24;
        }
        this.image.getRaster().asIntBuffer().put(pixels);
    }

    public void dispose() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    int getId() {
        if (!GL11.glIsTexture(this.mTexId)) {
            this.generateId();
        } else if (!this.isMutable) {
            return this.mTexId;
        }
        this.loadToGL();
        return this.mTexId;
    }

    public int getWidth() {
        return this.image.width;
    }

    public int getHeight() {
        return this.image.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateId() {
        IntBuffer textureIds = BufferUtils.createIntBuffer(1);
        Class<TextureImpl> clazz = TextureImpl.class;
        synchronized (TextureImpl.class) {
            while (textureIds.get(0) <= sLastId) {
                textureIds.rewind();
                GL11.glGenTextures(textureIds);
            }
            sLastId = textureIds.get(0);
            this.mTexId = textureIds.get(0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Render.checkGlError("glGenTextures");
            return;
        }
    }

    private void loadToGL() {
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, this.mTexId);
        boolean filter = Settings.mascotTextureFilter;
        GL11.glTexParameteri(3553, 10241, filter ? 9729 : 9728);
        GL11.glTexParameteri(3553, 10240, filter ? 9729 : 9728);
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        GL11.glTexImage2D(3553, 0, 6408, this.image.width, this.image.height, 0, 6408, 5121, this.image.getRaster());
        GL11.glBindTexture(3553, 0);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

