/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class SJIS_i
extends Charset {
    private static final float DECODER_EXPECT_CHAR_NUM_PER_BYTE = 0.5f;
    private static final float DECODER_MAX_CHAR_NUM_PAR_BYTE = 1.0f;
    private static final float ENCODER_EXPECT_CHAR_NUM_PER_BYTE = 2.0f;
    private static final float ENCODER_MAX_CHAR_NUM_PAR_BYTE = 2.0f;

    public SJIS_i() {
        super("SJIS_i", new String[]{"SJIS_i"});
    }

    @Override
    public final boolean contains(Charset charset) {
        return charset instanceof SJIS_i || charset.name().equals("SJIS_i");
    }

    @Override
    public final CharsetDecoder newDecoder() {
        return new SJIS_iDecoder(this);
    }

    @Override
    public final CharsetEncoder newEncoder() {
        return new SJIS_iEncoder(this);
    }

    private static class SJIS_iEncoder
    extends CharsetEncoder {
        private CharsetEncoder ms932Encoder;

        public SJIS_iEncoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            try {
                this.ms932Encoder = Charset.forName("MS932").newEncoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\u301c') {
                    cArray[i] = 65374;
                    continue;
                }
                if (cArray[i] == '\u2016') {
                    cArray[i] = 8741;
                    continue;
                }
                if (cArray[i] == '\u2212') {
                    cArray[i] = 65293;
                    continue;
                }
                if (cArray[i] == '\u00a2') {
                    cArray[i] = 65504;
                    continue;
                }
                if (cArray[i] == '\u00a3') {
                    cArray[i] = 65505;
                    continue;
                }
                if (cArray[i] != '\u00ac') continue;
                cArray[i] = 65506;
            }
            return this.ms932Encoder.encode(charBuffer, byteBuffer, false);
        }
    }

    private static class SJIS_iDecoder
    extends CharsetDecoder {
        private CharsetDecoder ms932Decoder;

        public SJIS_iDecoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
            try {
                this.ms932Decoder = Charset.forName("MS932").newDecoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult = this.ms932Decoder.decode(byteBuffer, charBuffer, false);
            char[] cArray = charBuffer.array();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\uff5e') {
                    cArray[i] = 12316;
                    continue;
                }
                if (cArray[i] == '\u2225') {
                    cArray[i] = 8214;
                    continue;
                }
                if (cArray[i] == '\uff0d') {
                    cArray[i] = 8722;
                    continue;
                }
                if (cArray[i] == '\uffe0') {
                    cArray[i] = 162;
                    continue;
                }
                if (cArray[i] == '\uffe1') {
                    cArray[i] = 163;
                    continue;
                }
                if (cArray[i] != '\uffe2') continue;
                cArray[i] = 172;
            }
            return coderResult;
        }
    }
}

