/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser.swingdirectory;

import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.runtime.filechooser.swingdirectory.JDirectoryChooser;
import com.install4j.runtime.filechooser.swingdirectory.LazyMutableTreeNode;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.ButtonBoxLayout;
import com.install4j.runtime.util.FileDrop;
import com.install4j.runtime.util.IconHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class JDirectoryChooserUI
extends BasicFileChooserUI {
    private static final Icon ICON_NEW_16 = IconHelper.loadIcon("folder_new_16.png");
    private static final boolean MANUAL = Boolean.getBoolean("manualDirectoryChooser");
    private static final String NA = "not available";
    private static TreeModel fileSystemTreeModel;
    private JDirectoryChooser chooser;
    private JTree tree;
    private JScrollPane treeScroll;
    private JButton approveButton;
    private JButton cancelButton;
    private JButton newFolderButton;
    private JPanel buttonPanel;
    private BasicFileChooserUI.BasicFileView fileView = new CommonFileView();
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action newFolderAction = new NewFolderAction();
    private boolean inSelectionChanged;
    private JPopupMenu popupMenu;

    public JDirectoryChooserUI(JDirectoryChooser chooser) {
        super(chooser);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        super.rescanCurrentDirectory(fc);
        this.findFile(this.chooser.getSelectedFile() == null ? this.chooser.getCurrentDirectory() : this.chooser.getSelectedFile(), true, true);
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        super.ensureFileIsVisible(fc, f);
        this.findFile(f, false, false);
    }

    @Override
    public void installComponents(JFileChooser chooser) {
        this.chooser = (JDirectoryChooser)chooser;
        chooser.setLayout(new BorderLayout(8, 0));
        chooser.setFileSelectionMode(1);
        JComponent accessory = chooser.getAccessory();
        if (accessory != null) {
            chooser.add("First", chooser.getAccessory());
        }
        this.tree = new JTree();
        int rowHeight = Math.max(UIManager.getFont("Tree.font").getSize() + 6, 18);
        this.tree.setRowHeight(rowHeight);
        this.tree.addTreeExpansionListener(new TreeExpansion());
        if (fileSystemTreeModel == null) {
            fileSystemTreeModel = new FileSystemTreeModel(chooser.getFileSystemView());
        }
        this.tree.setModel(fileSystemTreeModel);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new FileSystemTreeRenderer());
        this.tree.addMouseListener(new TreeMouseListener());
        FileDrop.addTo(this.tree, file -> {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            this.findFile(file, true, false);
        });
        this.treeScroll = new JScrollPane(this.tree);
        chooser.add("Center", this.treeScroll);
        this.treeScroll.setPreferredSize(new Dimension(300, 300));
        this.approveButton = this.createButton();
        this.approveButton.setName("ok");
        this.approveButton.setAction(this.getApproveSelectionAction());
        this.cancelButton = this.createButton();
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.cancelButton.setName("cancel");
        this.buttonPanel = new JPanel(new BorderLayout());
        GUIHelper.setEmptyBorder(this.buttonPanel, 8, 0, 0, 0);
        JPanel rightButtonPanel = new JPanel(new ButtonBoxLayout(6));
        rightButtonPanel.add(this.approveButton);
        rightButtonPanel.add(this.cancelButton);
        this.newFolderButton = new JButton(this.newFolderAction);
        this.newFolderButton.setIcon(null);
        JPanel leftButtonPanel = new JPanel(new ButtonBoxLayout(6));
        if (this.chooser.isAllowFolderCreation()) {
            leftButtonPanel.add(this.newFolderButton);
        }
        this.buttonPanel.add((Component)leftButtonPanel, "Before");
        this.buttonPanel.add((Component)rightButtonPanel, "After");
        chooser.add("Last", this.buttonPanel);
        this.updateView();
        this.initMultiSelection();
    }

    private JComponent getLowerAccessory() {
        return this.chooser.getLowerAccessory();
    }

    private JButton createButton() {
        return new JButton();
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
    }

    @Override
    public void uninstallComponents(JFileChooser chooser) {
        chooser.remove(this.treeScroll);
        chooser.remove(this.buttonPanel);
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.tree.addTreeSelectionListener(new SelectionListener());
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new ChangeListener();
    }

    private void updateView() {
        if (this.chooser.getApproveButtonText() != null) {
            this.approveButton.setText(this.chooser.getApproveButtonText());
            this.approveButton.setMnemonic(this.chooser.getApproveButtonMnemonic());
        } else if (0 == this.chooser.getDialogType()) {
            this.approveButton.setText(this.openButtonText);
            this.approveButton.setToolTipText(this.openButtonToolTipText);
            this.approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this.approveButton.setText(this.saveButtonText);
            this.approveButton.setToolTipText(this.saveButtonToolTipText);
            this.approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = this.chooser.getCancelButtonText() != null ? this.chooser.getCancelButtonText() : Messages.getString(".ButtonCancel");
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        JComponent lowerAccessory = this.getLowerAccessory();
        if (lowerAccessory != null) {
            lowerAccessory.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.buttonPanel.add((Component)lowerAccessory, "First");
        }
        this.buttonPanel.setVisible(this.chooser.getControlButtonsAreShown());
    }

    private void findFile(File fileToLocate, boolean selectFile, boolean reload) {
        File file;
        if (fileToLocate == null || !fileToLocate.isDirectory()) {
            return;
        }
        try {
            file = fileToLocate.getCanonicalFile();
        }
        catch (Exception e) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        while ((file = this.chooser.getFileSystemView().getParentDirectory(file)) != null) {
            files.add(0, file);
        }
        ArrayList<DefaultMutableTreeNode> path = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        path.add(node);
        boolean found = true;
        block3: while (files.size() > 0 && found) {
            found = false;
            int c = node.getChildCount();
            for (int i = 0; i < c; ++i) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)node.getChildAt(i);
                File f = ((FileTreeNode)current).getFile();
                if (!Objects.equals(files.get(0), f)) continue;
                path.add(current);
                files.remove(0);
                node = current;
                found = true;
                continue block3;
            }
        }
        TreePath pathToSelect = new TreePath(path.toArray());
        if (pathToSelect.getLastPathComponent() instanceof FileTreeNode && reload) {
            ((FileTreeNode)pathToSelect.getLastPathComponent()).clear();
        }
        if (selectFile) {
            this.tree.expandPath(pathToSelect);
            this.tree.setSelectionPath(pathToSelect);
        }
        this.scrollToPath(pathToSelect);
    }

    private void scrollToPath(TreePath path) {
        if (!this.tree.isVisible(path)) {
            int scrollHeight = this.inSelectionChanged && this.chooser.isDialogVisible() ? this.tree.getRowHeight() : 100;
            SwingUtilities.invokeLater(() -> {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                if (pathBounds != null) {
                    pathBounds.height = scrollHeight;
                    this.tree.scrollRectToVisible(pathBounds);
                }
            });
        }
    }

    public void focusTree() {
        this.tree.requestFocus();
    }

    private boolean getBooleanFileMethodValue(Method fileMethod, File file) {
        Boolean result = (Boolean)this.getFileMethodValue(fileMethod, file);
        if (result != null) {
            return result;
        }
        return false;
    }

    private Object getFileMethodValue(Method fileMethod, File file) {
        if (fileMethod != null) {
            try {
                return fileMethod.invoke((Object)this.chooser.getFileSystemView(), file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void scrollToSelection() {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            this.scrollToPath(path);
        }
    }

    private void initMultiSelection() {
        if (this.chooser.isMultiSelectionEnabled()) {
            this.tree.getSelectionModel().setSelectionMode(4);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void setSelectedFiles() {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null || selectedPaths.length == 0) {
            this.chooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (TreePath selectedPath : selectedPaths) {
            LazyMutableTreeNode node = (LazyMutableTreeNode)selectedPath.getLastPathComponent();
            if (!(node instanceof FileTreeNode)) continue;
            File f = ((FileTreeNode)node).getFile();
            files.add(f);
        }
        this.chooser.setSelectedFiles(files.toArray(new File[0]));
    }

    public void newFolderButtonClicked() {
        String folderName;
        TreePath[] paths = this.tree.getSelectionPaths();
        List<File> selection = this.getSelectedFolders(paths);
        if (selection.size() != 1) {
            return;
        }
        File parent = selection.get(0);
        do {
            folderName = JOptionPane.showInputDialog(this.chooser, MANUAL ? NA : Messages.getString(".DirectoryChooserLabel"), MANUAL ? NA : Messages.getString(".DirectoryChooserTitle"), 3);
        } while (folderName != null && (folderName = this.checkFolderEmpty(folderName)).length() == 0);
        if (folderName != null) {
            File newFolder = new File(parent, folderName);
            boolean success = newFolder.mkdir();
            assert (paths != null);
            TreePath parentPath = paths[0];
            boolean isExpanded = this.tree.isExpanded(parentPath);
            if (!isExpanded) {
                this.tree.expandPath(parentPath);
            }
            LazyMutableTreeNode parentTreeNode = (LazyMutableTreeNode)parentPath.getLastPathComponent();
            FileTreeNode child = this.createFileTreeNode(newFolder);
            if (success) {
                parentTreeNode.clear();
                int insertIndex = this.tree.getModel().getIndexOfChild(parentTreeNode, child);
                if (insertIndex != -1) {
                    ((FileSystemTreeModel)this.tree.getModel()).nodeStructureChanged(parentTreeNode);
                }
            }
            TreePath newPath = parentPath.pathByAddingChild(child);
            this.tree.setSelectionPath(newPath);
            this.tree.scrollPathToVisible(newPath);
        }
    }

    private String checkFolderEmpty(String folderName) {
        if ((folderName = folderName.trim()).length() == 0) {
            Util.showMessage(MANUAL ? NA : Messages.getString(".MustEnterGroupName"), 2);
        }
        return folderName;
    }

    private FileTreeNode createFileTreeNode(File file) {
        return new FileTreeNode(file);
    }

    private List<File> getSelectedFolders(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return new ArrayList<File>();
        }
        ArrayList<File> folders = new ArrayList<File>(paths.length);
        for (TreePath path : paths) {
            FileTreeNode f = (FileTreeNode)path.getLastPathComponent();
            folders.add(f.getFile());
        }
        return folders;
    }

    private class TreeMouseListener
    implements MouseListener {
        private TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.popup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.popup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.popup(e);
        }

        private void popup(MouseEvent e) {
            if (e.isPopupTrigger() && this.isPointInLabel(e)) {
                JDirectoryChooserUI.this.tree.setSelectionPath(JDirectoryChooserUI.this.tree.getPathForLocation(e.getX(), e.getY()));
                if (JDirectoryChooserUI.this.popupMenu == null) {
                    JDirectoryChooserUI.this.popupMenu = new JPopupMenu();
                    JDirectoryChooserUI.this.popupMenu.add(JDirectoryChooserUI.this.newFolderAction);
                }
                JDirectoryChooserUI.this.popupMenu.show(JDirectoryChooserUI.this.tree, e.getX(), e.getY());
            }
        }

        private boolean isPointInLabel(MouseEvent e) {
            TreePath path = JDirectoryChooserUI.this.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return false;
            }
            int row = JDirectoryChooserUI.this.tree.getRowForLocation(e.getX(), e.getY());
            Rectangle bounds = JDirectoryChooserUI.this.tree.getRowBounds(row);
            Point point = e.getPoint();
            point.translate(-bounds.x, -bounds.y);
            return point.x > 0;
        }
    }

    protected class CommonFileView
    extends BasicFileChooserUI.BasicFileView {
        protected CommonFileView() {
            super(JDirectoryChooserUI.this);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            if (f != null) {
                icon = JDirectoryChooserUI.this.chooser.getFileSystemView().getSystemIcon(f);
            }
            if (icon == null) {
                icon = super.getIcon(f);
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class FileTreeNode
    extends LazyMutableTreeNode
    implements Comparable {
        private FileTreeNode(File file) {
            super(file);
        }

        public boolean canEnqueue() {
            return !this.isLoaded() && !this.isFloppyDrive() && !this.isFileSystemRoot();
        }

        private boolean isFileSystemRoot() {
            return JDirectoryChooserUI.this.chooser.getFileSystemView().isFileSystemRoot(this.getFile());
        }

        private boolean isFloppyDrive() {
            return JDirectoryChooserUI.this.chooser.getFileSystemView().isFloppyDrive(this.getFile());
        }

        @Override
        public boolean isLeaf() {
            return this.isLoaded() && super.isLeaf();
        }

        @Override
        protected void loadChildren() {
            FileTreeNode[] nodes;
            for (FileTreeNode node : nodes = this.getChildren()) {
                this.add(node);
            }
        }

        private FileTreeNode[] getChildren() {
            File[] files = null;
            try {
                files = JDirectoryChooserUI.this.chooser.getFileSystemView().getFiles(this.getFile(), JDirectoryChooserUI.this.chooser.isFileHidingEnabled());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ArrayList<FileTreeNode> nodes = new ArrayList<FileTreeNode>();
            if (files != null) {
                for (File file : files) {
                    if (InstallerUtil.isWindows() && file.getName().endsWith(".lnk") || !file.isDirectory()) continue;
                    nodes.add(JDirectoryChooserUI.this.createFileTreeNode(file));
                }
            }
            Object[] result = nodes.toArray(new FileTreeNode[0]);
            Arrays.sort(result);
            return result;
        }

        public File getFile() {
            return (File)this.getUserObject();
        }

        @Override
        public String toString() {
            String name = JDirectoryChooserUI.this.chooser.getFileSystemView().getSystemDisplayName((File)this.getUserObject());
            if (name != null) {
                return name;
            }
            return super.toString();
        }

        public String getSortKey() {
            File file = (File)this.getUserObject();
            FileSystemView fileSystemView = JDirectoryChooserUI.this.chooser.getFileSystemView();
            if (fileSystemView.isDrive(file)) {
                return file.getName();
            }
            return fileSystemView.getSystemDisplayName((File)this.getUserObject());
        }

        public int compareTo(@NotNull Object o) {
            if (!(o instanceof FileTreeNode)) {
                return 1;
            }
            return this.getSortKey().compareToIgnoreCase(((FileTreeNode)o).getSortKey());
        }

        @Override
        public void clear() {
            super.clear();
            ((DefaultTreeModel)JDirectoryChooserUI.this.tree.getModel()).nodeStructureChanged(this);
        }
    }

    private class MyComputerTreeNode
    extends LazyMutableTreeNode {
        public MyComputerTreeNode(FileSystemView fsv) {
            super(fsv);
        }

        @Override
        protected void loadChildren() {
            FileSystemView fsv = (FileSystemView)this.getUserObject();
            Object[] roots = fsv.getRoots();
            if (roots != null) {
                Arrays.sort(roots);
                for (Object root : roots) {
                    this.add(JDirectoryChooserUI.this.createFileTreeNode((File)root));
                }
            }
        }

        @Override
        public String toString() {
            return "/";
        }
    }

    private class FileSystemTreeModel
    extends DefaultTreeModel {
        public FileSystemTreeModel(FileSystemView fsv) {
            super(new DefaultMutableTreeNode());
            this.setRoot(new MyComputerTreeNode(fsv));
            this.setAsksAllowsChildren(false);
        }
    }

    private class FileSystemTreeRenderer
    extends DefaultTreeCellRenderer {
        private FileSystemTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, false, row, UiUtil.getLookAndFeelEnhancer().isWideTreeSelection() ? false : hasFocus);
            if (value instanceof FileTreeNode) {
                FileTreeNode node = (FileTreeNode)value;
                this.setText(JDirectoryChooserUI.this.getFileView(JDirectoryChooserUI.this.chooser).getName(node.getFile()));
                if (!InstallerUtil.isMacOS() || !UIManager.getLookAndFeel().isNativeLookAndFeel()) {
                    this.setIcon(JDirectoryChooserUI.this.getFileView(JDirectoryChooserUI.this.chooser).getIcon(node.getFile()));
                }
            }
            return this;
        }
    }

    private class TreeExpansion
    implements TreeExpansionListener {
        private TreeExpansion() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            Object lastElement;
            if (event.getPath() != null && (lastElement = event.getPath().getLastPathComponent()) instanceof FileTreeNode) {
                FileTreeNode node = (FileTreeNode)lastElement;
                node.clear();
                ((FileSystemTreeModel)JDirectoryChooserUI.this.tree.getModel()).nodeStructureChanged(node);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        public NewFolderAction() {
            this.setEnabled(false);
            this.putValue("Name", MANUAL ? JDirectoryChooserUI.NA : Messages.getString(".DirectoryChooserTooltip"));
            this.putValue("SmallIcon", ICON_NEW_16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDirectoryChooserUI.this.newFolderButtonClicked();
        }
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        public ApproveSelectionAction() {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDirectoryChooserUI.this.setSelectedFiles();
            JDirectoryChooserUI.this.chooser.approveSelection();
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            boolean directorySelected = this.isDirectorySelected();
            JDirectoryChooserUI.this.getApproveSelectionAction().setEnabled(directorySelected);
            JDirectoryChooserUI.this.newFolderAction.setEnabled(directorySelected);
            JDirectoryChooserUI.this.inSelectionChanged = true;
            try {
                JDirectoryChooserUI.this.setSelectedFiles();
            }
            finally {
                JDirectoryChooserUI.this.inSelectionChanged = false;
            }
        }

        private boolean isDirectorySelected() {
            if (JDirectoryChooserUI.this.tree.getSelectionCount() > 0) {
                TreePath[] selectionPaths = JDirectoryChooserUI.this.tree.getSelectionPaths();
                assert (selectionPaths != null);
                Object node = selectionPaths[0].getLastPathComponent();
                if (node instanceof FileTreeNode && ((FileTreeNode)node).getFile().isDirectory()) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (Objects.equals("ApproveButtonTextChangedProperty", evt.getPropertyName()) || Objects.equals("lowerAccessory", evt.getPropertyName())) {
                JDirectoryChooserUI.this.updateView();
            }
            if (Objects.equals("MultiSelectionEnabledChangedProperty", evt.getPropertyName())) {
                JDirectoryChooserUI.this.initMultiSelection();
            }
            if (Objects.equals("directoryChanged", evt.getPropertyName())) {
                JDirectoryChooserUI.this.findFile(JDirectoryChooserUI.this.chooser.getCurrentDirectory(), false, false);
            }
            if (Objects.equals("AccessoryChangedProperty", evt.getPropertyName())) {
                Component oldValue = (Component)evt.getOldValue();
                Component newValue = (Component)evt.getNewValue();
                if (oldValue != null) {
                    JDirectoryChooserUI.this.chooser.remove(oldValue);
                }
                if (newValue != null) {
                    JDirectoryChooserUI.this.chooser.add("First", newValue);
                }
                JDirectoryChooserUI.this.chooser.revalidate();
                JDirectoryChooserUI.this.chooser.repaint();
            }
            if (Objects.equals("ControlButtonsAreShownChangedProperty", evt.getPropertyName())) {
                JDirectoryChooserUI.this.updateView();
            }
        }
    }
}

