/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class KEmulatorUpdater
implements Runnable {
    private static final String VERSION = "0.4";
    private static final String UPDATE_URL = "https://nnproject.cc/kem/releases/";
    private static KEmulatorUpdater inst;
    private static JFrame frame;
    private static JProgressBar progressBar;
    private static JLabel label;
    private static Path kemulatorDir;
    private static Path kemulatorJar;
    private static int currentVersion;
    private static boolean x64;
    private static String type;
    private static String branch;
    private static boolean runAfterDone;
    private static boolean installed;
    private static String jar;
    private static String jad;

    public static void main(String[] args) {
        kemulatorDir = Paths.get(".", new String[0]);
        try {
            block56: {
                block55: {
                    block48: for (int i = 0; i < args.length; ++i) {
                        if (!args[i].startsWith("-")) continue;
                        switch (args[i]) {
                            case "-dir": {
                                kemulatorDir = Paths.get(args[++i], new String[0]);
                                continue block48;
                            }
                            case "-currentVersion": {
                                currentVersion = Integer.parseInt(args[++i]);
                                continue block48;
                            }
                            case "-type": {
                                type = args[++i];
                                x64 = "x64".equals(type);
                                continue block48;
                            }
                            case "-branch": {
                                branch = args[++i];
                                continue block48;
                            }
                            case "-run": {
                                runAfterDone = true;
                                continue block48;
                            }
                            case "-installed": {
                                installed = true;
                                continue block48;
                            }
                            case "-jar": {
                                jar = args[++i];
                                continue block48;
                            }
                            case "-jad": {
                                jad = args[++i];
                            }
                        }
                    }
                    if (currentVersion == 0 || type == null) {
                        KEmulatorUpdater.fail("Not enough arguments", null);
                        KEmulatorUpdater.exitDelay(0L);
                        return;
                    }
                    inst = new KEmulatorUpdater();
                    EventQueue.invokeAndWait(inst);
                    KEmulatorUpdater.state("KEmulator Updater v0.4");
                    Thread.sleep(1000L);
                    kemulatorJar = kemulatorDir.resolve("KEmulator.jar");
                    KEmulatorUpdater.state("Obtaining latest version info");
                    try {
                        if ("stable".equals(branch)) {
                            int latest = Integer.parseInt(KEmulatorUpdater.getHttpString(UPDATE_URL + branch + "/version.txt"));
                            if (latest != currentVersion) break block55;
                            KEmulatorUpdater.state("Already up to date!");
                            Thread.sleep(3000L);
                            break block56;
                        }
                        String latest = KEmulatorUpdater.getHttpString(UPDATE_URL + branch + "/version.mf");
                    }
                    catch (Exception e) {
                        KEmulatorUpdater.fail("Failed to get latest version info", e);
                        return;
                    }
                }
                KEmulatorUpdater.state("Deleting KEmulator.jar");
                try {
                    if (Files.exists(kemulatorJar, new LinkOption[0])) {
                        Files.delete(kemulatorJar);
                    }
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to delete KEmulator.jar", e);
                    return;
                }
                if (!x64) {
                    KEmulatorUpdater.state("Deleting 3d engines");
                    try {
                        Files.delete(kemulatorDir.resolve("m3g_lwjgl.jar"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        Files.delete(kemulatorDir.resolve("m3g_swerve.jar"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        Files.delete(kemulatorDir.resolve("micro3d_gl.jar"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        Files.delete(kemulatorDir.resolve("micro3d_dll.jar"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    KEmulatorUpdater.state("Downloading KEmulator.jar");
                    KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + (x64 ? "/KEmulator_x64.jar" : "/KEmulator.jar"), kemulatorJar);
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to download KEmulator.jar", e);
                    return;
                }
                Path tempZip = Files.createTempFile(null, ".zip", new FileAttribute[0]);
                try {
                    KEmulatorUpdater.state("Downloading lang.zip");
                    KEmulatorUpdater.download(UPDATE_URL + branch + "/lang.zip", tempZip);
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to download lang.zip", e);
                    return;
                }
                try {
                    KEmulatorUpdater.state("Extracting lang.zip");
                    KEmulatorUpdater.extract(tempZip, kemulatorDir.resolve("lang"));
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to extract lang.zip", e);
                    return;
                }
                if (!x64) {
                    try {
                        KEmulatorUpdater.state("Downloading m3g_lwjgl.jar");
                        KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + "/m3g_lwjgl.jar", kemulatorDir.resolve("m3g_lwjgl.jar"));
                        KEmulatorUpdater.state("Downloading m3g_swerve.jar");
                        KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + "/m3g_swerve.jar", kemulatorDir.resolve("m3g_swerve.jar"));
                        KEmulatorUpdater.state("Downloading micro3d_gl.jar");
                        KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + "/micro3d_gl.jar", kemulatorDir.resolve("micro3d_gl.jar"));
                        KEmulatorUpdater.state("Downloading micro3d_dll.jar");
                        KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + "/micro3d_dll.jar", kemulatorDir.resolve("micro3d_dll.jar"));
                        KEmulatorUpdater.state("Downloading amrdecoder.dll");
                        KEmulatorUpdater.download(UPDATE_URL + branch + "/" + type + "/amrdecoder.dll", kemulatorDir.resolve("amrdecoder.dll"));
                    }
                    catch (IOException e) {
                        KEmulatorUpdater.fail("Failed to download libraries", e);
                        return;
                    }
                }
                try {
                    KEmulatorUpdater.state("Downloading lwjgl.zip");
                    KEmulatorUpdater.download(UPDATE_URL + branch + "/lwjgl.zip", tempZip);
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to download lwjgl.zip", e);
                    return;
                }
                try {
                    KEmulatorUpdater.state("Extracting lwjgl.zip");
                    KEmulatorUpdater.extract(tempZip, kemulatorDir);
                }
                catch (IOException e) {
                    KEmulatorUpdater.fail("Failed to extract lwjgl.zip", e);
                    return;
                }
                KEmulatorUpdater.state("Update done");
            }
            if (!runAfterDone) {
                KEmulatorUpdater.exitDelay(1000L);
                return;
            }
            try {
                KEmulatorUpdater.start();
            }
            catch (Exception e) {
                KEmulatorUpdater.fail("Failed to run KEmulator", e);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            KEmulatorUpdater.log(e);
        }
        KEmulatorUpdater.exitDelay(3000L);
    }

    @Override
    public void run() {
        frame = new JFrame();
        frame.setTitle("KEmulator Updater");
        frame.setBounds(100, 100, 320, 100);
        frame.setDefaultCloseOperation(0);
        progressBar = new JProgressBar();
        progressBar.setPreferredSize(new Dimension(-1, 20));
        progressBar.setIndeterminate(true);
        frame.getContentPane().add((Component)progressBar, "South");
        JPanel panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(0);
        frame.getContentPane().add((Component)panel, "Center");
        label = new JLabel("");
        panel.add(label);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    static void start() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        String os = System.getProperty("os.name").toLowerCase();
        Path javaExe = kemulatorDir.resolve("jre").resolve("bin").resolve("java.exe");
        if (Files.exists(javaExe, new LinkOption[0])) {
            cmd.add(javaExe.toString());
        } else {
            String javahome = System.getProperty("java.home");
            boolean win = os.startsWith("win");
            cmd.add(javahome == null || javahome.isEmpty() ? "java" : javahome + "/bin/java" + (win ? ".exe" : ""));
        }
        cmd.add("-cp");
        cmd.add(kemulatorJar.toString());
        cmd.add("-Xmx512M");
        if ("false".equals(System.getProperty("sun.java3d.d3d"))) {
            cmd.add("-Dsun.java3d.d3d=false");
        }
        if (os.startsWith("darwin") || os.startsWith("mac os")) {
            cmd.add("-XstartOnFirstThread");
        }
        cmd.add("-Djava.library.path=" + kemulatorDir.toString());
        cmd.add("-Dfile.encoding=UTF-8");
        cmd.add("-javaagent:" + kemulatorJar.toString());
        if (KEmulatorUpdater.getJavaVersionMajor() >= 9) {
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang.reflect=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.lang.ref=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.io=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.util=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/sun.misc=ALL-UNNAMED");
            if (KEmulatorUpdater.getJavaVersionMajor() >= 17) {
                cmd.add("--enable-native-access=ALL-UNNAMED");
            }
        }
        cmd.add("emulator.Emulator");
        cmd.add("-s");
        cmd.add("-updated");
        if (installed) {
            cmd.add("-installed");
        }
        if (jar != null) {
            cmd.add("-jar");
            cmd.add(jar);
        }
        if (jad != null) {
            cmd.add("-jad");
            cmd.add(jad);
        }
        new ProcessBuilder(new String[0]).directory(kemulatorDir.toFile()).command(cmd).start();
        System.exit(0);
    }

    private static void fail(String message, Throwable exception) {
        KEmulatorUpdater.state(message);
        if (exception != null) {
            KEmulatorUpdater.log(exception);
        }
        KEmulatorUpdater.exitDelay(3000L);
    }

    private static void exitDelay(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    static void state(String message) {
        if (label != null) {
            label.setText(message);
        }
        KEmulatorUpdater.log(message, true);
    }

    static void log(Throwable exception) {
        String res = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(baos));
            res = baos.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (res == null) {
            return;
        }
        KEmulatorUpdater.log(res, true);
    }

    static void log(String text, boolean show) {
        System.out.println(text);
    }

    static int getJavaVersionMajor() {
        try {
            return Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void download(String url, Path path) throws IOException {
        ReadableByteChannel inChannel = null;
        FileOutputStream fileStream = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            inChannel = Channels.newChannel(KEmulatorUpdater.getHttpStream(url));
            fileStream = new FileOutputStream(path.toFile());
            fileChannel = fileStream.getChannel();
            ((FileChannel)fileChannel).transferFrom(inChannel, 0L, Long.MAX_VALUE);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileStream != null) {
                fileStream.close();
            }
        }
    }

    static String getHttpString(String url) throws IOException {
        return new String(KEmulatorUpdater.getHttpBytes(url), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getHttpBytes(String url) throws IOException {
        try (InputStream inputStream = null;){
            int read;
            inputStream = KEmulatorUpdater.getHttpStream(url);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[16384];
            while ((read = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    static InputStream getHttpStream(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", "KEmulatorUpdater/0.4");
        connection.setRequestProperty("Accept-Encoding", "gzip");
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            throw new FileNotFoundException(url);
        }
        InputStream inputStream = connection.getInputStream();
        if (inputStream == null) {
            throw new IOException("No input stream");
        }
        String encoding = connection.getContentEncoding();
        if ("gzip".equalsIgnoreCase(encoding)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extract(Path archive, Path outDir) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(archive, new OpenOption[0]));
        ReadableByteChannel inChannel = Channels.newChannel(zipStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                String name = zipEntry.getName();
                boolean isDir = zipEntry.isDirectory();
                Path path = outDir.resolve(name);
                if (isDir) {
                    if (!Files.notExists(path, new LinkOption[0])) continue;
                    Files.createDirectory(path, new FileAttribute[0]);
                    continue;
                }
                try (FileOutputStream fileStream = new FileOutputStream(path.toFile());){
                    fileStream.getChannel().transferFrom(inChannel, 0L, Long.MAX_VALUE);
                }
            }
        }
        finally {
            zipStream.close();
            inChannel.close();
        }
    }

    static {
        branch = "stable";
    }
}

