/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.ContextThreadFrameListener;
import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoFrame;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.Utils;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class ContextThreadFrame {
    private final List<Reference<ContextThreadFrameListener>> _listeners = new ArrayList<Reference<ContextThreadFrameListener>>();
    private volatile InfoThread _thread;
    private volatile InfoFrame _frame;
    private volatile FrameLocation _location;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ContextThreadFrameListener __listener) throws NullPointerException {
        if (__listener == null) {
            throw new NullPointerException("NARG");
        }
        List<Reference<ContextThreadFrameListener>> listeners = this._listeners;
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            listeners.add(new WeakReference<ContextThreadFrameListener>(__listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(InfoThread __thread) {
        FrameLocation oldLocation;
        InfoFrame oldFrame;
        InfoThread oldThread;
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            if (!Objects.equals(this._thread, __thread)) {
                return;
            }
            oldThread = this._thread;
            this._thread = null;
            oldFrame = this._frame;
            this._frame = null;
            oldLocation = this._location;
            this._location = null;
        }
        this.__contextChanged(oldThread, oldFrame, oldLocation, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropFrame(InfoThread __thread) {
        FrameLocation oldLocation;
        InfoFrame oldFrame;
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            if (!Objects.equals(this._thread, __thread)) {
                return;
            }
            oldFrame = this._frame;
            this._frame = null;
            oldLocation = this._location;
            this._location = null;
        }
        this.__contextChanged(__thread, oldFrame, oldLocation, __thread, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoFrame getFrame() {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            return this._frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameLocation getLocation() {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            return this._location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoThread getThread() {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            return this._thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optional(InfoThread __thread) {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            if (this._thread == null && __thread != null) {
                this.set(__thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optional(InfoFrame __frame) {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            if (this._frame == null && __frame != null) {
                this.set(__frame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optional(FrameLocation __location) {
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            if (this._location == null && __location != null) {
                this.set(__location);
            }
        }
    }

    public void set(DebuggerState __state, InfoThread __thread) throws NullPointerException {
        if (__state == null) {
            throw new NullPointerException("NARG");
        }
        if (__thread != null) {
            this.set(__thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(InfoThread __thread) {
        FrameLocation newLocation;
        InfoFrame newFrame;
        InfoThread newThread;
        FrameLocation oldLocation;
        InfoFrame oldFrame;
        InfoThread oldThread;
        if (__thread != null && (__thread.isDisposed() || __thread.isDead.getOrDefault(false).booleanValue())) {
            return;
        }
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            InfoFrame[] possible;
            oldThread = this._thread;
            oldFrame = this._frame;
            oldLocation = this._location;
            newThread = __thread;
            newFrame = !(newThread == null || oldFrame != null && Objects.equals(oldFrame.inThread, newThread)) ? ((possible = newThread.frames.get()) != null && possible.length > 0 ? possible[0] : null) : oldFrame;
            newLocation = newFrame != null ? newFrame.location : null;
            this._thread = newThread;
            this._frame = newFrame;
            this._location = newLocation;
        }
        this.__contextChanged(oldThread, oldFrame, oldLocation, newThread, newFrame, newLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(InfoFrame __frame) {
        FrameLocation newLocation;
        InfoFrame newFrame;
        InfoThread newThread;
        FrameLocation oldLocation;
        InfoFrame oldFrame;
        InfoThread oldThread;
        InfoThread wantThread;
        if (__frame != null && __frame.isDisposed()) {
            return;
        }
        InfoThread infoThread = wantThread = __frame != null ? __frame.inThread : null;
        if (wantThread != null && (wantThread.isDisposed() || wantThread.isDead.getOrDefault(false).booleanValue())) {
            return;
        }
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            oldThread = this._thread;
            oldFrame = this._frame;
            oldLocation = this._location;
            if (__frame != null) {
                newThread = wantThread;
                newFrame = __frame;
                newLocation = __frame.location;
            } else {
                newThread = null;
                newFrame = null;
                newLocation = null;
            }
            this._thread = newThread;
            this._frame = newFrame;
            this._location = newLocation;
        }
        this.__contextChanged(oldThread, oldFrame, oldLocation, newThread, newFrame, newLocation);
    }

    public void set(FrameLocation __location) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __contextChanged(InfoThread __oldThread, InfoFrame __oldFrame, FrameLocation __oldLocation, InfoThread __newThread, InfoFrame __newFrame, FrameLocation __newLocation) {
        ArrayList<ContextThreadFrameListener> listeners;
        if (Objects.equals(__oldThread, __newThread) && Objects.equals(__oldFrame, __newFrame) && Objects.equals(__oldLocation, __newLocation)) {
            return;
        }
        Debugging.debugNote("Context: (%s, %s) -> (%s, %s)", __oldThread, __oldFrame, __newThread, __newFrame);
        List<Reference<ContextThreadFrameListener>> list = this._listeners;
        ContextThreadFrame contextThreadFrame = this;
        synchronized (contextThreadFrame) {
            listeners = new ArrayList<ContextThreadFrameListener>(list.size());
            Iterator<Reference<ContextThreadFrameListener>> it = list.iterator();
            while (it.hasNext()) {
                Reference<ContextThreadFrameListener> ref = it.next();
                ContextThreadFrameListener item = ref.get();
                if (item == null) {
                    it.remove();
                    continue;
                }
                listeners.add(item);
            }
        }
        Utils.swingInvoke(() -> {
            for (ContextThreadFrameListener listener : listeners) {
                listener.contextChanged(__oldThread, __oldFrame, __oldLocation, __newThread, __newFrame, __newLocation);
            }
        });
    }
}

