/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.AwaitingReplies;
import cc.squirreljme.debugger.AwaitingReply;
import cc.squirreljme.debugger.CapabilityStatus;
import cc.squirreljme.debugger.ContextThreadFrame;
import cc.squirreljme.debugger.EventHandler;
import cc.squirreljme.debugger.EventHandlers;
import cc.squirreljme.debugger.EventModifier;
import cc.squirreljme.debugger.EventModifierClassMatch;
import cc.squirreljme.debugger.EventModifierCount;
import cc.squirreljme.debugger.EventModifierSingleStep;
import cc.squirreljme.debugger.EventProcessor;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.FrameLocationInterpret;
import cc.squirreljme.debugger.InfoClass;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.KnownValue;
import cc.squirreljme.debugger.KnownValueCallback;
import cc.squirreljme.debugger.PacketDefer;
import cc.squirreljme.debugger.Preferences;
import cc.squirreljme.debugger.ReplyHandler;
import cc.squirreljme.debugger.SingleStepEvent;
import cc.squirreljme.debugger.StoredInfo;
import cc.squirreljme.debugger.StoredInfoManager;
import cc.squirreljme.debugger.TallyTracker;
import cc.squirreljme.jdwp.JDWPCommLink;
import cc.squirreljme.jdwp.JDWPCommand;
import cc.squirreljme.jdwp.JDWPCommandSet;
import cc.squirreljme.jdwp.JDWPCommandSetEventRequest;
import cc.squirreljme.jdwp.JDWPCommandSetThreadReference;
import cc.squirreljme.jdwp.JDWPCommandSetVirtualMachine;
import cc.squirreljme.jdwp.JDWPErrorType;
import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPException;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPIdSizeUnknownException;
import cc.squirreljme.jdwp.JDWPIdSizes;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPStepDepth;
import cc.squirreljme.jdwp.JDWPStepSize;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.io.HexDumpOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.multiphasicapps.classfile.ClassName;

public class DebuggerState
implements Runnable {
    protected final JDWPCommLink commLink;
    protected final TallyTracker disconnectedTally = new TallyTracker();
    protected final TallyTracker receiveTally = new TallyTracker();
    protected final TallyTracker sentTally = new TallyTracker();
    protected final TallyTracker waitingTally = new TallyTracker();
    protected final TallyTracker latency = new TallyTracker();
    protected final TallyTracker vmDeadTally = new TallyTracker();
    protected final CapabilityStatus capabilities = new CapabilityStatus();
    protected final StoredInfoManager storedInfo = new StoredInfoManager();
    protected final ContextThreadFrame context = new ContextThreadFrame();
    protected final EventHandlers eventHandlers = new EventHandlers();
    protected final PacketDefer defer = new PacketDefer();
    protected final AwaitingReplies replies = new AwaitingReplies();
    protected final Consumer<DebuggerState> ready;
    protected final Preferences preferences;
    private volatile boolean _hasStarted;
    volatile FrameLocationInterpret _locationInterpret = FrameLocationInterpret.ADDRESS;

    public DebuggerState(JDWPCommLink __commLink, Preferences __preferences, Consumer<DebuggerState> __ready) throws NullPointerException {
        if (__commLink == null || __preferences == null) {
            throw new NullPointerException("NARG");
        }
        this.commLink = __commLink;
        this.preferences = __preferences;
        this.ready = __ready;
    }

    public void allThreads(Consumer<InfoThread[]> __callback) throws NullPointerException {
        if (__callback == null) {
            throw new NullPointerException("NARG");
        }
        try (JDWPPacket out = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.ALL_THREADS);){
            this.send(out, (__state, __reply) -> {
                int numThreads = __reply.readInt();
                StoredInfo<InfoThread> stored = __state.storedInfo.getThreads();
                Object[] threads = new InfoThread[numThreads];
                for (int i2 = 0; i2 < numThreads; ++i2) {
                    JDWPId thread = __reply.readId(JDWPIdKind.THREAD_ID);
                    threads[i2] = stored.get(__state, thread, new Object[0]);
                }
                Arrays.sort(threads);
                __callback.accept((InfoThread[])threads);
            }, ReplyHandler.IGNORED);
        }
    }

    public void eventSet(JDWPEventKind __kind, JDWPSuspendPolicy __suspend, EventModifier[] __modifiers, EventHandler<?> __handler, IntConsumer __postResponse) throws NullPointerException {
        if (__kind == null || __suspend == null || __handler == null) {
            throw new NullPointerException("NARG");
        }
        try (JDWPPacket out = this.request(JDWPCommandSet.EVENT_REQUEST, JDWPCommandSetEventRequest.SET);){
            out.writeByte(__kind.debuggerId());
            out.writeByte(__suspend.debuggerId());
            if (__modifiers == null || __modifiers.length == 0) {
                out.writeInt(0);
            } else {
                out.writeInt(__modifiers.length);
                for (EventModifier modifier : __modifiers) {
                    modifier.write(this, out);
                }
            }
            this.send(out, (__ignored, __reply) -> {
                int eventId = __reply.readInt();
                if (JDWPCommLink.DEBUG) {
                    Debugging.debugNote("Awaiting Event %d -> %s", eventId, __handler);
                }
                this.eventHandlers.put(eventId, __handler);
                if (__postResponse != null) {
                    __postResponse.accept(eventId);
                }
            }, ReplyHandler.IGNORED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStarted() {
        DebuggerState debuggerState = this;
        synchronized (debuggerState) {
            return this._hasStarted;
        }
    }

    public void lookupClass(ClassName __className, Consumer<InfoClass[]> __found, Consumer<Throwable> __notFound) throws NullPointerException {
        if (__className == null) {
            throw new NullPointerException("NARG");
        }
        try (JDWPPacket packet = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.CLASSES_BY_SIGNATURE);){
            packet.writeString(__className.field().toString());
            this.send(packet, (__state, __reply) -> {
                if (__reply == null) {
                    __notFound.accept(new Throwable("Timed out."));
                    return;
                }
                if (__reply.hasError()) {
                    __notFound.accept(new Throwable(__reply.error().toString()));
                    return;
                }
                int count = __reply.readInt();
                if (count == 0) {
                    __notFound.accept(new Throwable("No classes found."));
                    return;
                }
                StoredInfo<InfoClass> classStorage = __state.storedInfo.getClasses();
                InfoClass[] foundClasses = new InfoClass[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    __reply.readByte();
                    foundClasses[i2] = classStorage.get(__state, __reply.readId(JDWPIdKind.REFERENCE_TYPE_ID), new Object[0]);
                    __reply.readInt();
                }
                __found.accept(foundClasses);
            }, ReplyHandler.IGNORED);
        }
    }

    public FrameLocation readLocation(InfoThread __inThread, JDWPPacket __packet) throws NullPointerException {
        if (__inThread == null || __packet == null) {
            throw new NullPointerException("NARG");
        }
        __packet.readByte();
        JDWPId classId = __packet.readId(JDWPIdKind.REFERENCE_TYPE_ID);
        JDWPId methodId = __packet.readId(JDWPIdKind.METHOD_ID);
        long index = __packet.readLong();
        StoredInfoManager storedInfo = this.storedInfo;
        InfoClass inClass = storedInfo.getClasses().get(this, classId, new Object[0]);
        return new FrameLocation(__inThread, inClass, inClass.getMethod(methodId), index);
    }

    public JDWPPacket reply(JDWPPacket __id, JDWPErrorType __error) throws NullPointerException {
        if (__id == null || __error == null) {
            throw new NullPointerException("NARG");
        }
        return this.reply(__id.id(), __error);
    }

    public JDWPPacket reply(int __id, JDWPErrorType __error) throws NullPointerException {
        if (__error == null) {
            throw new NullPointerException("NARG");
        }
        return this.commLink.reply(__id, __error);
    }

    public JDWPPacket request(JDWPCommandSet __commandSet, JDWPCommand __command) throws NullPointerException {
        return this.commLink.request(__commandSet, __command);
    }

    public JDWPPacket request(int __commandSet, int __command) {
        return this.commLink.request(__commandSet, __command);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        JDWPCommLink link = this.commLink;
        TallyTracker receiveTally = this.receiveTally;
        PacketDefer defer = this.defer;
        this.__defaultInit();
        boolean sizesKnown = false;
        while (true) {
            if (JDWPCommLink.DEBUG) {
                Debugging.debugNote("Polling JDWPPacket...");
            }
            if (!sizesKnown && (sizesKnown = link.areSizesKnown())) {
                if (JDWPCommLink.DEBUG) {
                    Debugging.debugNote("Processing deferred packets...");
                }
                JDWPIdSizes sizes = link.idSizes();
                JDWPPacket[] deferred = defer.removeAll();
                if (deferred != null) {
                    JDWPPacket[] jDWPPacketArray = deferred;
                    int n2 = jDWPPacketArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        JDWPPacket copy;
                        try (JDWPPacket packet = copy = jDWPPacketArray[i2];){
                            packet.setIdSizes(sizes);
                            this.__process(packet.resetReadPosition());
                            continue;
                        }
                    }
                }
                if (this.ready != null) {
                    this.ready.accept(this);
                }
            }
            try {
                JDWPPacket packet = link.poll();
                Throwable throwable = null;
                try {
                    if (JDWPCommLink.DEBUG) {
                        Debugging.debugNote("DEBUGGER <- %s", packet);
                        if (packet != null) {
                            try (HexDumpOutputStream dump = new HexDumpOutputStream(System.err);){
                                dump.write(packet.toByteArray());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (packet == null) {
                        if (!JDWPCommLink.DEBUG) break;
                        Debugging.debugNote("JDWP Interrupted/Terminated.");
                        break;
                    }
                    receiveTally.increment();
                    this.__process(packet);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (packet == null) continue;
                    if (throwable != null) {
                        try {
                            packet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    packet.close();
                    continue;
                }
            }
            catch (JDWPException __e) {
                __e.printStackTrace(System.err);
                if (link.isShutdown()) break;
                continue;
            }
            break;
        }
        if (JDWPCommLink.DEBUG) {
            Debugging.debugNote("JDWP Loop End...");
        }
        this.disconnectedTally.increment();
    }

    public void send(JDWPPacket __packet) throws NullPointerException {
        this.send(__packet, null, null);
    }

    public void send(JDWPPacket __packet, ReplyHandler __pass, ReplyHandler __fail) throws IllegalArgumentException, NullPointerException {
        this.send(__packet, __pass, __fail, null);
    }

    public void send(JDWPPacket __packet, ReplyHandler __pass, ReplyHandler __fail, ReplyHandler __always) throws IllegalArgumentException, NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        if (__pass != null) {
            if (__packet.isReply()) {
                throw new IllegalArgumentException("Cannot handle a reply to a reply.");
            }
            this.replies.await(__packet.id(), __pass, __fail, __always);
            this.waitingTally.increment();
        }
        if (JDWPCommLink.DEBUG) {
            Debugging.debugNote("DEBUGGER -> %s (%x)", __packet, System.identityHashCode(__packet));
        }
        this.commLink.send(__packet);
        this.sentTally.increment();
    }

    public void sendKnown(JDWPPacket __out, KnownValue<?> __value, KnownValueCallback<?> __sync, ReplyHandler __pass, ReplyHandler __fail) {
        this.send(__out, __pass, __fail, (__state, __reply) -> {
            if (__sync != null) {
                __sync.sync(__state, __value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarted() {
        DebuggerState debuggerState = this;
        synchronized (debuggerState) {
            this._hasStarted = true;
        }
    }

    public void threadResume(InfoThread __thread, Runnable __done) throws NullPointerException {
        if (__thread == null) {
            throw new NullPointerException("NARG");
        }
        try (JDWPPacket out = this.request(JDWPCommandSet.THREAD_REFERENCE, JDWPCommandSetThreadReference.RESUME);){
            out.writeId(__thread.id);
            this.send(out, (__ignored, __reply) -> {
                if (__done != null) {
                    __done.run();
                }
            }, ReplyHandler.IGNORED);
        }
    }

    public void threadResumeAll(Runnable __done) {
        try (JDWPPacket out = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.RESUME);){
            this.send(out, (__ignored, __reply) -> {
                if (__done != null) {
                    __done.run();
                }
            }, ReplyHandler.IGNORED);
        }
    }

    public void threadStep(InfoThread __thread, int __count, JDWPStepDepth __depth, JDWPStepSize __size, EventHandler<SingleStepEvent> __handler) throws NullPointerException {
        if (__thread == null || __depth == null || __size == null) {
            throw new NullPointerException("NARG");
        }
        EventModifier[] modifiers = new EventModifier[]{new EventModifierCount(__count), new EventModifierSingleStep(__thread, __depth, __size)};
        this.eventSet(JDWPEventKind.SINGLE_STEP, JDWPSuspendPolicy.EVENT_THREAD, modifiers, __handler, __id -> this.threadResume(__thread, null));
    }

    public void threadSuspend(InfoThread __thread, Runnable __done) throws NullPointerException {
        if (__thread == null) {
            throw new NullPointerException("NARG");
        }
        try (JDWPPacket out = this.request(JDWPCommandSet.THREAD_REFERENCE, JDWPCommandSetThreadReference.SUSPEND);){
            out.writeId(__thread.id);
            this.send(out, (__ignored, __reply) -> {
                if (__done != null) {
                    __done.run();
                }
            }, ReplyHandler.IGNORED);
        }
    }

    public void threadSuspendAll(Runnable __done) {
        try (JDWPPacket out = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.SUSPEND);){
            this.send(out, (__ignored, __reply) -> {
                if (__done != null) {
                    __done.run();
                }
            }, ReplyHandler.IGNORED);
        }
    }

    private void __defaultInit() {
        try (JDWPPacket packet = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.ID_SIZES);){
            this.send(packet, (__state, __reply) -> {
                Debugging.debugNote("Read ID Sizes...");
                int[] sizes = new int[5];
                for (int i2 = 0; i2 < sizes.length; ++i2) {
                    sizes[i2] = __reply.readInt();
                }
                JDWPIdSizes result = new JDWPIdSizes(sizes);
                this.commLink.setIdSizes(result);
                Debugging.debugNote("Sizes read: %s", result);
            }, ReplyHandler.IGNORED);
        }
        packet = this.request(JDWPCommandSet.VIRTUAL_MACHINE, JDWPCommandSetVirtualMachine.VERSION);
        var2_2 = null;
        try {
            this.send(packet, this::__remoteVmInfo, ReplyHandler.IGNORED);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (packet != null) {
                if (var2_2 != null) {
                    try {
                        packet.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    packet.close();
                }
            }
        }
        this.capabilities.update(this);
        this.eventSet(JDWPEventKind.THREAD_START, JDWPSuspendPolicy.NONE, null, (__state, __event) -> {}, null);
        this.eventSet(JDWPEventKind.THREAD_DEATH, JDWPSuspendPolicy.NONE, null, (__state, __reply) -> {}, null);
        this.eventSet(JDWPEventKind.EXCEPTION, JDWPSuspendPolicy.ALL, new EventModifier[]{new EventModifierClassMatch("cc.squirreljme.emulator.__PseudoBreakpoint__")}, (__state, __reply) -> {}, null);
    }

    private void __process(JDWPPacket __packet) throws NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        JDWPCommLink link = this.commLink;
        PacketDefer defer = this.defer;
        try {
            if (__packet.isReply()) {
                this.__processReply(__packet);
            } else {
                this.__processRequest(__packet);
            }
        }
        catch (JDWPIdSizeUnknownException ignored) {
            defer.defer(link, __packet);
        }
        catch (JDWPException __e) {
            __e.printStackTrace();
            throw __e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __processReply(JDWPPacket __packet) throws NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        AwaitingReply handler = this.replies.remove(__packet.id());
        if (handler == null) {
            if (JDWPCommLink.DEBUG) {
                Debugging.debugNote("No handler for reply %d...", __packet.id());
            }
            return;
        }
        int latency = (int)Math.min(Integer.MAX_VALUE, (System.nanoTime() - handler.nanoTime) / 1000000L);
        this.latency.set(latency);
        if (JDWPCommLink.DEBUG) {
            Debugging.debugNote("Packet %d (%08x): Latency %d ms", handler.id, handler.id, latency);
        }
        this.waitingTally.decrement();
        try {
            if (__packet.hasError()) {
                if (handler.fail != null) {
                    handler.fail.handlePacket(this, __packet);
                }
            } else if (handler.pass != null) {
                handler.pass.handlePacket(this, __packet);
            }
        }
        finally {
            if (handler.always != null) {
                handler.always.handlePacket(this, __packet);
            }
        }
    }

    private void __processRequest(JDWPPacket __packet) throws NullPointerException {
        if (__packet == null) {
            throw new NullPointerException("NARG");
        }
        if (__packet.commandSetId() == 64 && __packet.command() == 100) {
            if (JDWPCommLink.DEBUG) {
                Debugging.debugNote("Process event: %s", __packet);
            }
            EventProcessor.handle(this, __packet);
            return;
        }
        if (JDWPCommLink.DEBUG) {
            Debugging.debugNote("Handle non-event?");
        }
    }

    private void __remoteVmInfo(DebuggerState __state, JDWPPacket __reply) {
        String desc = __reply.readString();
        int jdwpMajor = __reply.readInt();
        int jdwpMinor = __reply.readInt();
        String vmVersion = __reply.readString();
        String vmName = __reply.readString();
        if (desc.contains("SquirrelJME") || vmName.contains("SquirrelJME")) {
            this._locationInterpret = FrameLocationInterpret.INDEX;
        }
        Debugging.debugNote("Description: %s", desc);
        Debugging.debugNote("JDWP Major: %d", jdwpMajor);
        Debugging.debugNote("JDWP Minor: %d", jdwpMinor);
        Debugging.debugNote("VM Version: %s", vmVersion);
        Debugging.debugNote("VM Name: %s", vmName);
    }
}

