/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.EventHandler;
import cc.squirreljme.debugger.FrameLocation;
import cc.squirreljme.debugger.InfoThread;
import cc.squirreljme.debugger.SingleStepEvent;
import cc.squirreljme.debugger.StoredInfo;
import cc.squirreljme.debugger.ThreadStartEvent;
import cc.squirreljme.jdwp.JDWPEventKind;
import cc.squirreljme.jdwp.JDWPId;
import cc.squirreljme.jdwp.JDWPIdKind;
import cc.squirreljme.jdwp.JDWPPacket;
import cc.squirreljme.jdwp.JDWPSuspendPolicy;
import cc.squirreljme.runtime.cldc.debug.Debugging;
import cc.squirreljme.runtime.cldc.util.EnumTypeMap;
import java.util.Map;

public enum EventProcessor {
    SINGLE_STEP(JDWPEventKind.SINGLE_STEP){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            JDWPId threadId = __packet.readId(JDWPIdKind.THREAD_ID);
            InfoThread thread = threadStore.get(__state, threadId, new Object[0]);
            FrameLocation location = __state.readLocation(thread, __packet);
            __state.context.optional(thread);
            if (__handler != null) {
                __handler.handle(__state, new SingleStepEvent(thread, __suspend, location));
            }
        }
    }
    ,
    BREAKPOINT(JDWPEventKind.BREAKPOINT){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            JDWPId threadId = __packet.readId(JDWPIdKind.THREAD_ID);
            InfoThread thread = threadStore.get(__state, threadId, new Object[0]);
            __state.readLocation(thread, __packet);
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    FRAME_POP(JDWPEventKind.FRAME_POP){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    EXCEPTION(JDWPEventKind.EXCEPTION){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            JDWPId threadId = __packet.readId(JDWPIdKind.THREAD_ID);
            InfoThread thread = threadStore.get(__state, threadId, new Object[0]);
            __state.readLocation(thread, __packet);
            __packet.readTaggedObjectId();
            __state.readLocation(thread, __packet);
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    USER_DEFINED(JDWPEventKind.USER_DEFINED){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            JDWPId threadId = __packet.readId(JDWPIdKind.THREAD_ID);
            InfoThread thread = threadStore.get(__state, threadId, new Object[0]);
            __state.context.optional(thread);
        }
    }
    ,
    THREAD_START(JDWPEventKind.THREAD_START){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            JDWPId threadId;
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            InfoThread thread = threadStore.get(__state, threadId = __packet.readId(JDWPIdKind.THREAD_ID), new Object[0]);
            if (thread != null) {
                thread.isStarted.set(true);
                __state.context.optional(thread);
            }
            if (__handler != null) {
                __handler.handle(__state, new ThreadStartEvent(thread, __suspend));
            }
        }
    }
    ,
    THREAD_DEATH(JDWPEventKind.THREAD_DEATH){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            JDWPId threadId;
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            InfoThread thread = threadStore.get(__state, threadId = __packet.readId(JDWPIdKind.THREAD_ID), new Object[0]);
            if (thread != null) {
                thread.isDead.set(true);
            }
            __state.context.drop(thread);
        }
    }
    ,
    CLASS_PREPARE(JDWPEventKind.CLASS_PREPARE){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            JDWPId threadId = __packet.readId(JDWPIdKind.THREAD_ID);
            InfoThread thread = threadStore.get(__state, threadId, new Object[0]);
            __packet.readByte();
            __packet.readId(JDWPIdKind.REFERENCE_TYPE_ID);
            __packet.readString();
            __packet.readInt();
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    CLASS_UNLOAD(JDWPEventKind.CLASS_UNLOAD){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            __packet.readString();
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    CLASS_LOAD(JDWPEventKind.CLASS_LOAD){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    FIELD_ACCESS(JDWPEventKind.FIELD_ACCESS){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    FIELD_MODIFICATION(JDWPEventKind.FIELD_MODIFICATION){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todo(new Object[]{"Implement %s", this});
        }
    }
    ,
    EXCEPTION_CATCH(JDWPEventKind.EXCEPTION_CATCH){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    METHOD_ENTRY(JDWPEventKind.METHOD_ENTRY){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    METHOD_EXIT(JDWPEventKind.METHOD_EXIT){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    METHOD_EXIT_WITH_RETURN_VALUE(JDWPEventKind.METHOD_EXIT_WITH_RETURN_VALUE){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    MONITOR_CONTENDED_ENTER(JDWPEventKind.MONITOR_CONTENDED_ENTER){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    MONITOR_CONTENDED_EXIT(JDWPEventKind.MONITOR_CONTENDED_EXIT){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    MONITOR_WAIT(JDWPEventKind.MONITOR_WAIT){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    MONITOR_WAITED(JDWPEventKind.MONITOR_WAITED){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    }
    ,
    VM_START(JDWPEventKind.VM_START){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            JDWPId threadId;
            StoredInfo<InfoThread> threadStore = __state.storedInfo.getThreads();
            InfoThread thread = threadStore.get(__state, threadId = __packet.readId(JDWPIdKind.OBJECT_ID), new Object[0]);
            if (thread != null) {
                thread.isStarted.set(true);
            }
            __state.setStarted();
            __state.context.optional(thread);
            if (__state.preferences.resumeOnConnect) {
                if (__suspend == JDWPSuspendPolicy.EVENT_THREAD) {
                    __state.threadResume(thread, null);
                } else if (__suspend == JDWPSuspendPolicy.ALL) {
                    __state.threadResumeAll(null);
                }
            }
        }
    }
    ,
    VM_DEATH(JDWPEventKind.VM_DEATH){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            __state.vmDeadTally.increment();
        }
    }
    ,
    UNCONDITIONAL_BREAKPOINT(JDWPEventKind.UNCONDITIONAL_BREAKPOINT){

        @Override
        protected void process(DebuggerState __state, JDWPPacket __packet, JDWPSuspendPolicy __suspend, EventHandler __handler) {
            Debugging.todoNote("Implement %s", new Object[]{this});
        }
    };

    private static final Map<JDWPEventKind, EventProcessor> _EVENT_MAP;
    public final JDWPEventKind kind;

    private EventProcessor(JDWPEventKind __kind) throws NullPointerException {
        if (__kind == null) {
            throw new NullPointerException("NARG");
        }
        this.kind = __kind;
    }

    protected abstract void process(DebuggerState var1, JDWPPacket var2, JDWPSuspendPolicy var3, EventHandler var4);

    public static EventProcessor of(JDWPEventKind __kind) throws NullPointerException {
        if (__kind == null) {
            throw new NullPointerException("NARG");
        }
        return _EVENT_MAP.get(__kind);
    }

    public static void handle(DebuggerState __state, JDWPPacket __packet) throws NullPointerException {
        if (__state == null || __packet == null) {
            throw new NullPointerException("NARG");
        }
        if (__packet.length() == 0) {
            return;
        }
        JDWPSuspendPolicy suspend = JDWPSuspendPolicy.of(__packet.readByte());
        int numEvents = __packet.readInt();
        for (int seq = 0; seq < numEvents; ++seq) {
            byte rawKind = __packet.readByte();
            JDWPEventKind kind = JDWPEventKind.of(rawKind);
            if (kind == null) {
                Debugging.debugNote("Unknown event kind: %d", rawKind);
                return;
            }
            int requestId = __packet.readInt();
            EventHandler<?> handler = __state.eventHandlers.eventHandler(requestId);
            EventProcessor processor = EventProcessor.of(kind);
            Debugging.debugNote("Process event #%d %d of type %s (suspend=%s)...", new Object[]{seq, requestId, processor, suspend});
            processor.process(__state, __packet, suspend, handler);
        }
    }

    static {
        EnumTypeMap map = new EnumTypeMap(JDWPEventKind.class, (Enum[])JDWPEventKind.values());
        for (EventProcessor processor : EventProcessor.values()) {
            map.put(processor.kind, processor);
        }
        _EVENT_MAP = map;
    }
}

