/*
 * Decompiled with CFR 0.152.
 */
package cc.squirreljme.debugger;

import cc.squirreljme.debugger.DebuggerState;
import cc.squirreljme.debugger.InfoKind;
import cc.squirreljme.jdwp.JDWPId;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class Info
implements Comparable<Info> {
    protected final JDWPId id;
    protected final InfoKind kind;
    private final Reference<DebuggerState> _state;
    private volatile boolean _disposed;

    public Info(DebuggerState __state, JDWPId __id, InfoKind __kind) throws NullPointerException {
        if (__state == null || __kind == null) {
            throw new NullPointerException("NARG");
        }
        this._state = new WeakReference<DebuggerState>(__state);
        this.id = __id;
        this.kind = __kind;
    }

    protected abstract boolean internalUpdate(DebuggerState var1) throws NullPointerException;

    @Override
    public int compareTo(@NotNull Info __o) {
        Class<?> b2;
        if (this == __o) {
            return 0;
        }
        Class<?> a2 = this.getClass();
        if (a2 != (b2 = __o.getClass())) {
            return a2.getName().compareTo(b2.getName());
        }
        return this.id.compareTo(__o.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispose() {
        Info info = this;
        synchronized (info) {
            this._disposed = true;
            this.notifyAll();
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object __o) {
        if (__o == this) {
            return true;
        }
        if (!(__o instanceof Info)) {
            return false;
        }
        return this.compareTo((Info)__o) == 0;
    }

    protected DebuggerState internalState() {
        DebuggerState result = this._state.get();
        if (result == null) {
            throw new IllegalStateException("GCGC");
        }
        return result;
    }

    protected String internalString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        Info info = this;
        synchronized (info) {
            return this._disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Info info = this;
        synchronized (info) {
            if (this._disposed) {
                return String.format("DISPOSED %s#%s", new Object[]{this.kind, this.id});
            }
        }
        try {
            String internalString = this.internalString();
            Info info2 = this;
            synchronized (info2) {
                if (this._disposed) {
                    return String.format("DISPOSED %s#%s", new Object[]{this.kind, this.id});
                }
                if (internalString != null) {
                    return internalString;
                }
            }
        }
        catch (Throwable __t) {
            __t.printStackTrace();
        }
        return String.format("%s#%s", new Object[]{this.kind, this.id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean update(DebuggerState __state, Consumer<Info> __callback) throws NullPointerException {
        if (__state == null) {
            throw new NullPointerException("NARG");
        }
        Info info = this;
        synchronized (info) {
            if (this._disposed) {
                return false;
            }
        }
        boolean result = this.internalUpdate(__state);
        if (!result) {
            this.dispose();
        } else if (__callback != null) {
            __callback.accept(this);
        }
        return !this.isDisposed();
    }
}

